/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.elementium;

import java.util.List;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.model.armor.ModelArmorElementium;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;

public abstract class ItemElementiumArmor
extends ItemManasteelArmor {
    private static final LazyValue<ItemStack[]> armorSet = new LazyValue(() -> new ItemStack[]{new ItemStack((IItemProvider)ModItems.elementiumHelm), new ItemStack((IItemProvider)ModItems.elementiumChest), new ItemStack((IItemProvider)ModItems.elementiumLegs), new ItemStack((IItemProvider)ModItems.elementiumBoots)});

    public ItemElementiumArmor(EquipmentSlotType type, Item.Properties props) {
        super(type, BotaniaAPI.instance().getElementiumArmorMaterial(), props);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<?> provideArmorModelForSlot(EquipmentSlotType slot) {
        return new ModelArmorElementium(slot);
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlotType slot) {
        return (Boolean)ConfigHandler.CLIENT.enableArmorModels.get() != false ? "botania:textures/model/armor_elementium.png" : (slot == EquipmentSlotType.LEGS ? "botania:textures/model/elementium_1.png" : "botania:textures/model/elementium_0.png");
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return (ItemStack[])armorSet.func_179281_c();
    }

    @Override
    public boolean hasArmorSetItem(PlayerEntity player, EquipmentSlotType slot) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.func_184582_a(slot);
        if (stack.func_190926_b()) {
            return false;
        }
        switch (slot) {
            case HEAD: {
                return stack.func_77973_b() == ModItems.elementiumHelm;
            }
            case CHEST: {
                return stack.func_77973_b() == ModItems.elementiumChest;
            }
            case LEGS: {
                return stack.func_77973_b() == ModItems.elementiumLegs;
            }
            case FEET: {
                return stack.func_77973_b() == ModItems.elementiumBoots;
            }
        }
        return false;
    }

    @Override
    public IFormattableTextComponent getArmorSetName() {
        return new TranslationTextComponent("botania.armorset.elementium.name");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addArmorSetDescription(ItemStack stack, List<ITextComponent> list) {
        super.addArmorSetDescription(stack, list);
        list.add((ITextComponent)new TranslationTextComponent("botania.armorset.elementium.desc").func_240699_a_(TextFormatting.GRAY));
    }
}

