/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.mana.IManaGivingItem;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelPick;
import vazkii.botania.common.item.relic.ItemThorRing;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ItemTerraPick
extends ItemManasteelPick
implements IManaItem,
ISequentialBreaker {
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_MANA = "mana";
    private static final String TAG_TIPPED = "tipped";
    private static final int MAX_MANA = Integer.MAX_VALUE;
    private static final int MANA_PER_DAMAGE = 100;
    private static final List<Material> MATERIALS = Arrays.asList(Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g, Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B);
    public static final int[] LEVELS = new int[]{0, 10000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] CREATIVE_MANA = new int[]{9999, 999999, 9999999, 99999999, 999999999, 0x7FFFFFFE};

    public ItemTerraPick(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), props, -2.8f);
    }

    public void func_150895_a(@Nonnull ItemGroup tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int mana : CREATIVE_MANA) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemTerraPick.setMana(stack, mana);
                list.add((Object)stack);
            }
            ItemStack stack = new ItemStack((IItemProvider)this);
            ItemTerraPick.setMana(stack, CREATIVE_MANA[1]);
            ItemTerraPick.setTipped(stack);
            list.add((Object)stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> stacks, ITooltipFlag flags) {
        TranslationTextComponent rank = new TranslationTextComponent("botania.rank" + ItemTerraPick.getLevel(stack));
        TranslationTextComponent rankFormat = new TranslationTextComponent("botaniamisc.toolRank", new Object[]{rank});
        stacks.add((ITextComponent)rankFormat);
        if (this.getMana(stack) == Integer.MAX_VALUE) {
            stacks.add((ITextComponent)new TranslationTextComponent("botaniamisc.getALife").func_240699_a_(TextFormatting.RED));
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.getMana(stack);
        int level = ItemTerraPick.getLevel(stack);
        if (level != 0) {
            this.setEnabled(stack, !ItemTerraPick.isEnabled(stack));
            if (!world.field_72995_K) {
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.terraPickMode, SoundCategory.PLAYERS, 0.5f, 0.4f);
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    @Override
    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        return ctx.func_195999_j() == null || ctx.func_195999_j().func_225608_bj_() ? super.func_195939_a(ctx) : ActionResultType.PASS;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (ItemTerraPick.isEnabled(stack)) {
            int level = ItemTerraPick.getLevel(stack);
            if (level == 0) {
                this.setEnabled(stack, false);
            } else if (entity instanceof PlayerEntity && !((PlayerEntity)entity).field_82175_bq) {
                this.addMana(stack, -level);
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        BlockRayTraceResult raycast = ToolCommons.raytraceFromEntity((Entity)player, 10.0, false);
        if (!player.field_70170_p.field_72995_K && raycast.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Direction face = raycast.func_216354_b();
            this.breakOtherBlock(player, stack, pos, pos, face);
            BotaniaAPI.instance().breakOnAllCursors(player, stack, pos, face);
        }
        return false;
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    @Override
    public void breakOtherBlock(PlayerEntity player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        if (!ItemTerraPick.isEnabled(stack)) {
            return;
        }
        World world = player.field_70170_p;
        Material mat = world.func_180495_p(pos).func_185904_a();
        if (!MATERIALS.contains(mat)) {
            return;
        }
        if (world.func_175623_d(pos)) {
            return;
        }
        boolean thor = !ItemThorRing.getThorRing(player).func_190926_b();
        boolean doX = thor || side.func_82601_c() == 0;
        boolean doY = thor || side.func_96559_d() == 0;
        boolean doZ = thor || side.func_82599_e() == 0;
        int origLevel = ItemTerraPick.getLevel(stack);
        int level = origLevel + (thor ? 1 : 0);
        if (ItemTemperanceStone.hasTemperanceActive(player) && level > 2) {
            level = 2;
        }
        int range = level - 1;
        int rangeY = Math.max(1, range);
        if (range == 0 && level != 1) {
            return;
        }
        Vector3i beginDiff = new Vector3i(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
        Vector3i endDiff = new Vector3i(doX ? range : 0, doY ? rangeY * 2 - 1 : 0, doZ ? range : 0);
        ToolCommons.removeBlocksInIteration(player, stack, world, pos, beginDiff, endDiff, state -> MATERIALS.contains(state.func_185904_a()), ItemTerraPick.isTipped(stack));
        if (origLevel == 5) {
            PlayerHelper.grantCriterion((ServerPlayerEntity)player, ResourceLocationHelper.prefix("challenge/rank_ss_pick"), "code_triggered");
        }
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public static boolean isTipped(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_TIPPED, false);
    }

    public static void setTipped(ItemStack stack) {
        ItemNBTHelper.setBoolean(stack, TAG_TIPPED, true);
    }

    public static boolean isEnabled(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_ENABLED, false);
    }

    void setEnabled(ItemStack stack, boolean enabled) {
        ItemNBTHelper.setBoolean(stack, TAG_ENABLED, enabled);
    }

    public static void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, mana);
    }

    @Override
    public int getMana(ItemStack stack) {
        return ItemTerraPick.getMana_(stack);
    }

    public static int getMana_(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
    }

    public static int getLevel(ItemStack stack) {
        int mana = ItemTerraPick.getMana_(stack);
        for (int i = LEVELS.length - 1; i > 0; --i) {
            if (mana < LEVELS[i]) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    @Override
    public void addMana(ItemStack stack, int mana) {
        ItemTerraPick.setMana(stack, Math.min(this.getMana(stack) + mana, Integer.MAX_VALUE));
    }

    @Override
    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return true;
    }

    @Override
    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return !(otherStack.func_77973_b() instanceof IManaGivingItem);
    }

    @Override
    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    @Override
    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    @Override
    public boolean isNoExport(ItemStack stack) {
        return true;
    }

    @Override
    public boolean disposeOfTrashBlocks(ItemStack stack) {
        return ItemTerraPick.isTipped(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack before, @Nonnull ItemStack after, boolean slotChanged) {
        return after.func_77973_b() != this || ItemTerraPick.isEnabled(before) != ItemTerraPick.isEnabled(after);
    }
}

