/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemDice
extends ItemRelic {
    public ItemDice(Item.Properties props) {
        super(props);
    }

    public static Item[] getRelics() {
        return new Item[]{ModItems.infiniteFruit, ModItems.kingKey, ModItems.flugelEye, ModItems.thorRing, ModItems.odinRing, ModItems.lokiRing};
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isRightPlayer(player, stack)) {
            if (world.field_72995_K) {
                return ActionResult.func_226248_a_((Object)stack);
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            ArrayList<Integer> possible = new ArrayList<Integer>();
            for (int i = 0; i < 6; ++i) {
                if (this.hasRelicAlready(player, i)) continue;
                possible.add(i);
            }
            if (possible.isEmpty()) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("botaniamisc.dudDiceRoll", new Object[]{world.field_73012_v.nextInt(6) + 1}).func_240699_a_(TextFormatting.DARK_GREEN), Util.field_240973_b_);
                stack.func_190918_g(1);
                return ActionResult.func_226248_a_((Object)stack);
            }
            int relic = (Integer)possible.get(world.field_73012_v.nextInt(possible.size()));
            player.func_145747_a((ITextComponent)new TranslationTextComponent("botaniamisc.diceRoll", new Object[]{relic + 1}).func_240699_a_(TextFormatting.DARK_GREEN), Util.field_240973_b_);
            return ActionResult.func_226248_a_((Object)new ItemStack((IItemProvider)ItemDice.getRelics()[relic]));
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    @Override
    public boolean shouldDamageWrongPlayer() {
        return false;
    }

    private boolean hasRelicAlready(PlayerEntity player, int relic) {
        if (relic < 0 || relic > 6 || !(player instanceof ServerPlayerEntity)) {
            return true;
        }
        ServerPlayerEntity mpPlayer = (ServerPlayerEntity)player;
        Item item = ItemDice.getRelics()[relic];
        ResourceLocation advId = ((IRelic)item).getAdvancement();
        if (advId != null) {
            Advancement adv = ServerLifecycleHooks.getCurrentServer().func_191949_aK().func_192778_a(advId);
            return adv != null && mpPlayer.func_192039_O().func_192747_a(adv).func_192105_a();
        }
        return false;
    }
}

