/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.brew.ModPotions;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemTornadoRod
extends Item
implements IManaUsingItem,
IAvatarWieldable {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_tornado.png");
    private static final int FLY_TIME = 20;
    private static final int FALL_MULTIPLIER = 3;
    private static final int MAX_COUNTER = 60;
    private static final int COST = 350;
    private static final String TAG_FLYING = "flying";
    private static final String TAG_FLYCOUNTER = "flyCounter";

    public ItemTornadoRod(Item.Properties props) {
        super(props);
    }

    public void func_77663_a(ItemStack stack, World world, Entity ent, int slot, boolean active) {
        if (ent instanceof PlayerEntity) {
            boolean held;
            PlayerEntity player = (PlayerEntity)ent;
            boolean damaged = this.getFlyCounter(stack) > 0;
            boolean bl = held = player.func_184614_ca() == stack || player.func_184592_cb() == stack;
            if (damaged && !ItemTornadoRod.isFlying(stack)) {
                this.setFlyCounter(stack, this.getFlyCounter(stack) - 1);
            }
            if (this.getFlyCounter(stack) >= 60) {
                this.setFlying(stack, false);
            } else if (ItemTornadoRod.isFlying(stack)) {
                if (held) {
                    player.field_70143_R = 0.0f;
                    double my = IManaProficiencyArmor.hasProficiency(player, stack) ? 1.6 : 1.25;
                    Vector3d oldMot = player.func_213322_ci();
                    player.func_213317_d(new Vector3d(oldMot.func_82615_a(), my, oldMot.func_82616_c()));
                    player.func_184185_a(ModSounds.airRod, 0.1f, 0.25f);
                    for (int i = 0; i < 5; ++i) {
                        WispParticleData data = WispParticleData.wisp(0.35f + (float)Math.random() * 0.1f, 0.25f, 0.25f, 0.25f);
                        world.func_195594_a((IParticleData)data, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (double)(0.2f * (float)(Math.random() - 0.5)), (double)(-0.01f * (float)Math.random()), (double)(0.2f * (float)(Math.random() - 0.5)));
                    }
                }
                this.setFlyCounter(stack, this.getFlyCounter(stack) + 3);
                if (this.getFlyCounter(stack) == 60) {
                    this.setFlying(stack, false);
                }
            }
            if (damaged) {
                player.field_70143_R = 0.0f;
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getFlyCounter(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getFlyCounter(stack) / 60.0;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int fly = this.getFlyCounter(stack);
        if (fly == 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 350, false)) {
            ManaItemHandler.instance().requestManaExactForTool(stack, player, 350, true);
            this.setFlying(stack, true);
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public static boolean isFlying(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_FLYING, false);
    }

    private void setFlying(ItemStack stack, boolean flying) {
        ItemNBTHelper.setBoolean(stack, TAG_FLYING, flying);
    }

    private int getFlyCounter(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(TAG_FLYCOUNTER);
    }

    private void setFlyCounter(ItemStack stack, int counter) {
        stack.func_196082_o().func_74768_a(TAG_FLYCOUNTER, counter);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public void onAvatarUpdate(IAvatarTile tile, ItemStack stack) {
        TileEntity te = (TileEntity)tile;
        World world = te.func_145831_w();
        if (tile.getCurrentMana() >= 350 && tile.isEnabled()) {
            int range = 5;
            int rangeY = 3;
            List players = world.func_217357_a(PlayerEntity.class, new AxisAlignedBB(te.func_174877_v().func_177963_a(-0.5 - (double)range, -0.5 - (double)rangeY, -0.5 - (double)range), te.func_174877_v().func_177963_a(0.5 + (double)range, 0.5 + (double)rangeY, 0.5 + (double)range)));
            for (PlayerEntity p : players) {
                if (!(p.func_213322_ci().func_82617_b() > 0.3) || !(p.func_213322_ci().func_82617_b() < 2.0) || p.func_225608_bj_()) continue;
                p.func_213293_j(p.func_213322_ci().func_82615_a(), 2.8, p.func_213322_ci().func_82616_c());
                for (int i = 0; i < 20; ++i) {
                    for (int j = 0; j < 5; ++j) {
                        WispParticleData data = WispParticleData.wisp(0.35f + (float)Math.random() * 0.1f, 0.25f, 0.25f, 0.25f);
                        world.func_195594_a((IParticleData)data, p.func_226277_ct_(), p.func_226278_cu_() + (double)i, p.func_226281_cx_(), (double)(0.2f * (float)(Math.random() - 0.5)), (double)(-0.01f * (float)Math.random()), (double)(0.2f * (float)(Math.random() - 0.5)));
                    }
                }
                if (world.field_72995_K) continue;
                p.field_70170_p.func_184148_a(null, p.func_226277_ct_(), p.func_226278_cu_(), p.func_226281_cx_(), ModSounds.dash, SoundCategory.PLAYERS, 1.0f, 1.0f);
                p.func_195064_c(new EffectInstance(ModPotions.featherfeet, 100, 0));
                tile.receiveMana(-350);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return newStack.func_77973_b() != this || ItemTornadoRod.isFlying(oldStack) != ItemTornadoRod.isFlying(newStack);
    }

    @Override
    public ResourceLocation getOverlayResource(IAvatarTile tile, ItemStack stack) {
        return avatarOverlay;
    }
}

