/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.world.MysticalFlowerConfig;
import vazkii.botania.common.world.MysticalFlowerFeature;
import vazkii.botania.common.world.MysticalMushroomFeature;

public class ModFeatures {
    public static final Feature<MysticalFlowerConfig> MYSTICAL_FLOWERS = new MysticalFlowerFeature();
    public static final Feature<MysticalFlowerConfig> MYSTICAL_MUSHROOMS = new MysticalMushroomFeature();
    public static final Set<BiomeDictionary.Type> TYPE_BLACKLIST = ImmutableSet.of((Object)BiomeDictionary.Type.DEAD, (Object)BiomeDictionary.Type.NETHER, (Object)BiomeDictionary.Type.END, (Object)BiomeDictionary.Type.SNOWY, (Object)BiomeDictionary.Type.WASTELAND, (Object)BiomeDictionary.Type.VOID, (Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MUSHROOM});

    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry r = event.getRegistry();
        ModBlocks.register(r, "mystical_flowers", MYSTICAL_FLOWERS);
        ModBlocks.register(r, "mystical_mushrooms", MYSTICAL_MUSHROOMS);
    }

    public static void addWorldgen() {
        for (Biome biome : Registry.field_212624_m) {
            if (BiomeDictionary.getTypes((Biome)biome).stream().noneMatch(TYPE_BLACKLIST::contains)) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, MYSTICAL_FLOWERS.func_225566_b_((IFeatureConfig)MysticalFlowerConfig.fromConfig()).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
            }
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, MYSTICAL_MUSHROOMS.func_225566_b_((IFeatureConfig)MysticalFlowerConfig.fromConfig()).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        }
    }
}

