/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.gen.feature.IFeatureConfig;
import vazkii.botania.common.core.handler.ConfigHandler;

public class MysticalFlowerConfig
implements IFeatureConfig {
    public static final Codec<MysticalFlowerConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("flower_patch_size").forGetter(MysticalFlowerConfig::getFlowerPatchSize), (App)Codec.INT.fieldOf("mushroom_patch_size").forGetter(MysticalFlowerConfig::getMushroomPatchSize), (App)Codec.INT.fieldOf("patch_count").forGetter(MysticalFlowerConfig::getPatchCount), (App)Codec.INT.fieldOf("patch_density").forGetter(MysticalFlowerConfig::getPatchDensity), (App)Codec.INT.fieldOf("patch_chance").forGetter(MysticalFlowerConfig::getPatchChance), (App)Codec.DOUBLE.fieldOf("tall_chance").forGetter(MysticalFlowerConfig::getTallChance)).apply((Applicative)instance, MysticalFlowerConfig::new));
    private final int flowerPatchSize;
    private final int mushroomPatchSize;
    private final int patchCount;
    private final int patchDensity;
    private final int patchChance;
    private final double tallChance;

    public static MysticalFlowerConfig fromConfig() {
        return new MysticalFlowerConfig((Integer)ConfigHandler.COMMON.flowerPatchSize.get(), (Integer)ConfigHandler.COMMON.mushroomQuantity.get(), (Integer)ConfigHandler.COMMON.flowerPatchSize.get(), (Integer)ConfigHandler.COMMON.flowerDensity.get(), (Integer)ConfigHandler.COMMON.flowerPatchChance.get(), (Double)ConfigHandler.COMMON.flowerTallChance.get());
    }

    public MysticalFlowerConfig(int flowerPatchSize, int mushroomPatchSize, int patchCount, int patchDensity, int patchChance, double tallChance) {
        this.flowerPatchSize = flowerPatchSize;
        this.mushroomPatchSize = mushroomPatchSize;
        this.patchCount = patchCount;
        this.patchDensity = patchDensity;
        this.patchChance = patchChance;
        this.tallChance = tallChance;
    }

    public int getFlowerPatchSize() {
        return this.flowerPatchSize;
    }

    public int getPatchCount() {
        return this.patchCount;
    }

    public int getPatchDensity() {
        return this.patchDensity;
    }

    public int getPatchChance() {
        return this.patchChance;
    }

    public double getTallChance() {
        return this.tallChance;
    }

    public int getMushroomPatchSize() {
        return this.mushroomPatchSize;
    }
}

