/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerChunkProvider;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorDimensionSettingsPreset;

public class SkyblockChunkGenerator
extends ChunkGenerator {
    public static final Codec<SkyblockChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(gen -> gen.field_222542_c), (App)Codec.LONG.fieldOf("seed").stable().forGetter(gen -> gen.seed), (App)DimensionSettings.field_236098_b_.fieldOf("settings").forGetter(gen -> gen.settings)).apply((Applicative)instance, instance.stable(SkyblockChunkGenerator::new)));
    public static DimensionSettings.Preset dimSettingsPreset;
    private final long seed;
    private final DimensionSettings settings;

    public static void init() {
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)ResourceLocationHelper.prefix("skyblock"), CODEC);
        dimSettingsPreset = new DimensionSettings.Preset("botania:skyblock", preset -> AccessorDimensionSettingsPreset.createOverworldSettings(new DimensionStructuresSettings(true), false, preset));
    }

    public SkyblockChunkGenerator(BiomeProvider provider, long seed, DimensionSettings settings) {
        super(provider, provider, settings.func_236108_a_(), seed);
        this.seed = seed;
        this.settings = settings;
    }

    public static boolean isWorldSkyblock(World world) {
        return world.func_72863_F() instanceof ServerChunkProvider && ((ServerChunkProvider)world.func_72863_F()).func_201711_g() instanceof SkyblockChunkGenerator;
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    public ChunkGenerator func_230349_a_(long newSeed) {
        return new SkyblockChunkGenerator(this.field_222542_c.func_230320_a_(newSeed), newSeed, this.settings);
    }

    public void func_230352_b_(IWorld world, StructureManager structureManager, IChunk chunk) {
    }

    public void func_225551_a_(WorldGenRegion region, IChunk chunk) {
    }

    public void func_230350_a_(long seed, BiomeManager biomes, IChunk chunk, GenerationStage.Carving stage) {
    }

    public void func_230351_a_(WorldGenRegion region, StructureManager structureManager) {
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        return 0;
    }

    public IBlockReader func_230348_a_(int p_230348_1_, int p_230348_2_) {
        return new Blockreader(new BlockState[0]);
    }
}

