/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileManaFlame;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.world.IslandPos;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockSavedData;

public final class SkyblockWorldEvents {
    private static final ITag.INamedTag<Block> PEBBLE_SOURCES = BlockTags.func_199894_a((String)"gardenofglass:pebble_sources");

    private SkyblockWorldEvents() {
    }

    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        World world = event.getPlayer().field_70170_p;
        if (SkyblockChunkGenerator.isWorldSkyblock(world)) {
            SkyblockSavedData data = SkyblockSavedData.get((ServerWorld)world);
            if (!data.skyblocks.containsValue((Object)Util.field_240973_b_)) {
                IslandPos islandPos = data.getSpawn();
                ((ServerWorld)world).func_241124_a__(islandPos.getCenter());
                SkyblockWorldEvents.spawnPlayer(event.getPlayer(), islandPos);
                Botania.LOGGER.info("Created the spawn GoG island");
            }
        }
    }

    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (Botania.gardenOfGlassLoaded) {
            BlockRayTraceResult rtr;
            ItemStack equipped = event.getItemStack();
            PlayerEntity player = event.getPlayer();
            if (equipped.func_190926_b() && player.func_225608_bj_()) {
                BlockState state = event.getWorld().func_180495_p(event.getPos());
                Block block = state.func_177230_c();
                if (PEBBLE_SOURCES.func_230235_a_((Object)block)) {
                    SoundType st = state.getSoundType((IWorldReader)event.getWorld(), event.getPos(), (Entity)player);
                    player.func_184185_a(st.func_185845_c(), st.func_185843_a() * 0.4f, st.func_185847_b() + (float)(Math.random() * 0.2 - 0.1));
                    if (event.getWorld().field_72995_K) {
                        player.func_184609_a(event.getHand());
                    } else if (Math.random() < 0.8) {
                        player.func_71019_a(new ItemStack((IItemProvider)ModItems.pebble), false);
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(ActionResultType.SUCCESS);
                }
            } else if (!equipped.func_190926_b() && equipped.func_77973_b() == Items.field_151054_z && (rtr = ToolCommons.raytraceFromEntity((Entity)player, 4.5, true)).func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockPos pos = rtr.func_216350_a();
                if (event.getWorld().func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
                    if (!event.getWorld().field_72995_K) {
                        equipped.func_190918_g(1);
                        if (equipped.func_190926_b()) {
                            player.func_184611_a(event.getHand(), new ItemStack((IItemProvider)ModItems.waterBowl));
                        } else {
                            player.field_71071_by.func_191975_a(player.field_70170_p, new ItemStack((IItemProvider)ModItems.waterBowl));
                        }
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(ActionResultType.SUCCESS);
                }
            }
        }
    }

    public static void spawnPlayer(PlayerEntity player, IslandPos islandPos) {
        BlockPos pos = islandPos.getCenter();
        SkyblockWorldEvents.createSkyblock(player.field_70170_p, pos);
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity pmp = (ServerPlayerEntity)player;
            pmp.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 0.5);
            pmp.func_241153_a_(pmp.field_70170_p.func_234923_W_(), pos, true, false);
            if (((Boolean)ConfigHandler.COMMON.gogSpawnWithLexicon.get()).booleanValue()) {
                player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.lexicon));
            }
        }
    }

    public static void createSkyblock(World world, BlockPos pos) {
        int[][] rootPositions;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 3; ++k) {
                    world.func_175656_a(pos.func_177982_a(-1 + i, -1 - j, -1 + k), j == 0 ? Blocks.field_196658_i.func_176223_P() : Blocks.field_150346_d.func_176223_P());
                }
            }
        }
        world.func_175656_a(pos.func_177982_a(-1, -2, 0), Blocks.field_150355_j.func_176223_P());
        world.func_175656_a(pos.func_177982_a(1, 2, 1), ModBlocks.manaFlame.func_176223_P());
        int r = 70 + world.field_73012_v.nextInt(185);
        int g = 70 + world.field_73012_v.nextInt(185);
        int b = 70 + world.field_73012_v.nextInt(185);
        int color = r << 16 | g << 8 | b;
        ((TileManaFlame)world.func_175625_s(pos.func_177982_a(1, 2, 1))).setColor(color);
        for (int[] root : rootPositions = new int[][]{{-1, -3, -1}, {-2, -4, -1}, {-2, -4, -2}, {1, -4, -1}, {1, -5, -1}, {2, -5, -1}, {2, -6, 0}, {0, -4, 2}, {0, -5, 2}, {0, -5, 3}, {0, -6, 3}}) {
            world.func_175656_a(pos.func_177982_a(root[0], root[1], root[2]), ModBlocks.root.func_176223_P());
        }
        world.func_175656_a(pos.func_177979_c(4), Blocks.field_150357_h.func_176223_P());
    }
}

