/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.proxy;

import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Map;
import java.util.SortedMap;
import net.minecraft.block.Block;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import vazkii.botania.client.core.handler.AstrolabePreviewHandler;
import vazkii.botania.client.core.handler.BaubleRenderHandler;
import vazkii.botania.client.core.handler.BlockHighlightRenderHandler;
import vazkii.botania.client.core.handler.BossBarHandler;
import vazkii.botania.client.core.handler.BoundTileRenderer;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.ColorHandler;
import vazkii.botania.client.core.handler.ContributorFancinessHandler;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.client.core.handler.DebugHandler;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.handler.KonamiHandler;
import vazkii.botania.client.core.handler.LayerTerraHelmet;
import vazkii.botania.client.core.handler.LightningHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.client.core.handler.PersistentVariableHelper;
import vazkii.botania.client.core.handler.RenderLexicon;
import vazkii.botania.client.core.handler.SplashHandler;
import vazkii.botania.client.core.handler.TooltipAdditionDisplayHandler;
import vazkii.botania.client.core.handler.TooltipHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.fx.FXLightning;
import vazkii.botania.client.fx.ModParticles;
import vazkii.botania.client.render.world.SkyblockRenderEvents;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.decor.BlockModMushroom;
import vazkii.botania.common.block.subtile.functional.BergamuteEventHandler;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.core.proxy.IProxy;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.item.ItemSextant;
import vazkii.botania.common.item.equipment.bauble.ItemDodgeRing;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class ClientProxy
implements IProxy {
    public static boolean jingleTheBells = false;
    public static boolean dootDoot = false;
    public static KeyBinding CORPOREA_REQUEST;

    @Override
    public void registerHandlers() {
        ShaderHelper.initShaders();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::loadComplete);
        modBus.addListener(MiscellaneousIcons.INSTANCE::onTextureStitchPre);
        modBus.addListener(MiscellaneousIcons.INSTANCE::onTextureStitchPost);
        modBus.addListener(MiscellaneousIcons.INSTANCE::onModelRegister);
        modBus.addListener(MiscellaneousIcons.INSTANCE::onModelBake);
        modBus.addListener(SplashHandler::registerFactories);
        modBus.addListener(ModelHandler::registerModels);
        modBus.addListener(ModParticles.FactoryHandler::registerFactories);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.HIGHEST, TooltipHandler::onTooltipEvent);
        forgeBus.addListener(TooltipAdditionDisplayHandler::onToolTipRender);
        forgeBus.addListener(RenderLexicon::renderHand);
        forgeBus.addListener(LightningHandler::onRenderWorldLast);
        forgeBus.addListener(KonamiHandler::clientTick);
        forgeBus.addListener(KonamiHandler::handleInput);
        forgeBus.addListener(KonamiHandler::renderBook);
        forgeBus.addListener(HUDHandler::onDrawScreenPost);
        forgeBus.addListener(DebugHandler::onDrawDebugText);
        forgeBus.addListener(CorporeaInputHandler::buttonPressed);
        forgeBus.addListener(ClientTickHandler::clientTickEnd);
        forgeBus.addListener(ClientTickHandler::renderTick);
        forgeBus.addListener(BoundTileRenderer::onWorldRenderLast);
        forgeBus.addListener(BossBarHandler::onBarRender);
        forgeBus.addListener(BlockHighlightRenderHandler::onWorldRenderLast);
        forgeBus.addListener(AstrolabePreviewHandler::onWorldRenderLast);
        forgeBus.addListener(SkyblockRenderEvents::onRender);
        forgeBus.addListener(ItemDodgeRing::onKeyDown);
        forgeBus.addListener(EventPriority.LOWEST, BergamuteEventHandler::onSoundEvent);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        PersistentVariableHelper.setCacheFile(new File(Minecraft.func_71410_x().field_71412_D, "BotaniaVars.dat"));
        try {
            PersistentVariableHelper.load();
            PersistentVariableHelper.save();
        }
        catch (IOException e) {
            Botania.LOGGER.fatal("Persistent Variables couldn't load!!");
        }
        if (((Boolean)ConfigHandler.CLIENT.enableSeasonalFeatures.get()).booleanValue()) {
            LocalDateTime now = LocalDateTime.now();
            if (now.getMonth() == Month.DECEMBER && now.getDayOfMonth() >= 16 || now.getMonth() == Month.JANUARY && now.getDayOfMonth() <= 2) {
                jingleTheBells = true;
            }
            if (now.getMonth() == Month.OCTOBER) {
                dootDoot = true;
            }
        }
        DeferredWorkQueue.runLater(() -> {
            CORPOREA_REQUEST = new KeyBinding("key.botania_corporea_request", (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.func_197954_a((int)67, (int)0), "Botania");
            ClientRegistry.registerKeyBinding((KeyBinding)CORPOREA_REQUEST);
        });
        ClientProxy.registerRenderTypes();
    }

    private static void registerRenderTypes() {
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.defaultAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.forestAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.plainsAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.mountainAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.fungalAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.swampAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.desertAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.taigaAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.mesaAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.mossyAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.ghostRail, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.solidVines, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.manaGlass, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModFluffBlocks.managlassPane, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.elfGlass, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModFluffBlocks.alfglassPane, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.bifrost, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModFluffBlocks.bifrostPane, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.bifrostPerm, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.prism, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.starfield, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.abstrusePlatform, t -> true);
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.infrangiblePlatform, t -> true);
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.spectralPlatform, t -> true);
        Registry.field_212618_g.func_201756_e().filter(b -> Registry.field_212618_g.func_177774_c(b).func_110624_b().equals("botania")).forEach(b -> {
            if (b instanceof BlockFloatingFlower || b instanceof FlowerBlock || b instanceof TallFlowerBlock || b instanceof BlockModMushroom) {
                RenderTypeLookup.setRenderLayer((Block)b, (RenderType)RenderType.func_228643_e_());
            }
        });
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        DeferredWorkQueue.runLater(() -> {
            this.initAuxiliaryRender();
            ColorHandler.init();
            SortedMap layers = (SortedMap)ObfuscationReflectionHelper.getPrivateValue(RenderTypeBuffers.class, (Object)Minecraft.func_71410_x().func_228019_au_(), (String)"field_228480_b_");
            layers.put(RenderHelper.MANA_POOL_WATER, new BufferBuilder(RenderHelper.MANA_POOL_WATER.func_228662_o_()));
        });
    }

    private void initAuxiliaryRender() {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        PlayerRenderer render = (PlayerRenderer)skinMap.get("default");
        render.func_177094_a((LayerRenderer)new ContributorFancinessHandler((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
        if (Botania.curiosLoaded) {
            render.func_177094_a((LayerRenderer)new BaubleRenderHandler((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
        }
        render.func_177094_a((LayerRenderer)new LayerTerraHelmet((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
        render = (PlayerRenderer)skinMap.get("slim");
        render.func_177094_a((LayerRenderer)new ContributorFancinessHandler((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
        if (Botania.curiosLoaded) {
            render.func_177094_a((LayerRenderer)new BaubleRenderHandler((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
        }
        render.func_177094_a((LayerRenderer)new LayerTerraHelmet((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
    }

    @Override
    public boolean isTheClientPlayer(LivingEntity entity) {
        return entity == Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public boolean isClientPlayerWearingMonocle() {
        return ItemMonocle.hasMonocle((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public long getWorldElapsedTicks() {
        return ClientTickHandler.ticksInGame;
    }

    @Override
    public void lightningFX(Vector3 vectorStart, Vector3 vectorEnd, float ticksPerMeter, long seed, int colorOuter, int colorInner) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new FXLightning((World)Minecraft.func_71410_x().field_71441_e, vectorStart, vectorEnd, ticksPerMeter, seed, colorOuter, colorInner));
    }

    @Override
    public void addBoss(EntityDoppleganger boss) {
        BossBarHandler.bosses.add(boss);
    }

    @Override
    public void removeBoss(EntityDoppleganger boss) {
        BossBarHandler.bosses.remove((Object)boss);
    }

    @Override
    public int getClientRenderDistance() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c;
    }

    @Override
    public void addParticleForce(World world, IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        world.func_195590_a(particleData, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Override
    public void showMultiblock(IMultiblock mb, ITextComponent name, BlockPos anchor, Rotation rot) {
        PatchouliAPI.instance.showMultiblock(mb, name, anchor, rot);
    }

    @Override
    public void clearSextantMultiblock() {
        IMultiblock mb = PatchouliAPI.instance.getCurrentMultiblock();
        if (mb != null && mb.getID().equals((Object)ItemSextant.MULTIBLOCK_ID)) {
            PatchouliAPI.instance.clearMultiblock();
        }
    }
}

