/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.botania.client.core.helper.ShaderHelper;

public class FXSparkle
extends SpriteTexturedParticle {
    private final boolean corrupt;
    public final boolean fake;
    public final int particle = 16;
    private final boolean slowdown = true;
    private final IAnimatedSprite sprite;
    private static final IParticleRenderType NORMAL_RENDER = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXSparkle.beginRenderCommon(bufferBuilder, textureManager);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            FXSparkle.endRenderCommon();
        }

        public String toString() {
            return "botania:sparkle";
        }
    };
    private static final IParticleRenderType CORRUPT_RENDER = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXSparkle.beginRenderCommon(bufferBuilder, textureManager);
            ShaderHelper.useShader(ShaderHelper.BotaniaShader.FILM_GRAIN);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            ShaderHelper.releaseShader();
            FXSparkle.endRenderCommon();
        }

        public String toString() {
            return "botania:corrupt_sparkle";
        }
    };

    public FXSparkle(World world, double x, double y, double z, float size, float red, float green, float blue, int m, boolean fake, boolean noClip, boolean corrupt, IAnimatedSprite sprite) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_70552_h = red;
        this.field_70553_i = green;
        this.field_70551_j = blue;
        this.field_82339_as = 0.75f;
        this.field_70545_g = 0.0f;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.field_70544_f = (this.field_187136_p.nextFloat() * 0.5f + 0.5f) * 0.2f * size;
        this.field_70547_e = 3 * m;
        this.func_187115_a(0.01f, 0.01f);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.fake = fake;
        this.corrupt = corrupt;
        this.field_190017_n = !fake && !noClip;
        this.sprite = sprite;
        this.func_217566_b(sprite);
    }

    public float func_217561_b(float partialTicks) {
        return this.field_70544_f * (float)(this.field_70547_e - this.field_70546_d + 1) / (float)this.field_70547_e;
    }

    public void func_189213_a() {
        this.func_217566_b(this.sprite);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187130_j -= 0.04 * (double)this.field_70545_g;
        if (this.field_190017_n && !this.fake) {
            this.wiggleAround(this.field_187126_f, (this.func_187116_l().field_72338_b + this.func_187116_l().field_72337_e) / 2.0, this.field_187128_h);
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= 0.9080000019073486;
        this.field_187130_j *= 0.9080000019073486;
        this.field_187131_k *= 0.9080000019073486;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
        if (this.fake && this.field_70546_d > 1) {
            this.func_187112_i();
        }
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return this.corrupt ? CORRUPT_RENDER : NORMAL_RENDER;
    }

    public void setGravity(float value) {
        this.field_70545_g = value;
    }

    private void wiggleAround(double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        Vec3d vec3d = new Vec3d(x - (double)blockpos.func_177958_n(), y - (double)blockpos.func_177956_o(), z - (double)blockpos.func_177952_p());
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        for (Direction direction1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            blockpos$mutable.func_189533_g((Vec3i)blockpos).func_189536_c(direction1);
            if (this.field_187122_b.func_180495_p((BlockPos)blockpos$mutable).func_224756_o((IBlockReader)this.field_187122_b, (BlockPos)blockpos$mutable)) continue;
            double d1 = vec3d.func_216370_a(direction1.func_176740_k());
            double d = d2 = direction1.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.field_187136_p.nextFloat() * 0.05f + 0.025f;
        float f1 = direction.func_176743_c().func_179524_a();
        float secondary = (this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.1f;
        float secondary2 = (this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.1f;
        if (direction.func_176740_k() == Direction.Axis.X) {
            this.field_187129_i = f1 * f;
            this.field_187130_j = secondary;
            this.field_187131_k = secondary2;
        } else if (direction.func_176740_k() == Direction.Axis.Y) {
            this.field_187129_i = secondary;
            this.field_187130_j = f1 * f;
            this.field_187131_k = secondary2;
        } else if (direction.func_176740_k() == Direction.Axis.Z) {
            this.field_187129_i = secondary;
            this.field_187130_j = secondary2;
            this.field_187131_k = f1 * f;
        }
    }

    private static void beginRenderCommon(BufferBuilder buffer, TextureManager textureManager) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.alphaFunc((int)516, (float)0.003921569f);
        RenderSystem.disableLighting();
        textureManager.func_110577_a(AtlasTexture.field_215262_g);
        Texture tex = textureManager.func_229267_b_(AtlasTexture.field_215262_g);
        tex.setBlurMipmap(true, false);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    private static void endRenderCommon() {
        Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_215262_g).restoreLastBlurMipmap();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }
}

