/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.common.Botania;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.item.ModItems;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class BrewRecipeProcessor
implements IComponentProcessor {
    private IBrewRecipe recipe;

    public void setup(IVariableProvider<String> variables) {
        ResourceLocation id = new ResourceLocation((String)variables.get("recipe"));
        IRecipe recipe = (IRecipe)Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215366_a(ModRecipeTypes.BREW_TYPE).get(id);
        if (recipe instanceof IBrewRecipe) {
            this.recipe = (IBrewRecipe)recipe;
        } else {
            Botania.LOGGER.warn("Missing brew recipe " + id);
        }
    }

    public String process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.equals("heading")) {
            return I18n.func_135052_a((String)"botaniamisc.brewOf", (Object[])new Object[]{I18n.func_135052_a((String)this.recipe.getBrew().getTranslationKey(), (Object[])new Object[0])});
        }
        if (key.equals("vial")) {
            return PatchouliAPI.instance.serializeItemStack(this.recipe.getOutput(new ItemStack((IItemProvider)ModItems.vial)));
        }
        if (key.equals("flask")) {
            return PatchouliAPI.instance.serializeItemStack(this.recipe.getOutput(new ItemStack((IItemProvider)ModItems.flask)));
        }
        if (key.startsWith("input")) {
            int indexOffset;
            int requestedIndex = Integer.parseInt(key.substring(5)) - 1;
            int index = requestedIndex - (indexOffset = (6 - this.recipe.func_192400_c().size()) / 2);
            if (index < this.recipe.func_192400_c().size() && index >= 0) {
                return PatchouliAPI.instance.serializeIngredient((Ingredient)this.recipe.func_192400_c().get(index));
            }
            return null;
        }
        if (key.equals("is_offset")) {
            return Boolean.toString(this.recipe.func_192400_c().size() % 2 == 0);
        }
        return null;
    }
}

