/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.TextFormatting;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class ManaInfusionProcessor
implements IComponentProcessor {
    private List<IManaInfusionRecipe> recipes;
    private boolean hasCustomHeading;

    public void setup(IVariableProvider<String> variables) {
        if (variables.has("recipes") && variables.has("group")) {
            Botania.LOGGER.warn("Mana infusion template has both 'recipes' and 'group', ignoring 'recipes'");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (variables.has("group")) {
            String group = (String)variables.get("group");
            TilePool.manaInfusionRecipes(Minecraft.func_71410_x().field_71441_e.func_199532_z()).stream().filter(r -> r.func_193358_e().equals(group)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        } else {
            for (String s : ((String)variables.get("recipes")).split(";")) {
                IRecipe recipe = (IRecipe)Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215366_a(ModRecipeTypes.MANA_INFUSION_TYPE).get(new ResourceLocation(s));
                if (recipe instanceof IManaInfusionRecipe) {
                    builder.add((Object)((IManaInfusionRecipe)recipe));
                    continue;
                }
                Botania.LOGGER.warn("Mana infusion template references nonexistent recipe {}", (Object)s);
            }
        }
        this.recipes = builder.build();
        this.hasCustomHeading = variables.has("heading");
    }

    public String process(String key) {
        if (this.recipes.isEmpty()) {
            return null;
        }
        switch (key) {
            case "heading": {
                if (!this.hasCustomHeading) {
                    return this.recipes.get(0).func_77571_b().func_200301_q().getString();
                }
                return null;
            }
            case "input": {
                return PatchouliUtils.interweaveIngredients(this.recipes.stream().map(r -> (Ingredient)r.func_192400_c().get(0)).collect(Collectors.toList()));
            }
            case "output": {
                return this.recipes.stream().map(IRecipe::func_77571_b).map(arg_0 -> ((PatchouliAPI.IPatchouliAPI)PatchouliAPI.instance).serializeItemStack(arg_0)).collect(Collectors.joining(","));
            }
            case "catalyst": {
                return this.recipes.stream().map(IManaInfusionRecipe::getCatalyst).map(state -> {
                    if (state == null) {
                        return ItemStack.field_190927_a;
                    }
                    return new ItemStack((IItemProvider)state.func_177230_c().func_199767_j());
                }).map(arg_0 -> ((PatchouliAPI.IPatchouliAPI)PatchouliAPI.instance).serializeItemStack(arg_0)).collect(Collectors.joining(","));
            }
            case "mana": {
                return this.recipes.stream().mapToInt(IManaInfusionRecipe::getManaToConsume).mapToObj(Integer::toString).collect(Collectors.joining(";"));
            }
            case "drop": {
                return I18n.func_135052_a((String)"botaniamisc.drop", (Object[])new Object[0]) + TextFormatting.BOLD + " (?)";
            }
            case "dropTip0": 
            case "dropTip1": {
                String drop = new KeybindTextComponent("key.drop").func_211708_a(TextFormatting.GREEN).func_150254_d();
                return I18n.func_135052_a((String)("botaniamisc.dropTip" + key.substring(7)), (Object[])new Object[]{drop});
            }
        }
        return null;
    }
}

