/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.item.IHourglassTrigger;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileAnimatedTorch;

public class BlockAnimatedTorch
extends BlockModWaterloggable
implements ITileEntityProvider,
IWandable,
IManaTrigger,
IHourglassTrigger,
IWandHUD {
    private static final VoxelShape SHAPE = BlockAnimatedTorch.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);

    public BlockAnimatedTorch(Block.Properties builder) {
        super(builder);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (hand == Hand.MAIN_HAND && playerIn.func_225608_bj_() && playerIn.func_184586_b(hand).func_190926_b()) {
            ((TileAnimatedTorch)worldIn.func_175625_s(pos)).handRotate();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        ((TileAnimatedTorch)world.func_175625_s(pos)).onPlace(entity);
    }

    @Override
    public void onBurstCollision(IManaBurst burst, World world, BlockPos pos) {
        if (!burst.isFake()) {
            ((TileAnimatedTorch)world.func_175625_s(pos)).toggle();
        }
    }

    @Override
    public void onTriggeredByHourglass(World world, BlockPos pos, TileEntity hourglass) {
        ((TileAnimatedTorch)world.func_175625_s(pos)).toggle();
    }

    @Override
    public boolean onUsedByWand(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction side) {
        ((TileAnimatedTorch)world.func_175625_s(pos)).onWanded();
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(Minecraft mc, World world, BlockPos pos) {
        ((TileAnimatedTorch)world.func_175625_s(pos)).renderHUD(mc);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        TileAnimatedTorch tile = (TileAnimatedTorch)blockAccess.func_175625_s(pos);
        if (tile.rotating) {
            return 0;
        }
        if (TileAnimatedTorch.SIDES[tile.side] == side) {
            return 15;
        }
        return 0;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return new TileAnimatedTorch();
    }

    public void func_176206_d(IWorld world, BlockPos pos, BlockState state) {
        world.func_195592_c(pos, (Block)this);
        super.func_176206_d(world, pos, state);
    }
}

