/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileLightRelay;

public class BlockLightLauncher
extends BlockModWaterloggable {
    private static final VoxelShape SHAPE = BlockLightLauncher.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);

    public BlockLightLauncher(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208194_u});
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean power = world.func_175687_A(pos) > 0 || world.func_175687_A(pos.func_177984_a()) > 0;
        boolean powered = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u);
        if (power && !powered) {
            this.pickUpEntities(world, pos);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!power && powered) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    private void pickUpEntities(World world, BlockPos pos) {
        ArrayList<TileLightRelay> relays = new ArrayList<TileLightRelay>();
        for (Direction dir : Direction.values()) {
            TileLightRelay relay;
            TileEntity tile = world.func_175625_s(pos.func_177972_a(dir));
            if (!(tile instanceof TileLightRelay) || (relay = (TileLightRelay)tile).getNextDestination() == null) continue;
            relays.add(relay);
        }
        if (!relays.isEmpty()) {
            AxisAlignedBB aabb = new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1));
            List entities = world.func_217357_a(LivingEntity.class, aabb);
            entities.addAll(world.func_217357_a(ItemEntity.class, aabb));
            if (!entities.isEmpty()) {
                for (Entity entity : entities) {
                    TileLightRelay relay = (TileLightRelay)relays.get(world.field_73012_v.nextInt(relays.size()));
                    relay.mountEntity(entity);
                }
            }
        }
    }
}

