/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MushroomBlock;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import vazkii.botania.api.item.IHornHarvestable;
import vazkii.botania.api.recipe.ICustomApothecaryColor;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.handler.ConfigHandler;

public class BlockModMushroom
extends MushroomBlock
implements IHornHarvestable,
ICustomApothecaryColor {
    private static final VoxelShape SHAPE = BlockModMushroom.func_208617_a((double)4.8, (double)0.0, (double)4.8, (double)12.8, (double)16.0, (double)12.8);
    public final DyeColor color;

    public BlockModMushroom(DyeColor color, Block.Properties builder) {
        super(builder);
        this.color = color;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    public void func_225534_a_(@Nonnull BlockState state, @Nonnull ServerWorld world, @Nonnull BlockPos pos, Random rand) {
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState iblockstate = worldIn.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (block != Blocks.field_150391_bh && block != Blocks.field_196661_l) {
            return iblockstate.canSustainPlant((IBlockReader)worldIn, blockpos, Direction.UP, (IPlantable)this);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        int hex = this.color.field_193351_w;
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        if (rand.nextDouble() < (Double)ConfigHandler.CLIENT.flowerParticleFrequency.get() * 0.25) {
            SparkleParticleData data = SparkleParticleData.sparkle(rand.nextFloat(), (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 5);
            world.func_195594_a((IParticleData)data, (double)pos.func_177958_n() + 0.3 + (double)rand.nextFloat() * 0.5, (double)pos.func_177956_o() + 0.5 + (double)rand.nextFloat() * 0.5, (double)pos.func_177952_p() + 0.3 + (double)rand.nextFloat() * 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean canHornHarvest(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        return false;
    }

    @Override
    public boolean hasSpecialHornHarvest(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        return false;
    }

    @Override
    public void harvestByHorn(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
    }

    @Override
    public int getParticleColor(ItemStack stack) {
        return this.color.field_193351_w;
    }
}

