/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.ItemHorn;
import vazkii.botania.common.item.ModItems;

public class BlockForestDrum
extends BlockModWaterloggable
implements IManaTrigger {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private final Variant variant;

    public BlockForestDrum(Variant v, Block.Properties builder) {
        super(builder);
        this.variant = v;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    @Override
    public void onBurstCollision(IManaBurst burst, World world, BlockPos pos) {
        if (burst.isFake()) {
            return;
        }
        if (world.field_72995_K) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197597_H, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, 0.041666666666666664, 0.0, 0.0);
            return;
        }
        if (this.variant == Variant.WILD) {
            ItemHorn.breakGrass(world, new ItemStack((IItemProvider)ModItems.grassHorn), pos);
        } else if (this.variant == Variant.CANOPY) {
            ItemHorn.breakGrass(world, new ItemStack((IItemProvider)ModItems.leavesHorn), pos);
        } else {
            ItemEntity ent;
            int range = 10;
            List entities = world.func_217357_a(MobEntity.class, new AxisAlignedBB(pos.func_177982_a(-range, -range, -range), pos.func_177982_a(range + 1, range + 1, range + 1)));
            ArrayList<MobEntity> shearables = new ArrayList<MobEntity>();
            ItemStack stack = new ItemStack((IItemProvider)ModBlocks.gatheringDrum);
            for (MobEntity entity : entities) {
                if (entity instanceof IShearable && ((IShearable)entity).isShearable(stack, (IWorldReader)world, new BlockPos((Entity)entity))) {
                    shearables.add(entity);
                    continue;
                }
                if (!(entity instanceof CowEntity)) continue;
                List items = world.func_217357_a(ItemEntity.class, entity.func_174813_aQ());
                for (ItemEntity item : items) {
                    ItemStack itemstack = item.func_92059_d();
                    if (itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151133_ar || world.field_72995_K) continue;
                    while (itemstack.func_190916_E() > 0) {
                        ent = entity.func_70099_a(new ItemStack((IItemProvider)Items.field_151117_aB), 1.0f);
                        ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)(world.field_73012_v.nextFloat() * 0.05f), (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f), (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f)));
                        itemstack.func_190918_g(1);
                    }
                    item.func_70106_y();
                }
            }
            Collections.shuffle(shearables);
            int sheared = 0;
            for (MobEntity entity : shearables) {
                if (sheared > 4) break;
                List stacks = ((IShearable)entity).onSheared(stack, (IWorld)world, new BlockPos((Entity)entity), 0);
                for (ItemStack wool : stacks) {
                    ent = entity.func_70099_a(wool, 1.0f);
                    ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)(world.field_73012_v.nextFloat() * 0.05f), (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f), (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f)));
                }
                ++sheared;
            }
        }
        for (int i = 0; i < 10; ++i) {
            world.func_184133_a(null, pos, SoundEvents.field_187676_dE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static enum Variant {
        WILD,
        GATHERING,
        CANOPY;

    }
}

