/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.ArrayList;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ConfigHandler;

public class SubTileMarimorphosis
extends TileEntityFunctionalFlower {
    private static final int COST = 12;
    private static final int RANGE = 8;
    private static final int RANGE_Y = 5;
    private static final int RANGE_MINI = 2;
    private static final int RANGE_Y_MINI = 1;
    private static final BiomeDictionary.Type[] TYPES = new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.MESA};

    public SubTileMarimorphosis(TileEntityType<?> type) {
        super(type);
    }

    public SubTileMarimorphosis() {
        this(ModSubtiles.MARIMORPHOSIS);
    }

    @Override
    public void tickFlower() {
        BlockState state;
        BlockPos coords;
        super.tickFlower();
        if (this.func_145831_w().field_72995_K || this.redstoneSignal > 0) {
            return;
        }
        if (this.getMana() >= 12 && this.ticksExisted % 2 == 0 && (coords = this.getCoordsToPut()) != null && (state = this.getStoneToPut(coords)) != null) {
            this.func_145831_w().func_175656_a(coords, state);
            if (((Boolean)ConfigHandler.COMMON.blockBreakParticles.get()).booleanValue()) {
                this.func_145831_w().func_217379_c(2001, coords, Block.func_196246_j((BlockState)state));
            }
            this.addMana(-12);
            this.sync();
        }
    }

    public BlockState getStoneToPut(BlockPos coords) {
        Set types = BiomeDictionary.getTypes((Biome)this.func_145831_w().func_226691_t_(coords));
        ArrayList<Block> values = new ArrayList<Block>();
        for (BiomeDictionary.Type type : TYPES) {
            int times = 1;
            if (types.contains(type)) {
                times = 12;
            }
            Block block = this.biomeTypeToBlock(type);
            for (int j = 0; j < times; ++j) {
                values.add(block);
            }
        }
        return ((Block)values.get(this.func_145831_w().field_73012_v.nextInt(values.size()))).func_176223_P();
    }

    private Block biomeTypeToBlock(BiomeDictionary.Type biomeType) {
        switch (biomeType.getName()) {
            default: {
                throw new IllegalArgumentException("Should have verified type is suitable already: " + biomeType);
            }
            case "FOREST": {
                return ModFluffBlocks.biomeStoneForest;
            }
            case "PLAINS": {
                return ModFluffBlocks.biomeStonePlains;
            }
            case "MOUNTAIN": {
                return ModFluffBlocks.biomeStoneMountain;
            }
            case "MUSHROOM": {
                return ModFluffBlocks.biomeStoneFungal;
            }
            case "SWAMP": {
                return ModFluffBlocks.biomeStoneSwamp;
            }
            case "SANDY": {
                return ModFluffBlocks.biomeStoneDesert;
            }
            case "COLD": {
                return ModFluffBlocks.biomeStoneTaiga;
            }
            case "MESA": 
        }
        return ModFluffBlocks.biomeStoneMesa;
    }

    private BlockPos getCoordsToPut() {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        int range = this.getRange();
        int rangeY = this.getRangeY();
        BlockStateMatcher matcher = BlockStateMatcher.func_177638_a((Block)Blocks.field_150348_b);
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)this.getEffectivePos().func_177982_a(-range, -rangeY, -range), (BlockPos)this.getEffectivePos().func_177982_a(range, rangeY, range))) {
            BlockState state = this.func_145831_w().func_180495_p(pos);
            if (!state.func_177230_c().isReplaceableOreGen(state, (IWorldReader)this.func_145831_w(), pos, (Predicate)matcher)) continue;
            possibleCoords.add(pos.func_185334_h());
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleCoords.get(this.func_145831_w().field_73012_v.nextInt(possibleCoords.size()));
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), this.getRange());
    }

    public int getRange() {
        return 8;
    }

    public int getRangeY() {
        return 5;
    }

    @Override
    public int getColor() {
        return 7772311;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }

    public static class Mini
    extends SubTileMarimorphosis {
        public Mini() {
            super(ModSubtiles.MARIMORPHOSIS_CHIBI);
        }

        @Override
        public int getRange() {
            return 2;
        }

        @Override
        public int getRangeY() {
            return 1;
        }
    }
}

