/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.core.handler.ExoflameFurnaceHandler;
import vazkii.botania.common.core.handler.ModSounds;

public class TileBellows
extends TileMod
implements ITickableTileEntity {
    private static final String TAG_ACTIVE = "active";
    public float movePos;
    public boolean active = false;
    public float moving = 0.0f;

    public TileBellows() {
        super(ModTiles.BELLOWS);
    }

    public void interact() {
        if (this.moving == 0.0f) {
            this.setActive(true);
        }
    }

    public void func_73660_a() {
        boolean disable = true;
        TileEntity tile = this.getLinkedTile();
        if (!this.active && tile instanceof TilePool) {
            TilePool pool = (TilePool)tile;
            boolean transfer = pool.isDoingTransfer;
            if (transfer) {
                if (pool.ticksDoingTransfer > 0) {
                    this.setActive(true);
                }
                disable = false;
            }
        }
        float max = 0.9f;
        float min = 0.0f;
        float incr = max / 20.0f;
        if (this.movePos < max && this.active && this.moving >= 0.0f) {
            AbstractFurnaceTileEntity furnace;
            Pair<AbstractCookingRecipe, Boolean> p;
            if (this.moving == 0.0f) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, ModSounds.bellows, SoundCategory.BLOCKS, 0.1f, 3.0f);
            }
            if (tile instanceof AbstractFurnaceTileEntity && (p = TileBellows.canSmelt(furnace = (AbstractFurnaceTileEntity)tile)) != null) {
                AbstractCookingRecipe recipe = (AbstractCookingRecipe)p.getFirst();
                boolean canSmelt = (Boolean)p.getSecond();
                if (canSmelt) {
                    furnace.field_214020_l = Math.min(recipe.func_222137_e() - 1, furnace.field_214020_l + 20);
                    furnace.field_214018_j = Math.max(0, furnace.field_214018_j - 10);
                }
                if (furnace instanceof FurnaceTileEntity && furnace.func_145830_o() && ((Boolean)furnace.func_195044_w().func_177229_b((IProperty)FurnaceBlock.field_220091_b)).booleanValue()) {
                    double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
                    double d1 = this.field_174879_c.func_177956_o();
                    double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
                    Direction enumfacing = (Direction)furnace.func_195044_w().func_177229_b((IProperty)FurnaceBlock.field_220090_a);
                    Direction.Axis enumfacing$axis = enumfacing.func_176740_k();
                    double d3 = 0.52;
                    double d4 = this.field_145850_b.field_73012_v.nextDouble() * 0.6 - 0.3;
                    double d5 = enumfacing$axis == Direction.Axis.X ? (double)enumfacing.func_82601_c() * 0.52 : d4;
                    double d6 = this.field_145850_b.field_73012_v.nextDouble() * 6.0 / 16.0;
                    double d7 = enumfacing$axis == Direction.Axis.Z ? (double)enumfacing.func_82599_e() * 0.52 : d4;
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                }
            }
            this.movePos += incr * 3.0f;
            this.moving = incr * 3.0f;
            if (this.movePos >= max) {
                this.movePos = Math.min(max, this.movePos);
                this.moving = 0.0f;
                if (disable) {
                    this.setActive(false);
                }
            }
        } else if (this.movePos > min) {
            this.movePos -= incr;
            this.moving = -incr;
            if (this.movePos <= min) {
                this.movePos = Math.max(min, this.movePos);
                this.moving = 0.0f;
            }
        }
    }

    public TileEntity getLinkedTile() {
        Direction side = (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        return this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_74757_a(TAG_ACTIVE, this.active);
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        this.active = cmp.func_74767_n(TAG_ACTIVE);
    }

    public void setActive(boolean active) {
        if (!this.field_145850_b.field_72995_K) {
            boolean diff = this.active != active;
            this.active = active;
            if (diff) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
        }
    }

    @Nullable
    public static Pair<AbstractCookingRecipe, Boolean> canSmelt(AbstractFurnaceTileEntity furnace) {
        try {
            IRecipeType<? extends AbstractCookingRecipe> rt = ExoflameFurnaceHandler.getRecipeType(furnace);
            AbstractCookingRecipe recipe = furnace.func_145831_w().func_199532_z().func_215371_a(rt, (IInventory)furnace, furnace.func_145831_w()).orElse(null);
            boolean canSmelt = ExoflameFurnaceHandler.canSmelt(furnace, recipe);
            return Pair.of((Object)recipe, (Object)canSmelt);
        }
        catch (Throwable e) {
            Botania.LOGGER.error("Failed to reflect furnace", e);
            return null;
        }
    }
}

