/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandlerModifiable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.common.entity.EntitySparkBase;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.ItemSparkUpgrade;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.material.ItemDye;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class EntitySpark
extends EntitySparkBase
implements ISparkEntity {
    private static final int TRANSFER_RATE = 1000;
    private static final String TAG_UPGRADE = "upgrade";
    private static final DataParameter<Integer> UPGRADE = EntityDataManager.func_187226_a(EntitySpark.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final Set<ISparkEntity> transfers = Collections.newSetFromMap(new WeakHashMap());
    private int removeTransferants = 2;

    public EntitySpark(EntityType<EntitySpark> type, World world) {
        super(type, world);
    }

    public EntitySpark(World world) {
        this(ModEntities.SPARK, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(UPGRADE, (Object)0);
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ModItems.spark);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ISparkAttachable tile = this.getAttachedTile();
        if (tile == null) {
            this.dropAndKill();
            return;
        }
        SparkUpgradeType upgrade = this.getUpgrade();
        Collection<ISparkEntity> transfers = this.getTransfers();
        switch (upgrade) {
            case DISPERSIVE: {
                PlayerEntity player2;
                List<PlayerEntity> players = SparkHelper.getEntitiesAround(PlayerEntity.class, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() / 2.0, this.func_226281_cx_());
                HashMap receivingPlayers = new HashMap();
                ItemStack input = new ItemStack((IItemProvider)ModItems.spark);
                for (PlayerEntity player2 : players) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    stacks.addAll((Collection<ItemStack>)player2.field_71071_by.field_70462_a);
                    stacks.addAll((Collection<ItemStack>)player2.field_71071_by.field_70460_b);
                    IItemHandlerModifiable inv = BotaniaAPI.instance().internalHandler().getAccessoriesInventory(player2);
                    for (int i = 0; i < inv.getSlots(); ++i) {
                        stacks.add(inv.getStackInSlot(i));
                    }
                    for (ItemStack stack : stacks) {
                        int recv;
                        HashMap<ItemStack, Integer> receivingStacks;
                        IManaItem manaItem;
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IManaItem) || !(manaItem = (IManaItem)stack.func_77973_b()).canReceiveManaFromItem(stack, input)) continue;
                        boolean add = false;
                        if (!receivingPlayers.containsKey(player2)) {
                            add = true;
                            receivingStacks = new HashMap<ItemStack, Integer>();
                        } else {
                            receivingStacks = (HashMap<ItemStack, Integer>)receivingPlayers.get(player2);
                        }
                        if ((recv = Math.min(this.getAttachedTile().getCurrentMana(), Math.min(1000, manaItem.getMaxMana(stack) - manaItem.getMana(stack)))) <= 0) continue;
                        receivingStacks.put(stack, recv);
                        if (!add) continue;
                        receivingPlayers.put(player2, receivingStacks);
                    }
                }
                if (receivingPlayers.isEmpty()) break;
                ArrayList keys = new ArrayList(receivingPlayers.keySet());
                Collections.shuffle(keys);
                player2 = (PlayerEntity)keys.iterator().next();
                Map items = (Map)receivingPlayers.get(player2);
                ItemStack stack = (ItemStack)items.keySet().iterator().next();
                int cost = (Integer)items.get(stack);
                int manaToPut = Math.min(this.getAttachedTile().getCurrentMana(), cost);
                ((IManaItem)stack.func_77973_b()).addMana(stack, manaToPut);
                this.getAttachedTile().receiveMana(-manaToPut);
                this.particlesTowards((Entity)player2);
                break;
            }
            case DOMINANT: {
                List validSparks = SparkHelper.getSparksAround(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_(), this.getNetwork()).filter(s -> {
                    SparkUpgradeType otherUpgrade = s.getUpgrade();
                    return s != this && otherUpgrade == SparkUpgradeType.NONE && s.getAttachedTile() instanceof IManaPool;
                }).collect(Collectors.toList());
                if (validSparks.size() <= 0) break;
                ((ISparkEntity)validSparks.get(this.field_70170_p.field_73012_v.nextInt(validSparks.size()))).registerTransfer(this);
                break;
            }
            case RECESSIVE: {
                SparkHelper.getSparksAround(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_(), this.getNetwork()).filter(s -> {
                    SparkUpgradeType otherUpgrade = s.getUpgrade();
                    return s != this && otherUpgrade != SparkUpgradeType.DOMINANT && otherUpgrade != SparkUpgradeType.RECESSIVE && otherUpgrade != SparkUpgradeType.ISOLATED;
                }).forEach(transfers::add);
                break;
            }
        }
        if (!transfers.isEmpty()) {
            int manaTotal = Math.min(1000 * transfers.size(), tile.getCurrentMana());
            int manaForEach = manaTotal / transfers.size();
            int manaSpent = 0;
            if (manaForEach > transfers.size()) {
                for (ISparkEntity spark : transfers) {
                    if (spark.getAttachedTile() == null || spark.getAttachedTile().isFull() || spark.areIncomingTransfersDone()) {
                        manaTotal -= manaForEach;
                        continue;
                    }
                    ISparkAttachable attached = spark.getAttachedTile();
                    int spend = Math.min(attached.getAvailableSpaceForMana(), manaForEach);
                    attached.receiveMana(spend);
                    manaSpent += spend;
                    this.particlesTowards((Entity)spark);
                }
                tile.receiveMana(-manaSpent);
            }
        }
        if (this.removeTransferants > 0) {
            --this.removeTransferants;
        }
        this.filterTransfers();
    }

    private void particlesTowards(Entity e) {
        PacketHandler.sendToNearby(this.field_70170_p, this, (Object)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.SPARK_MANA_FLOW, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_145782_y(), e.func_145782_y()));
    }

    public static void particleBeam(PlayerEntity player, Entity e1, Entity e2) {
        if (e1 != null && e2 != null && !e1.field_70170_p.field_72995_K) {
            PacketHandler.sendTo((ServerPlayerEntity)player, new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.SPARK_NET_INDICATOR, e1.func_226277_ct_(), e1.func_226278_cu_(), e1.func_226281_cx_(), e1.func_145782_y(), e2.func_145782_y()));
        }
    }

    private void dropAndKill() {
        SparkUpgradeType upgrade = this.getUpgrade();
        this.func_70099_a(new ItemStack((IItemProvider)ModItems.spark), 0.0f);
        if (upgrade != SparkUpgradeType.NONE) {
            this.func_70099_a(ItemSparkUpgrade.getByType(upgrade), 0.0f);
        }
        this.func_70106_y();
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.func_70089_S() && !stack.func_190926_b()) {
            DyeColor color;
            if (this.field_70170_p.field_72995_K) {
                boolean valid;
                boolean bl = valid = stack.func_77973_b() == ModItems.twigWand || stack.func_77973_b() instanceof ItemSparkUpgrade || stack.func_77973_b() == ModItems.phantomInk || stack.func_77973_b() instanceof ItemDye;
                if (valid) {
                    player.func_184609_a(hand);
                }
                return valid;
            }
            SparkUpgradeType upgrade = this.getUpgrade();
            if (stack.func_77973_b() == ModItems.twigWand) {
                if (player.func_225608_bj_()) {
                    if (upgrade != SparkUpgradeType.NONE) {
                        this.func_70099_a(ItemSparkUpgrade.getByType(upgrade), 0.0f);
                        this.setUpgrade(SparkUpgradeType.NONE);
                        this.transfers.clear();
                        this.removeTransferants = 2;
                    } else {
                        this.dropAndKill();
                    }
                    return true;
                }
                SparkHelper.getSparksAround(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_(), this.getNetwork()).forEach(s -> EntitySpark.particleBeam(player, this, (Entity)s));
                return true;
            }
            if (stack.func_77973_b() instanceof ItemSparkUpgrade && upgrade == SparkUpgradeType.NONE) {
                this.setUpgrade(((ItemSparkUpgrade)stack.func_77973_b()).type);
                stack.func_190918_g(1);
                return true;
            }
            if (stack.func_77973_b() == ModItems.phantomInk) {
                this.func_82142_c(true);
                return true;
            }
            if (stack.func_77973_b() instanceof ItemDye && (color = ((ItemDye)stack.func_77973_b()).color) != this.getNetwork()) {
                this.setNetwork(color);
                stack.func_190918_g(1);
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected void func_70037_a(@Nonnull CompoundNBT cmp) {
        super.func_70037_a(cmp);
        this.setUpgrade(SparkUpgradeType.values()[cmp.func_74762_e(TAG_UPGRADE)]);
    }

    @Override
    protected void func_213281_b(@Nonnull CompoundNBT cmp) {
        super.func_213281_b(cmp);
        cmp.func_74768_a(TAG_UPGRADE, this.getUpgrade().ordinal());
    }

    @Override
    public ISparkAttachable getAttachedTile() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.func_226277_ct_());
        TileEntity tile = this.field_70170_p.func_175625_s(new BlockPos(x, y = MathHelper.func_76128_c((double)this.func_226278_cu_()) - 1, z = MathHelper.func_76128_c((double)this.func_226281_cx_())));
        if (tile instanceof ISparkAttachable) {
            return (ISparkAttachable)tile;
        }
        return null;
    }

    private void filterTransfers() {
        Iterator<ISparkEntity> iter = this.transfers.iterator();
        while (iter.hasNext()) {
            ISparkEntity spark = iter.next();
            SparkUpgradeType upgr = this.getUpgrade();
            SparkUpgradeType supgr = spark.getUpgrade();
            ISparkAttachable atile = spark.getAttachedTile();
            if (spark != this && !spark.areIncomingTransfersDone() && this.getNetwork() == spark.getNetwork() && atile != null && !atile.isFull() && (upgr == SparkUpgradeType.NONE && supgr == SparkUpgradeType.DOMINANT || upgr == SparkUpgradeType.RECESSIVE && (supgr == SparkUpgradeType.NONE || supgr == SparkUpgradeType.DISPERSIVE) || !(atile instanceof IManaPool))) continue;
            iter.remove();
        }
    }

    @Override
    public Collection<ISparkEntity> getTransfers() {
        this.filterTransfers();
        return this.transfers;
    }

    private boolean hasTransfer(ISparkEntity entity) {
        return this.transfers.contains(entity);
    }

    @Override
    public void registerTransfer(ISparkEntity entity) {
        if (this.hasTransfer(entity)) {
            return;
        }
        this.transfers.add(entity);
    }

    @Override
    public SparkUpgradeType getUpgrade() {
        return SparkUpgradeType.values()[(Integer)this.field_70180_af.func_187225_a(UPGRADE)];
    }

    @Override
    public void setUpgrade(SparkUpgradeType upgrade) {
        this.field_70180_af.func_187227_b(UPGRADE, (Object)upgrade.ordinal());
    }

    @Override
    public boolean areIncomingTransfersDone() {
        ISparkAttachable tile = this.getAttachedTile();
        if (tile instanceof IManaPool) {
            return this.removeTransferants > 0;
        }
        return tile != null && tile.areIncomingTranfersDone();
    }
}

