/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.corporea;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestEvent;
import vazkii.botania.api.corporea.ICorporeaInterceptor;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaResult;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.IWrappedInventory;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.common.block.tile.corporea.TileCorporeaRetainer;
import vazkii.botania.common.impl.corporea.CorporeaItemStackMatcher;
import vazkii.botania.common.impl.corporea.CorporeaRequest;
import vazkii.botania.common.impl.corporea.CorporeaResult;
import vazkii.botania.common.impl.corporea.CorporeaStringMatcher;

public class CorporeaHelperImpl
implements CorporeaHelper {
    private final WeakHashMap<List<ICorporeaSpark>, List<InvWithLocation>> cachedNetworks = new WeakHashMap();

    @Override
    public List<InvWithLocation> getInventoriesOnNetwork(ICorporeaSpark spark) {
        List<InvWithLocation> cache;
        ICorporeaSpark master = spark.getMaster();
        if (master == null) {
            return Collections.emptyList();
        }
        List<ICorporeaSpark> network = master.getConnections();
        if (this.cachedNetworks.containsKey(network) && (cache = this.cachedNetworks.get(network)) != null) {
            return cache;
        }
        ArrayList<InvWithLocation> inventories = new ArrayList<InvWithLocation>();
        if (network != null) {
            for (ICorporeaSpark otherSpark : network) {
                InvWithLocation inv;
                if (otherSpark == null || (inv = otherSpark.getSparkInventory()) == null) continue;
                inventories.add(inv);
            }
        }
        this.cachedNetworks.put(network, inventories);
        return inventories;
    }

    @Override
    public int getCountInNetwork(ICorporeaRequestMatcher matcher, ICorporeaSpark spark) {
        List<InvWithLocation> inventories = this.getInventoriesOnNetwork(spark);
        return this.getCountInNetwork(matcher, inventories);
    }

    @Override
    public int getCountInNetwork(ICorporeaRequestMatcher matcher, List<InvWithLocation> inventories) {
        Map<InvWithLocation, Integer> map = this.getInventoriesWithMatchInNetwork(matcher, inventories);
        return this.getCountInNetwork(matcher, map);
    }

    @Override
    public int getCountInNetwork(ICorporeaRequestMatcher matcher, Map<InvWithLocation, Integer> inventories) {
        int count = 0;
        for (int value : inventories.values()) {
            count += value;
        }
        return count;
    }

    @Override
    public Map<InvWithLocation, Integer> getInventoriesWithMatchInNetwork(ICorporeaRequestMatcher matcher, ICorporeaSpark spark) {
        List<InvWithLocation> inventories = this.getInventoriesOnNetwork(spark);
        return this.getInventoriesWithMatchInNetwork(matcher, inventories);
    }

    @Override
    public Map<InvWithLocation, Integer> getInventoriesWithMatchInNetwork(ICorporeaRequestMatcher matcher, List<InvWithLocation> inventories) {
        HashMap<InvWithLocation, Integer> countMap = new HashMap<InvWithLocation, Integer>();
        List<IWrappedInventory> wrappedInventories = BotaniaAPI.instance().internalHandler().wrapInventory(inventories);
        for (IWrappedInventory inv : wrappedInventories) {
            CorporeaRequest request = new CorporeaRequest(matcher, -1);
            inv.countItems(request);
            if (request.getFound() <= 0) continue;
            countMap.put(inv.getWrappedObject(), request.getFound());
        }
        return countMap;
    }

    @Override
    public ICorporeaRequestMatcher createMatcher(ItemStack stack, boolean checkNBT) {
        return new CorporeaItemStackMatcher(stack, checkNBT);
    }

    @Override
    public ICorporeaRequestMatcher createMatcher(String name) {
        return new CorporeaStringMatcher(name);
    }

    @Override
    public ICorporeaResult requestItem(ICorporeaRequestMatcher matcher, int itemCount, ICorporeaSpark spark, boolean doit) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        CorporeaRequestEvent event = new CorporeaRequestEvent(matcher, itemCount, spark, !doit);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return new CorporeaResult(stacks, 0, 0);
        }
        List<InvWithLocation> inventories = this.getInventoriesOnNetwork(spark);
        List<IWrappedInventory> inventoriesW = BotaniaAPI.instance().internalHandler().wrapInventory(inventories);
        HashMap<ICorporeaInterceptor, ICorporeaSpark> interceptors = new HashMap<ICorporeaInterceptor, ICorporeaSpark>();
        CorporeaRequest request = new CorporeaRequest(matcher, itemCount);
        for (IWrappedInventory inv : inventoriesW) {
            ICorporeaSpark invSpark = inv.getSpark();
            InvWithLocation originalInventory = inv.getWrappedObject();
            if (originalInventory.getWorld().func_175625_s(originalInventory.getPos()) instanceof ICorporeaInterceptor) {
                ICorporeaInterceptor interceptor = (ICorporeaInterceptor)originalInventory.getWorld().func_175625_s(originalInventory.getPos());
                interceptor.interceptRequest(matcher, itemCount, invSpark, spark, stacks, inventories, doit);
                interceptors.put(interceptor, invSpark);
            }
            if (doit) {
                stacks.addAll(inv.extractItems(request));
                continue;
            }
            stacks.addAll(inv.countItems(request));
        }
        for (ICorporeaInterceptor interceptor : interceptors.keySet()) {
            interceptor.interceptRequestLast(matcher, itemCount, (ICorporeaSpark)interceptors.get(interceptor), spark, stacks, inventories, doit);
        }
        return new CorporeaResult(stacks, request.getFound(), request.getExtracted());
    }

    @Override
    public ICorporeaSpark getSparkForInventory(InvWithLocation inv) {
        TileEntity tile = inv.getWorld().func_175625_s(inv.getPos());
        return this.getSparkForBlock(tile.func_145831_w(), tile.func_174877_v());
    }

    @Override
    public ICorporeaSpark getSparkForBlock(World world, BlockPos pos) {
        List sparks = world.func_175647_a(Entity.class, new AxisAlignedBB(pos.func_177984_a(), pos.func_177982_a(1, 2, 1)), (Predicate)Predicates.instanceOf(ICorporeaSpark.class));
        return sparks.isEmpty() ? null : (ICorporeaSpark)sparks.get(0);
    }

    @Override
    public int signalStrengthForRequestSize(int requestSize) {
        if (requestSize <= 0) {
            return 0;
        }
        if (requestSize >= 16384) {
            return 15;
        }
        return Math.min(15, MathHelper.func_151239_c((int)requestSize) + 1);
    }

    @Override
    public <T extends ICorporeaRequestMatcher> void registerRequestMatcher(ResourceLocation id, Class<T> clazz, Function<CompoundNBT, T> deserializer) {
        TileCorporeaRetainer.addCorporeaRequestMatcher(id, clazz, deserializer);
    }

    public void clearCache() {
        this.cachedNetworks.clear();
    }
}

