/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import vazkii.botania.client.core.handler.BaubleRenderHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemItemFinder
extends ItemBauble {
    private static final String TAG_ENTITY_POSITIONS = "highlightPositionsEnt";
    private static final String TAG_BLOCK_POSITIONS = "highlightPositionsBlock";

    public ItemItemFinder(Item.Properties props) {
        super(props);
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
        if (!(player instanceof PlayerEntity)) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            this.tickClient(stack, (PlayerEntity)player);
        } else {
            this.tickServer(stack, (PlayerEntity)player);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(BaubleRenderHandler layer, ItemStack stack, LivingEntity living, MatrixStack ms, IRenderTypeBuffer buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean armor = !living.func_184582_a(EquipmentSlotType.HEAD).func_190926_b();
        ((PlayerModel)layer.func_215332_c()).field_78116_c.func_228307_a_(ms);
        ms.func_227861_a_(-0.35, -0.2, armor ? 0.05 : 0.1);
        ms.func_227862_a_(0.75f, -0.75f, -0.75f);
        IBakedModel model = MiscellaneousIcons.INSTANCE.itemFinderGem;
        IVertexBuilder buffer = buffers.getBuffer(Atlases.func_228783_h_());
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, OverlayTexture.field_229196_a_);
    }

    protected void tickClient(ItemStack stack, PlayerEntity player) {
        int[] entities;
        if (!Botania.proxy.isTheClientPlayer((LivingEntity)player)) {
            return;
        }
        ListNBT blocks = ItemNBTHelper.getList(stack, TAG_BLOCK_POSITIONS, 4, false);
        for (int i = 0; i < blocks.size(); ++i) {
            BlockPos pos = BlockPos.func_218283_e((long)((LongNBT)blocks.get(i)).func_150291_c());
            float m = 0.02f;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), false);
            player.field_70170_p.func_195594_a((IParticleData)data, (double)((float)pos.func_177958_n() + (float)Math.random()), (double)((float)pos.func_177956_o() + (float)Math.random()), (double)((float)pos.func_177952_p() + (float)Math.random()), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)));
        }
        for (int i : entities = ItemNBTHelper.getIntArray(stack, TAG_ENTITY_POSITIONS)) {
            Entity e = player.field_70170_p.func_73045_a(i);
            if (e == null || !(Math.random() < 0.6)) continue;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), Math.random() < 0.6);
            player.field_70170_p.func_195594_a((IParticleData)data, e.func_226277_ct_() + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), e.func_226278_cu_() + (double)e.func_213302_cg(), e.func_226281_cx_() + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), 0.0, (double)(0.05f + 0.03f * (float)Math.random()), 0.0);
        }
    }

    protected void tickServer(ItemStack stack, PlayerEntity player) {
        IntArrayList entPosBuilder = new IntArrayList();
        ListNBT blockPosBuilder = new ListNBT();
        this.scanForStack(player.func_184614_ca(), player, entPosBuilder, blockPosBuilder);
        this.scanForStack(player.func_184592_cb(), player, entPosBuilder, blockPosBuilder);
        int[] currentEnts = entPosBuilder.elements();
        ItemNBTHelper.setIntArray(stack, TAG_ENTITY_POSITIONS, currentEnts);
        ItemNBTHelper.setList(stack, TAG_BLOCK_POSITIONS, blockPosBuilder);
    }

    private void scanForStack(ItemStack pstack, PlayerEntity player, IntArrayList entIdBuilder, ListNBT blockPosBuilder) {
        if (!pstack.func_190926_b() || player.func_225608_bj_()) {
            int range = 24;
            List entities = player.field_70170_p.func_217357_a(Entity.class, new AxisAlignedBB(player.func_226277_ct_() - (double)range, player.func_226278_cu_() - (double)range, player.func_226281_cx_() - (double)range, player.func_226277_ct_() + (double)range, player.func_226278_cu_() + (double)range, player.func_226281_cx_() + (double)range));
            for (Entity e : entities) {
                IInventory inv;
                if (e == player) continue;
                if (e instanceof ItemEntity) {
                    ItemEntity item = (ItemEntity)e;
                    ItemStack istack = item.func_92059_d();
                    if (!player.func_225608_bj_() && (!istack.func_77969_a(pstack) || !ItemStack.func_77970_a((ItemStack)istack, (ItemStack)pstack))) continue;
                    entIdBuilder.add(item.func_145782_y());
                    continue;
                }
                if (e instanceof PlayerEntity) {
                    PlayerEntity player_ = (PlayerEntity)e;
                    LazyOptional playerInv = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                    LazyOptional<IItemHandlerModifiable> binv = EquipmentHandler.getAllWorn((LivingEntity)player);
                    if (!this.scanInventory((LazyOptional<? extends IItemHandler>)playerInv, pstack) && !this.scanInventory(binv, pstack)) continue;
                    entIdBuilder.add(player_.func_145782_y());
                    continue;
                }
                if (e instanceof AbstractVillagerEntity) {
                    AbstractVillagerEntity villager = (AbstractVillagerEntity)e;
                    for (MerchantOffer offer : villager.func_213706_dY()) {
                        if (!this.equalStacks(pstack, offer.func_222218_a()) && !this.equalStacks(pstack, offer.func_222202_c()) && !this.equalStacks(pstack, offer.func_222200_d())) continue;
                        entIdBuilder.add(villager.func_145782_y());
                    }
                    continue;
                }
                if (e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                    if (!this.scanInventory((LazyOptional<? extends IItemHandler>)e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY), pstack)) continue;
                    entIdBuilder.add(e.func_145782_y());
                    continue;
                }
                if (!(e instanceof IInventory) || !this.scanInventory((LazyOptional<? extends IItemHandler>)LazyOptional.of(() -> ItemItemFinder.lambda$scanForStack$0(inv = (IInventory)e)), pstack)) continue;
                entIdBuilder.add(e.func_145782_y());
            }
            if (!pstack.func_190926_b()) {
                range = 12;
                BlockPos pos = new BlockPos((Entity)player);
                for (BlockPos pos_ : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range + 1, range + 1, range + 1))) {
                    IInventory inv;
                    TileEntity tile = player.field_70170_p.func_175625_s(pos_);
                    if (tile == null) continue;
                    boolean foundCap = false;
                    for (Direction e : Direction.values()) {
                        if (!this.scanInventory((LazyOptional<? extends IItemHandler>)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, e), pstack)) continue;
                        blockPosBuilder.add((Object)LongNBT.func_229698_a_((long)pos_.func_218275_a()));
                        foundCap = true;
                        break;
                    }
                    if (foundCap || !(tile instanceof IInventory) || !this.scanInventory((LazyOptional<? extends IItemHandler>)LazyOptional.of(() -> ItemItemFinder.lambda$scanForStack$1(inv = (IInventory)tile)), pstack)) continue;
                    blockPosBuilder.add((Object)LongNBT.func_229698_a_((long)pos_.func_218275_a()));
                }
            }
        }
    }

    private boolean equalStacks(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private boolean scanInventory(LazyOptional<? extends IItemHandler> optInv, ItemStack pstack) {
        return (Boolean)optInv.map(inv -> this.scanInventory((IItemHandler)inv, pstack)).orElse((Object)false);
    }

    private boolean scanInventory(IItemHandler inv, ItemStack pstack) {
        if (pstack.func_190926_b()) {
            return false;
        }
        for (int l = 0; l < inv.getSlots(); ++l) {
            ItemStack istack = inv.getStackInSlot(l);
            if (istack.func_190926_b() || !this.equalStacks(istack, pstack)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ InvWrapper lambda$scanForStack$1(IInventory inv) {
        return new InvWrapper(inv);
    }

    private static /* synthetic */ InvWrapper lambda$scanForStack$0(IInventory inv) {
        return new InvWrapper(inv);
    }
}

