/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.material;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.IRegistryDelegate;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.common.core.helper.ColorHelper;
import vazkii.botania.common.item.Item16Colors;

public class ItemDye
extends Item16Colors {
    public ItemDye(DyeColor color, Item.Properties props) {
        super(color, props);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        IManaPool pool;
        BlockPos pos;
        ItemStack stack = ctx.func_195996_i();
        World world = ctx.func_195991_k();
        Block block = world.func_180495_p(pos = ctx.func_195995_a()).func_177230_c();
        if (this.shouldRecolor(block)) {
            world.func_175656_a(pos, this.recolor(block, this.color));
            stack.func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IManaPool && this.color != (pool = (IManaPool)tile).getColor()) {
            pool.setColor(this.color);
            stack.func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (target instanceof SheepEntity) {
            SheepEntity entitysheep = (SheepEntity)target;
            if (!entitysheep.func_70892_o() && entitysheep.func_175509_cj() != this.color) {
                entitysheep.func_175512_b(this.color);
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    private boolean shouldRecolor(Block block) {
        DyeColor woolColor = (DyeColor)ColorHelper.WOOL_MAP.inverse().get((Object)block.delegate);
        if (woolColor != null) {
            return woolColor != this.color;
        }
        DyeColor carpetColor = (DyeColor)ColorHelper.CARPET_MAP.inverse().get((Object)block.delegate);
        if (carpetColor != null) {
            return carpetColor != this.color;
        }
        return false;
    }

    private BlockState recolor(Block original, DyeColor color) {
        if (ColorHelper.CARPET_MAP.containsValue((Object)original.delegate)) {
            return ((Block)((IRegistryDelegate)ColorHelper.CARPET_MAP.get((Object)color)).get()).func_176223_P();
        }
        return ((Block)((IRegistryDelegate)ColorHelper.WOOL_MAP.get((Object)color)).get()).func_176223_P();
    }
}

