/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.dimension.end.biome;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import voronoiaoc.byg.BYG;
import voronoiaoc.byg.config.BYGWorldConfig;
import voronoiaoc.byg.core.byglists.BYGBiomeList;

public class BYGEndBiomeCatch {
    public static ForgeRegistry<Biome> BiomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;
    public static final int IVISFIELDS = BiomeRegistry.getID((IForgeRegistryEntry)BYGBiomeList.IVISFIELDS);
    public static final int SMALLENDISLANDS = BiomeRegistry.getID((IForgeRegistryEntry)Biomes.field_201936_P);
    public static final int ENDBARRENS = BiomeRegistry.getID((IForgeRegistryEntry)Biomes.field_201939_S);
    public static final int ENDHIGHLANDS = BiomeRegistry.getID((IForgeRegistryEntry)Biomes.field_201938_R);
    public static final int ENDMIDLANDS = BiomeRegistry.getID((IForgeRegistryEntry)Biomes.field_201937_Q);
    public static final int POISEFOREST = BiomeRegistry.getID(new ResourceLocation("endergetic:poise_forest"));
    static String biomeRegistries = (String)BYGWorldConfig.externalEndBiomes.get();
    public static String configBiomes = biomeRegistries.trim().replace(" ", "");
    public static List<String> biomeList = Arrays.asList(configBiomes.split(","));
    public static ArrayList<Integer> endBiomeIDs = new ArrayList();

    public static void endBiomeConfigCollection() {
        BYG.LOGGER.debug("BYG: End Biome Config Collection starting...");
        if (biomeList.size() > 0) {
            int[] getConfigArray = new int[biomeList.size()];
            for (int index = 0; index < biomeList.size(); ++index) {
                Biome configResource = (Biome)BiomeRegistry.getValue(new ResourceLocation(biomeList.get(index)));
                if (configResource == null) {
                    BYG.LOGGER.warn("Illegal registry name! You put: " + configResource);
                    continue;
                }
                if (configResource == null) continue;
                getConfigArray[index] = BiomeRegistry.getID((IForgeRegistryEntry)configResource);
                Biome biome = (Biome)Registry.field_212624_m.func_148745_a(getConfigArray[index]);
                if (biome == null) continue;
                endBiomeIDs.add(Registry.field_212624_m.func_148757_b((Object)biome));
            }
        }
        BYG.LOGGER.debug("BYG: End Biome Config Collection complete!");
    }

    public static int getRandomEndBiomes(INoiseRandom rand) {
        return endBiomeIDs.get(rand.func_202696_a(endBiomeIDs.size()));
    }

    static {
        endBiomeIDs.add(SMALLENDISLANDS);
        endBiomeIDs.add(ENDBARRENS);
        endBiomeIDs.add(ENDHIGHLANDS);
        endBiomeIDs.add(ENDMIDLANDS);
        endBiomeIDs.add(IVISFIELDS);
        if (ModList.get().isLoaded("endergetic")) {
            endBiomeIDs.add(POISEFOREST);
        }
    }
}

