/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.dimension.nether.biome;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import voronoiaoc.byg.BYG;
import voronoiaoc.byg.config.BYGWorldConfig;
import voronoiaoc.byg.core.byglists.BYGBiomeList;

public class BYGNetherBiomeCatch {
    public static ForgeRegistry<Biome> BiomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;
    public static ForgeRegistry<ModDimension> DimRegistry = (ForgeRegistry)ForgeRegistries.MOD_DIMENSIONS;
    public static final int NETHER = BiomeRegistry.getID((IForgeRegistryEntry)Biomes.field_76778_j);
    public static final int WARPEDDESERT = BiomeRegistry.getID((IForgeRegistryEntry)BYGBiomeList.WARPEDDESERT);
    public static final int SYTHIANTORRIDS = BiomeRegistry.getID((IForgeRegistryEntry)BYGBiomeList.SYTHIANTORRIDS);
    public static final int GLOWSTONEGARDENS = BiomeRegistry.getID((IForgeRegistryEntry)BYGBiomeList.GLOWSTONEGARDENS);
    public static final int ASHENINFERNO = BiomeRegistry.getID(new ResourceLocation("biomesoplenty:ashen_inferno"));
    public static final int UNDERGARDEN = BiomeRegistry.getID(new ResourceLocation("biomesoplenty:undergarden"));
    public static final int VISCERALHEAP = BiomeRegistry.getID(new ResourceLocation("biomesoplenty:visceral_heap"));
    static String biomeRegistries = (String)BYGWorldConfig.externalNetherBiomes.get();
    public static String configBiomes = biomeRegistries.trim();
    public static List<String> biomeList = Arrays.asList(configBiomes.split(","));
    public static ArrayList<Integer> netherBiomeIDS = new ArrayList();

    public static void netherBiomeConfigCollection() {
        BYG.LOGGER.debug("BYG: Nether Biome Config Collection starting...");
        if (biomeList.size() > 0) {
            int[] getConfigArray = new int[biomeList.size()];
            for (int index = 0; index < biomeList.size(); ++index) {
                Biome configResource = (Biome)BiomeRegistry.getValue(new ResourceLocation(biomeList.get(index)));
                if (configResource == null) {
                    BYG.LOGGER.warn("Illegal registry name! You put: " + configResource);
                    continue;
                }
                if (configResource == null) continue;
                getConfigArray[index] = BiomeRegistry.getID((IForgeRegistryEntry)configResource);
                Biome biome = (Biome)Registry.field_212624_m.func_148745_a(getConfigArray[index]);
                if (biome == null) {
                    BYG.LOGGER.warn("Illegal registry name! You put: " + configResource);
                    continue;
                }
                netherBiomeIDS.add(Registry.field_212624_m.func_148757_b((Object)biome));
            }
        }
        BYG.LOGGER.debug("BYG: Nether Biome Config Collection completed!");
    }

    public static int getRandomNetherBiomes(INoiseRandom rand) {
        return netherBiomeIDS.get(rand.func_202696_a(netherBiomeIDS.size()));
    }

    public static Set<Biome> getBiomeSet() {
        return new HashSet<Biome>(ForgeRegistries.BIOMES.getValues());
    }

    static {
        netherBiomeIDS.add(NETHER);
        netherBiomeIDS.add(WARPEDDESERT);
        netherBiomeIDS.add(SYTHIANTORRIDS);
        netherBiomeIDS.add(GLOWSTONEGARDENS);
        if (ModList.get().isLoaded("biomesoplenty")) {
            netherBiomeIDS.add(ASHENINFERNO);
            netherBiomeIDS.add(UNDERGARDEN);
            netherBiomeIDS.add(VISCERALHEAP);
        }
    }
}

