/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.dimension.nether.chunk;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.feature.Feature;
import voronoiaoc.byg.common.world.dimension.nether.chunk.BYGNetherGenSettings;
import voronoiaoc.byg.common.world.worldtype.chunk.simplex.Simplex3DNoiseChunkGenerator;
import voronoiaoc.byg.config.BYGWorldConfig;

public class BYGNetherChunkGenerator
extends Simplex3DNoiseChunkGenerator<BYGNetherGenSettings> {
    public final double[] constHeightThresholds = this.generateConstHeightThresholds();

    public static int netherHeight() {
        return (Boolean)BYGWorldConfig.tallNether.get() != false ? 256 : 128;
    }

    public BYGNetherChunkGenerator(World world, BiomeProvider provider, BYGNetherGenSettings settings) {
        super((IWorld)world, provider, 4, BYGNetherChunkGenerator.netherHeight(), settings, 4, 2, 684.412, 2053.236, 8.555150000000001, 34.2206);
    }

    @Override
    protected double[] getColumnBiomeParams(int biomeParam1, int biomeParam2) {
        return new double[]{0.0, 0.0};
    }

    @Override
    protected double getHeightThreshold(double biomeParam1, double biomeParam2, int y) {
        return this.constHeightThresholds[y];
    }

    private double[] generateConstHeightThresholds() {
        double[] thresholds = new double[256];
        double g = 13.0;
        double gd = 3.0;
        double gg = -10.0;
        for (int y = 0; y < BYGNetherChunkGenerator.netherHeight(); ++y) {
            thresholds[y] = Math.cos((double)y * Math.PI * 6.0 / (double)BYGNetherChunkGenerator.netherHeight()) * 2.0;
            double yc = (double)y / 8.0;
            if (yc > (double)BYGNetherChunkGenerator.netherHeight() / 16.0) {
                yc = (double)BYGNetherChunkGenerator.netherHeight() / 8.0 - 1.0 - yc;
            }
            if (yc < 4.0) {
                yc = 4.0 - yc;
                int n = y;
                thresholds[n] = thresholds[n] - yc * yc * yc * 10.0;
            }
            if (!(yc > g)) continue;
            double t = (yc - g) / gd;
            t = t > 1.0 ? 1.0 : t * t * (3.0 - 2.0 * t);
            int n = y;
            thresholds[n] = thresholds[n] - t * gg / (1.0 - t);
        }
        return thresholds;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification creatureType, BlockPos pos) {
        if (creatureType == EntityClassification.MONSTER) {
            if (Feature.field_202337_o.func_202366_b(this.field_222540_a, pos)) {
                return Feature.field_202337_o.func_202279_e();
            }
            if (Feature.field_202337_o.func_175796_a(this.field_222540_a, pos) && this.field_222540_a.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196653_dH) {
                return Feature.field_202337_o.func_202279_e();
            }
        }
        return super.func_177458_a(creatureType, pos);
    }

    public int func_205470_d() {
        return this.field_222540_a.func_181545_F() + 1;
    }

    public int func_207511_e() {
        return BYGNetherChunkGenerator.netherHeight();
    }

    public int func_222530_f() {
        return 32;
    }
}

