/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.dimension.nether.hooks;

import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.dimension.NetherDimension;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import voronoiaoc.byg.common.biomes.BiomeFog;
import voronoiaoc.byg.common.world.dimension.nether.biome.BYGNetherBiomeProvider;
import voronoiaoc.byg.common.world.dimension.nether.chunk.BYGNetherChunkGenerator;
import voronoiaoc.byg.common.world.dimension.nether.chunk.BYGNetherGenSettings;

public class ClientNetherDimensionHook
extends NetherDimension {
    public static ChunkGeneratorType<BYGNetherGenSettings, BYGNetherChunkGenerator> SIMPLEXTALLCAVES = new ChunkGeneratorType(BYGNetherChunkGenerator::new, true, BYGNetherGenSettings::new);
    private static final Vec3d NETHERDEFAULTVEC3D = new Vec3d((double)0.2f, (double)0.03f, (double)0.03f);

    public ClientNetherDimensionHook(World worldIn, DimensionType typeIn) {
        super(worldIn, typeIn);
    }

    public ChunkGenerator<?> func_186060_c() {
        BYGNetherGenSettings nethergensettings = (BYGNetherGenSettings)SIMPLEXTALLCAVES.func_205483_a();
        nethergensettings.func_214969_a(Blocks.field_150424_aL.func_176223_P());
        nethergensettings.func_214970_b(Blocks.field_150353_l.func_176223_P());
        return SIMPLEXTALLCAVES.create(this.field_76579_a, (BiomeProvider)new BYGNetherBiomeProvider(this.field_76579_a.func_72905_C()), (GenerationSettings)nethergensettings);
    }

    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        Minecraft client = Minecraft.func_71410_x();
        ClientWorld world = client.field_71441_e;
        assert (world != null);
        Vec3d original = super.func_76562_b(celestialAngle, partialTicks);
        double defaultR = original.func_82615_a();
        defaultR *= defaultR;
        double defaultG = original.func_82617_b();
        defaultG *= defaultG;
        double defaultB = original.func_82616_c();
        defaultB *= defaultB;
        assert (client.field_71439_g != null);
        BlockPos playerPos = client.field_71439_g.func_180425_c();
        int x = playerPos.func_177958_n();
        int z = playerPos.func_177952_p();
        boolean modified = false;
        float accumulatedR = 0.0f;
        float accumulatedG = 0.0f;
        float accumulatedB = 0.0f;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int sampleX = x - 8; sampleX <= x + 8; ++sampleX) {
            pos.func_223471_o(sampleX);
            for (int sampleZ = z - 8; sampleZ <= z + 8; ++sampleZ) {
                pos.func_223472_q(sampleZ);
                Biome biome = world.func_226691_t_((BlockPos)pos);
                if (biome instanceof BiomeFog) {
                    modified = true;
                    Vec3d biomeFogColour = ((BiomeFog)biome).getBiomeFogColor(sampleX, sampleZ, original);
                    double r = biomeFogColour.func_82615_a();
                    double g = biomeFogColour.func_82617_b();
                    double b = biomeFogColour.func_82616_c();
                    accumulatedR = (float)((double)accumulatedR + r * r);
                    accumulatedG = (float)((double)accumulatedG + g * g);
                    accumulatedB = (float)((double)accumulatedB + b * b);
                    continue;
                }
                accumulatedR = (float)((double)accumulatedR + defaultR);
                accumulatedG = (float)((double)accumulatedG + defaultG);
                accumulatedB = (float)((double)accumulatedB + defaultB);
            }
        }
        if (modified) {
            double divisor = 289.0;
            return new Vec3d(Math.sqrt((double)accumulatedR / 289.0), Math.sqrt((double)accumulatedG / 289.0), Math.sqrt((double)accumulatedB / 289.0));
        }
        return NETHERDEFAULTVEC3D;
    }
}

