/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.nether.warpeddesert;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public class WarpedCoralFeature
extends Feature<NoFeatureConfig> {
    public static boolean doBlockNotify;

    public WarpedCoralFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        int randCoralHeight = rand.nextInt(7) + 8;
        BlockPos blockPos = new BlockPos(posX, posY, posZ);
        BlockPos.Mutable block = new BlockPos.Mutable(blockPos);
        if (!this.checkArea(worldIn, pos)) {
            return false;
        }
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == BYGBlockList.NYLIUM_SOUL_SAND || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == BYGBlockList.NYLIUM_SOUL_SOIL) {
            for (int i = 0; i <= randCoralHeight; ++i) {
                BlockPos.Mutable mutable = new BlockPos.Mutable((BlockPos)block);
                this.setCoralBlock((IWorldWriter)worldIn, (BlockPos)mutable);
                this.setCoralBlock((IWorldWriter)worldIn, (BlockPos)mutable.func_189534_c(Direction.UP, i));
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    this.setCoralBlock((IWorldWriter)worldIn, mutable.func_177967_a(direction, i / 2));
                }
            }
        }
        return true;
    }

    protected void setCoralBlock(IWorldWriter worldIn, BlockPos pos) {
        this.setBlockStateWithoutUpdates(worldIn, pos, BYGBlockList.WARPED_CORAL_BLOCK.func_176223_P());
    }

    private void setBlockStateWithoutUpdates(IWorldWriter worldWriter, BlockPos blockPos, BlockState blockState) {
        if (doBlockNotify) {
            worldWriter.func_180501_a(blockPos, blockState, 19);
        } else {
            worldWriter.func_180501_a(blockPos, blockState, 18);
        }
    }

    private boolean checkArea(IWorld world, BlockPos pos) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        for (int checkX = -2; checkX <= 2; ++checkX) {
            for (int checkZ = -2; checkZ <= 2; ++checkZ) {
                BlockPos checkArea = new BlockPos(posX + checkX, posY, posZ + checkZ);
                if (!world.func_175623_d(checkArea)) {
                    return false;
                }
                if (world.func_180495_p(checkArea).func_177230_c() != BYGBlockList.WARPED_CORAL_BLOCK) continue;
                return false;
            }
        }
        return true;
    }
}

