/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.overworld.trees.mangrove;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import voronoiaoc.byg.common.world.feature.features.overworld.trees.util.BYGAbstractTreeFeature;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public class MangroveTree1
extends BYGAbstractTreeFeature<NoFeatureConfig> {
    public MangroveTree1(Function<Dynamic<?>, ? extends NoFeatureConfig> configIn) {
        super(configIn);
    }

    @Override
    protected boolean place(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos pos, MutableBoundingBox boundsIn) {
        int randTreeHeight = 10 + rand.nextInt(5);
        BlockPos.Mutable mainmutable = new BlockPos.Mutable(pos);
        if (pos.func_177956_o() + randTreeHeight + 1 < worldIn.getMaxHeight()) {
            BlockPos blockpos = pos.func_177977_b();
            if (!MangroveTree1.isDesiredGround((IWorldGenerationBaseReader)worldIn, blockpos, Blocks.field_196658_i) || !MangroveTree1.isDesiredGround((IWorldGenerationBaseReader)worldIn, blockpos, BYGBlockList.MOSSY_STONE)) {
                return false;
            }
            if (!this.doesTreeFit((IWorldGenerationBaseReader)worldIn, pos, randTreeHeight)) {
                return false;
            }
            for (int buildTrunk = 3; buildTrunk <= randTreeHeight; ++buildTrunk) {
                if (buildTrunk == 3) {
                    mainmutable.func_189534_c(Direction.UP, 3);
                }
                this.treeLog(changedBlocks, worldIn, (BlockPos)mainmutable, boundsIn);
                mainmutable.func_189536_c(Direction.UP);
            }
            mainmutable.func_189533_g((Vec3i)pos);
            BlockPos.Mutable rootMutable = new BlockPos.Mutable(mainmutable.func_177982_a(0, 0, -2));
            BlockPos.Mutable rootMutable2 = new BlockPos.Mutable(mainmutable.func_177982_a(-1, 0, -1));
            BlockPos.Mutable rootMutable3 = new BlockPos.Mutable(mainmutable.func_177982_a(2, 0, -4));
            BlockPos.Mutable rootMutable4 = new BlockPos.Mutable(mainmutable.func_177982_a(-3, 0, 1));
            BlockPos.Mutable rootMutable5 = new BlockPos.Mutable(mainmutable.func_177982_a(1, 0, 1));
            BlockPos.Mutable rootMutable6 = new BlockPos.Mutable(mainmutable.func_177982_a(-2, 0, 2));
            for (int buildRoot = 0; buildRoot <= 5; ++buildRoot) {
                this.treeBranch(changedBlocks, worldIn, (BlockPos)rootMutable, boundsIn);
                this.treeBranch(changedBlocks, worldIn, (BlockPos)rootMutable2, boundsIn);
                this.treeBranch(changedBlocks, worldIn, (BlockPos)rootMutable3, boundsIn);
                this.treeBranch(changedBlocks, worldIn, (BlockPos)rootMutable4, boundsIn);
                this.treeBranch(changedBlocks, worldIn, (BlockPos)rootMutable5, boundsIn);
                this.treeBranch(changedBlocks, worldIn, (BlockPos)rootMutable6, boundsIn);
                rootMutable.func_189536_c(Direction.DOWN);
                rootMutable2.func_189536_c(Direction.DOWN);
                rootMutable3.func_189536_c(Direction.DOWN);
                rootMutable4.func_189536_c(Direction.DOWN);
                rootMutable5.func_189536_c(Direction.DOWN);
                rootMutable6.func_189536_c(Direction.DOWN);
            }
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 1, -2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 1, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, 1, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(2, 1, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 1, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 1, 2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 2, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, 2, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 2, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 3, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, 3, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 3, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 4, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 4, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, 4, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 5, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 5, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 5, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 6, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 7, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight, 2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight, 3), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight - 1, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight - 1, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight - 1, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight - 1, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight - 1, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight - 1, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight - 1, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight - 1, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight - 1, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight - 1, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight - 1, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight - 1, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight - 1, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight - 1, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight - 1, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight - 1, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight, -4), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight, -4), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight, -3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight, -3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight, -3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight, -3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight, -3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight, -3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, randTreeHeight, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(4, randTreeHeight, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-4, randTreeHeight, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, randTreeHeight, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(4, randTreeHeight, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(5, randTreeHeight, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-4, randTreeHeight, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, randTreeHeight, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(4, randTreeHeight, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(5, randTreeHeight, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, randTreeHeight, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, randTreeHeight, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, randTreeHeight, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(4, randTreeHeight, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight, 4), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight, 4), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight, 4), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight, 4), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight, 4), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight, 4), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight, 5), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight, 5), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight, 5), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight, 5), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight, 6), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight, 6), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight + 1, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight + 1, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight + 1, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight + 1, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight + 1, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight + 1, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight + 1, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight + 1, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight + 1, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight + 1, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight + 1, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight + 1, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight + 1, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight + 1, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight + 1, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight + 1, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight + 1, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight + 1, 3), boundsIn);
        }
        return true;
    }

    private void treeLog(Set<BlockPos> setlogblock, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (MangroveTree1.isQualifiedForLogWater((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, BYGBlockList.MANGROVE_LOG.func_176223_P(), boundingBox);
        }
    }

    private void treeBranch(Set<BlockPos> setlogblock, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (MangroveTree1.isQualifiedForLogWater((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, BYGBlockList.MANGROVE_LOG.func_176223_P(), boundingBox);
        }
    }

    private void leafs(Set<BlockPos> blockPos, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        BlockPos.Mutable blockpos = new BlockPos.Mutable(pos);
        if (MangroveTree1.isAirOrWater((IWorldGenerationBaseReader)reader, (BlockPos)blockpos)) {
            this.setFinalBlockState(blockPos, (IWorldWriter)reader, (BlockPos)blockpos, BYGBlockList.MANGROVE_LEAVES.func_176223_P(), boundingBox);
        }
    }

    private boolean doesTreeFit(IWorldGenerationBaseReader reader, BlockPos blockPos, int height) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int yOffset = 0; yOffset <= height + 1; ++yOffset) {
            int distance = 2;
            for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                    if (MangroveTree1.canTreePlaceHereWater(reader, (BlockPos)pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

