/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.overworld.trees.palo_verde;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import voronoiaoc.byg.common.world.feature.features.overworld.trees.util.BYGAbstractTreeFeature;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public class PaloVerdeTree2
extends BYGAbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = BYGBlockList.PALO_VERDE_LOG.func_176223_P();
    private static final BlockState LEAVES = BYGBlockList.PALO_VERDE_LEAVES.func_176223_P();
    private static final BlockState LEAVES2 = BYGBlockList.FLOWERING_PALO_VERDE_LEAVES.func_176223_P();
    private static final BlockState BEENEST = Blocks.field_226905_ma_.func_176223_P();
    Random random = new Random();

    public PaloVerdeTree2(Function<Dynamic<?>, ? extends NoFeatureConfig> configIn, int beeHiveChance) {
        super(configIn);
    }

    protected static boolean canTreeReplace(IWorldGenerationBaseReader genBaseReader, BlockPos blockPos) {
        return PaloVerdeTree2.canTreePlaceHere(genBaseReader, blockPos);
    }

    @Override
    public boolean place(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundsIn) {
        int randTreeHeight = rand.nextInt(1) + 1;
        int posX = position.func_177958_n();
        int posY = position.func_177956_o();
        int posZ = position.func_177952_p();
        if (posY >= 1 && posY + randTreeHeight + 1 < worldIn.getMaxHeight()) {
            BlockPos blockpos = position.func_177977_b();
            if (((IWorld)worldIn).func_180495_p(position.func_177977_b()).func_177230_c() != Blocks.field_196658_i && ((IWorld)worldIn).func_180495_p(position.func_177977_b()).func_177230_c() != Blocks.field_196611_F && ((IWorld)worldIn).func_180495_p(position.func_177977_b()).func_177230_c() != Blocks.field_196660_k) {
                return false;
            }
            if (!this.doesTreeFit((IWorldGenerationBaseReader)worldIn, position, randTreeHeight)) {
                return false;
            }
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            int randTreeHeight2 = randTreeHeight - rand.nextInt(1);
            int posY1 = 2 - rand.nextInt(1);
            int posX1 = posX;
            int posZ1 = posZ;
            int topTrunkHeight = posY + randTreeHeight - 1;
            int topTrunkHeight2 = posY + randTreeHeight + randTreeHeight - 1;
            for (int groundUpLogRemover = 0; groundUpLogRemover < randTreeHeight; ++groundUpLogRemover) {
                if (groundUpLogRemover >= randTreeHeight2 && posY1 < 0) {
                    posX1 += direction.func_82601_c();
                    posZ1 += direction.func_82599_e();
                    ++posY1;
                }
                int logplacer = posY + groundUpLogRemover;
                int logplacer2 = posY + randTreeHeight;
                BlockPos blockpos1 = new BlockPos(posX1, logplacer, posZ1);
                BlockPos blockpos2 = new BlockPos(posX1, logplacer2, posZ1);
                this.treelog(changedBlocks, worldIn, blockpos1, boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177974_f().func_177978_c(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177965_g(2).func_177978_c(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177965_g(3).func_177964_d(2).func_177984_a(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177965_g(4).func_177978_c().func_177981_b(2), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177968_d().func_177976_e(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177970_e(2).func_177976_e(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177970_e(3).func_177985_f(2).func_177984_a(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177970_e(3).func_177985_f(2).func_177981_b(2), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177970_e(3).func_177985_f(3).func_177981_b(3), boundsIn);
            }
            int leavessquarespos = 2;
            for (int posXLeafWidth = -leavessquarespos; posXLeafWidth <= leavessquarespos; ++posXLeafWidth) {
                for (int posZLeafWidthL0 = -leavessquarespos; posZLeafWidthL0 <= leavessquarespos; ++posZLeafWidthL0) {
                    int posX2 = posX1 - 2;
                    int posZ2 = posZ1 + 3;
                    int posX3 = posX1 + 4;
                    int posZ3 = posZ1 - 2;
                    this.leafs(worldIn, posX2 + posXLeafWidth, topTrunkHeight + 4, posZ2 + posZLeafWidthL0, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX2 + posXLeafWidth - 2, topTrunkHeight + 4, posZ2 + posZLeafWidthL0, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX2 + posXLeafWidth - 1, topTrunkHeight + 4, posZ2 + posZLeafWidthL0 + 1, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX2 + posXLeafWidth - 1, topTrunkHeight + 4, posZ2 + posZLeafWidthL0 - 1, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX3 + posXLeafWidth, topTrunkHeight + 3, posZ3 + posZLeafWidthL0, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX3 + posXLeafWidth - 2, topTrunkHeight + 3, posZ3 + posZLeafWidthL0, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX3 + posXLeafWidth - 1, topTrunkHeight + 3, posZ3 + posZLeafWidthL0 + 1, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX3 + posXLeafWidth - 1, topTrunkHeight + 3, posZ3 + posZLeafWidthL0 - 1, boundsIn, changedBlocks);
                    if (posXLeafWidth <= 1 && posZLeafWidthL0 <= 1 && posZLeafWidthL0 >= -1 && posXLeafWidth >= -1) {
                        this.leafs(worldIn, posX2 + posXLeafWidth - 1, topTrunkHeight + 5, posZ2 + posZLeafWidthL0, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX3 + posXLeafWidth - 1, topTrunkHeight + 4, posZ3 + posZLeafWidthL0, boundsIn, changedBlocks);
                    }
                    if (posXLeafWidth > 0 || posZLeafWidthL0 > 1 || posZLeafWidthL0 < -1 || posXLeafWidth >= -1) {
                        // empty if block
                    }
                    this.leafs(worldIn, posX2 - 1, topTrunkHeight + 5, posZ2 + 2, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX2 - 3, topTrunkHeight + 5, posZ2, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX2 + 1, topTrunkHeight + 5, posZ2, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX2 - 1, topTrunkHeight + 5, posZ2 - 2, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX3 - 1, topTrunkHeight + 4, posZ3 + 2, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX3 - 3, topTrunkHeight + 4, posZ3, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX3 + 1, topTrunkHeight + 4, posZ3, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX3 - 1, topTrunkHeight + 4, posZ3 - 2, boundsIn, changedBlocks);
                }
            }
            return true;
        }
        return false;
    }

    private boolean doesTreeFit(IWorldGenerationBaseReader reader, BlockPos blockPos, int height) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        BlockPos.Mutable position = new BlockPos.Mutable();
        for (int yOffset = 0; yOffset <= height + 1; ++yOffset) {
            int distance = 4;
            for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                    if (PaloVerdeTree2.canTreeReplace(reader, (BlockPos)position.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void treelog(Set<BlockPos> setlogblock, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (PaloVerdeTree2.canTreeReplace((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, LOG, boundingBox);
        }
    }

    private void leafs(IWorldGenerationReader reader, int x, int y, int z, MutableBoundingBox boundingBox, Set<BlockPos> blockPos) {
        BlockPos blockpos = new BlockPos(x, y, z);
        if (PaloVerdeTree2.isAir((IWorldGenerationBaseReader)reader, blockpos)) {
            this.setFinalBlockState(blockPos, (IWorldWriter)reader, blockpos, this.randomizer(), boundingBox);
        }
    }

    private BlockState randomizer() {
        return this.random.nextInt(3) == 0 ? LEAVES2 : LEAVES;
    }
}

