/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.overworld.trees.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.Template;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public abstract class BYGAbstractTreeFeature<T extends IFeatureConfig>
extends Feature<T> {
    public static boolean doBlockNotify;

    public BYGAbstractTreeFeature(Function<Dynamic<?>, ? extends T> function) {
        super(function);
    }

    public static boolean canTreePlaceHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> {
            Block block = state.func_177230_c();
            return state.func_196958_f() || state.func_203425_a(BlockTags.field_206952_E) || block == Blocks.field_196658_i || Feature.func_227250_b_((Block)block) || block.func_203417_a(BlockTags.field_200031_h) || block.func_203417_a(BlockTags.field_200030_g) || block == Blocks.field_150395_bd || block == BYGBlockList.OVERGROWN_STONE || block == BYGBlockList.GLOWCELIUM;
        });
    }

    public static boolean canTreePlaceHereWater(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> {
            Block block = state.func_177230_c();
            return state.func_196958_f() || state.func_203425_a(BlockTags.field_206952_E) || block == Blocks.field_196658_i || Feature.func_227250_b_((Block)block) || block.func_203417_a(BlockTags.field_200031_h) || block.func_203417_a(BlockTags.field_200030_g) || block == Blocks.field_150395_bd || block == BYGBlockList.OVERGROWN_STONE || block == BYGBlockList.GLOWCELIUM || block == Blocks.field_150355_j;
        });
    }

    public static void setGroundBlock(IWorldGenerationReader reader, Block block, BlockPos ... positions) {
        for (BlockPos pos : positions) {
            reader.func_180501_a(pos.func_177972_a(Direction.DOWN), block.func_176223_P(), 2);
        }
    }

    public static boolean isQualifiedForLog(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> state.func_196958_f() || state.func_203425_a(BlockTags.field_206952_E));
    }

    public static boolean isQualifiedForLogWater(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> state.func_196958_f() || state.func_203425_a(BlockTags.field_206952_E) || state.func_177230_c() == Blocks.field_150355_j);
    }

    public static boolean isAir(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, BlockState::func_196958_f);
    }

    public static boolean isAirOrWater(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, state -> state.func_196958_f() || state.func_177230_c() == Blocks.field_150355_j);
    }

    public static boolean isDesiredGround(IWorldGenerationBaseReader worldIn, BlockPos pos, Block ... desiredGroundBlock) {
        return worldIn.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            int n = 0;
            Block[] blockArray = desiredGroundBlock;
            int n2 = blockArray.length;
            if (n < n2) {
                Block block1 = blockArray[n];
                return Feature.func_227250_b_((Block)block) || block == block1;
            }
            return false;
        });
    }

    public void func_202278_a(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        this.setBlockStateWithoutUpdates(worldIn, pos, state);
    }

    public boolean doesTreeFit(IWorldGenerationBaseReader reader, BlockPos blockPos, int height, int distance) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        BlockPos.Mutable position = new BlockPos.Mutable();
        for (int yOffset = 0; yOffset <= height + 1; ++yOffset) {
            for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                    if (BYGAbstractTreeFeature.canTreePlaceHere(reader, (BlockPos)position.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public final void setFinalBlockState(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, BlockState blockState, MutableBoundingBox boundingBox) {
        this.setBlockStateWithoutUpdates(worldIn, pos, blockState);
        boundingBox.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
        if (BlockTags.field_200031_h.func_199685_a_((Object)blockState.func_177230_c())) {
            changedBlocks.add(pos.func_185334_h());
        }
    }

    public void setBlockStateWithoutUpdates(IWorldWriter worldWriter, BlockPos blockPos, BlockState blockState) {
        if (doBlockNotify) {
            worldWriter.func_180501_a(blockPos, blockState, 19);
        } else {
            worldWriter.func_180501_a(blockPos, blockState, 18);
        }
    }

    public boolean func_212245_a(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, T config) {
        HashSet set = Sets.newHashSet();
        MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_78887_a();
        boolean flag = this.place(set, (IWorldGenerationReader)worldIn, rand, pos, mutableboundingbox);
        if (mutableboundingbox.field_78897_a > mutableboundingbox.field_78893_d) {
            return false;
        }
        ArrayList list = Lists.newArrayList();
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(mutableboundingbox.func_78883_b(), mutableboundingbox.func_78882_c(), mutableboundingbox.func_78880_d());
        try (BlockPos.PooledMutable blockpos$pooledmutableblockpos = BlockPos.PooledMutable.func_185346_s();){
            if (flag && !set.isEmpty()) {
                for (BlockPos blockpos : Lists.newArrayList((Iterable)set)) {
                    if (mutableboundingbox.func_175898_b((Vec3i)blockpos)) {
                        voxelshapepart.func_199625_a(blockpos.func_177958_n() - mutableboundingbox.field_78897_a, blockpos.func_177956_o() - mutableboundingbox.field_78895_b, blockpos.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                    for (Direction direction : Direction.values()) {
                        BlockState blockstate;
                        blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(direction);
                        if (set.contains(blockpos$pooledmutableblockpos) || !(blockstate = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos)).func_196959_b((IProperty)BlockStateProperties.field_208514_aa)) continue;
                        ((Set)list.get(0)).add(blockpos$pooledmutableblockpos.func_185334_h());
                        this.setBlockStateWithoutUpdates((IWorldWriter)worldIn, (BlockPos)blockpos$pooledmutableblockpos, (BlockState)blockstate.func_206870_a((IProperty)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                        if (!mutableboundingbox.func_175898_b((Vec3i)blockpos$pooledmutableblockpos)) continue;
                        voxelshapepart.func_199625_a(blockpos$pooledmutableblockpos.func_177958_n() - mutableboundingbox.field_78897_a, blockpos$pooledmutableblockpos.func_177956_o() - mutableboundingbox.field_78895_b, blockpos$pooledmutableblockpos.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                }
            }
            for (int l = 1; l < 6; ++l) {
                Set set1 = (Set)list.get(l - 1);
                Set set2 = (Set)list.get(l);
                for (BlockPos blockpos1 : set1) {
                    if (mutableboundingbox.func_175898_b((Vec3i)blockpos1)) {
                        voxelshapepart.func_199625_a(blockpos1.func_177958_n() - mutableboundingbox.field_78897_a, blockpos1.func_177956_o() - mutableboundingbox.field_78895_b, blockpos1.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                    for (Direction direction1 : Direction.values()) {
                        int k;
                        BlockState blockstate1;
                        blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos1).func_189536_c(direction1);
                        if (set1.contains(blockpos$pooledmutableblockpos) || set2.contains(blockpos$pooledmutableblockpos) || !(blockstate1 = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos)).func_196959_b((IProperty)BlockStateProperties.field_208514_aa) || (k = ((Integer)blockstate1.func_177229_b((IProperty)BlockStateProperties.field_208514_aa)).intValue()) <= l + 1) continue;
                        BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((IProperty)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(l + 1));
                        this.setBlockStateWithoutUpdates((IWorldWriter)worldIn, (BlockPos)blockpos$pooledmutableblockpos, blockstate2);
                        if (mutableboundingbox.func_175898_b((Vec3i)blockpos$pooledmutableblockpos)) {
                            voxelshapepart.func_199625_a(blockpos$pooledmutableblockpos.func_177958_n() - mutableboundingbox.field_78897_a, blockpos$pooledmutableblockpos.func_177956_o() - mutableboundingbox.field_78895_b, blockpos$pooledmutableblockpos.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                        }
                        set2.add(blockpos$pooledmutableblockpos.func_185334_h());
                    }
                }
            }
        }
        Template.func_222857_a((IWorld)worldIn, (int)3, (VoxelShapePart)voxelshapepart, (int)mutableboundingbox.field_78897_a, (int)mutableboundingbox.field_78895_b, (int)mutableboundingbox.field_78896_c);
        return flag;
    }

    protected abstract boolean place(Set<BlockPos> var1, IWorldGenerationReader var2, Random var3, BlockPos var4, MutableBoundingBox var5);
}

