/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.overworld.trees.util;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import voronoiaoc.byg.common.world.feature.features.overworld.trees.util.BYGAbstractTreeFeature;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public class EmptyTree
extends BYGAbstractTreeFeature<NoFeatureConfig> {
    public EmptyTree(Function<Dynamic<?>, ? extends NoFeatureConfig> configIn) {
        super(configIn);
    }

    @Override
    protected boolean place(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos pos, MutableBoundingBox boundsIn) {
        int randTreeHeight = 23 + rand.nextInt(5);
        BlockPos.Mutable mainmutable = new BlockPos.Mutable(pos);
        if (pos.func_177956_o() + randTreeHeight + 1 < worldIn.getMaxHeight()) {
            BlockPos blockpos = pos.func_177977_b();
            if (!EmptyTree.isDesiredGround((IWorldGenerationBaseReader)worldIn, blockpos, Blocks.field_196658_i)) {
                return false;
            }
            if (!this.doesTreeFit((IWorldGenerationBaseReader)worldIn, pos, randTreeHeight)) {
                return false;
            }
        }
        return true;
    }

    private void treeLog(Set<BlockPos> setlogblock, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (EmptyTree.canTreePlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, BYGBlockList.PINE_LOG.func_176223_P(), boundingBox);
        }
    }

    private void treeBranch(Set<BlockPos> setlogblock, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (EmptyTree.canTreePlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, BYGBlockList.PINE_LOG.func_176223_P(), boundingBox);
        }
    }

    private void leafs(Set<BlockPos> blockPos, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        BlockPos.Mutable blockpos = new BlockPos.Mutable(pos);
        if (EmptyTree.isAir((IWorldGenerationBaseReader)reader, (BlockPos)blockpos)) {
            this.setFinalBlockState(blockPos, (IWorldWriter)reader, (BlockPos)blockpos, BYGBlockList.PINE_LEAVES.func_176223_P(), boundingBox);
        }
    }

    private boolean doesTreeFit(IWorldGenerationBaseReader reader, BlockPos blockPos, int height) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int yOffset = 0; yOffset <= height + 1; ++yOffset) {
            int distance = 2;
            for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                    if (EmptyTree.canTreePlaceHere(reader, (BlockPos)pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

