/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.overworld.trees.willow;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import voronoiaoc.byg.common.world.feature.features.overworld.trees.util.BYGAbstractTreeFeature;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public class WillowTree1
extends BYGAbstractTreeFeature<NoFeatureConfig> {
    public WillowTree1(Function<Dynamic<?>, ? extends NoFeatureConfig> configIn) {
        super(configIn);
    }

    @Override
    protected boolean place(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos pos, MutableBoundingBox boundsIn) {
        int randChance = rand.nextInt(2);
        int randTreeHeight = rand.nextInt(6) + 8;
        BlockPos blockPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        BlockPos.Mutable block = new BlockPos.Mutable(blockPos);
        BlockPos.Mutable mainMutable = new BlockPos.Mutable((BlockPos)block);
        if (pos.func_177956_o() + randTreeHeight + 1 < worldIn.getMaxHeight()) {
            BlockPos.Mutable mutable;
            BlockPos blockpos = pos.func_177977_b();
            if (!WillowTree1.isDesiredGround((IWorldGenerationBaseReader)worldIn, blockpos, Blocks.field_196658_i)) {
                return false;
            }
            if (!this.doesTreeFit((IWorldGenerationBaseReader)worldIn, pos, randTreeHeight)) {
                return false;
            }
            for (int i = 3; i <= randTreeHeight; ++i) {
                mutable = new BlockPos.Mutable((BlockPos)block);
                this.setWillowLog(changedBlocks, worldIn, (BlockPos)mutable.func_189534_c(Direction.UP, i), boundsIn);
            }
            for (int baseSize = 0; baseSize < 4; ++baseSize) {
                mutable = new BlockPos.Mutable(block.func_177981_b(3));
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    mutable.func_189533_g((Vec3i)block.func_177981_b(3).func_177967_a(direction, baseSize));
                    if (((IWorld)worldIn).func_180495_p((BlockPos)mutable).func_177230_c() == Blocks.field_150346_d) continue;
                    this.setWillowLog(changedBlocks, worldIn, (BlockPos)mutable.func_189534_c(Direction.DOWN, baseSize), boundsIn);
                }
            }
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 1).func_189536_c(Direction.SOUTH).func_189536_c(Direction.EAST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.DOWN), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, 2).func_189536_c(Direction.EAST), boundsIn);
            mainMutable.func_189533_g((Vec3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 1).func_189536_c(Direction.WEST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.WEST).func_189536_c(Direction.UP).func_189536_c(Direction.NORTH), boundsIn);
            mainMutable.func_189533_g((Vec3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 2).func_189536_c(Direction.NORTH), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.UP).func_189536_c(Direction.NORTH), boundsIn);
            mainMutable.func_189533_g((Vec3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 2).func_189534_c(Direction.NORTH, 2).func_189536_c(Direction.WEST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.WEST).func_189536_c(Direction.NORTH), boundsIn);
            mainMutable.func_189533_g((Vec3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 2).func_189534_c(Direction.NORTH, 2).func_189536_c(Direction.EAST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.NORTH), boundsIn);
            mainMutable.func_189533_g((Vec3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 2).func_189536_c(Direction.NORTH).func_189534_c(Direction.EAST, 2), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.EAST), boundsIn);
            mainMutable.func_189533_g((Vec3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 2).func_189536_c(Direction.EAST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.SOUTH), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.SOUTH), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.EAST).func_189536_c(Direction.SOUTH), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.WEST, 2), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.UP).func_189536_c(Direction.EAST), boundsIn);
            mainMutable.func_189533_g((Vec3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 2).func_189536_c(Direction.WEST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.WEST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.WEST).func_189536_c(Direction.UP), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.EAST, 2).func_189536_c(Direction.NORTH).func_189536_c(Direction.DOWN), boundsIn);
            mainMutable.func_189533_g((Vec3i)block);
            this.setWillowLeaves(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight), boundsIn);
            for (int placeX = -3; placeX <= 3; ++placeX) {
                for (int placeZ = -3; placeZ <= 3; ++placeZ) {
                    if (placeX <= 2 && placeX >= -2 && placeZ <= 2 && placeZ >= -2) {
                        this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, 0, placeZ), boundsIn);
                        this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(3, 0, placeZ), boundsIn);
                        this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(-3, 0, placeZ), boundsIn);
                        this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, 0, 3), boundsIn);
                        this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, 0, -3), boundsIn);
                        for (int placeY = -1; placeY >= -(rand.nextInt(4) + 2); --placeY) {
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(4, placeY, placeZ), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(-4, placeY, placeZ), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, placeY, 4), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, placeY, -4), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(3, placeY, 3), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(-3, placeY, 3), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(3, placeY, -3), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(-3, placeY, -3), boundsIn);
                        }
                    }
                    if (placeX > 1 || placeX < -1 || placeZ > 1 || placeZ < -1) continue;
                    this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, 1, placeZ), boundsIn);
                    this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, 1, 2), boundsIn);
                    this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, 1, -2), boundsIn);
                    this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(2, 1, placeZ), boundsIn);
                    this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(-2, 1, placeZ), boundsIn);
                }
            }
        }
        return true;
    }

    private void setWillowLog(Set<BlockPos> setlogblock, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (WillowTree1.canTreePlaceHereWater((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, BYGBlockList.WILLOW_LOG.func_176223_P(), boundingBox);
        }
    }

    private void setWillowLeaves(Set<BlockPos> blockPos, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        BlockPos.Mutable blockpos = new BlockPos.Mutable(pos);
        if (WillowTree1.isAirOrWater((IWorldGenerationBaseReader)reader, (BlockPos)blockpos)) {
            this.setFinalBlockState(blockPos, (IWorldWriter)reader, (BlockPos)blockpos, BYGBlockList.WILLOW_LEAVES.func_176223_P(), boundingBox);
        }
    }

    private boolean doesTreeFit(IWorldGenerationBaseReader reader, BlockPos blockPos, int height) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int yOffset = 0; yOffset <= height + 1; ++yOffset) {
            int distance = 2;
            for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                    if (WillowTree1.canTreePlaceHereWater(reader, (BlockPos)pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

