/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.structure.fortress.skyrishighlands;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public class SkyrisFortressPieces {
    private static final PieceWeight[] PRIMARY_COMPONENTS = new PieceWeight[]{new PieceWeight(Straight.class, 30, 0, true), new PieceWeight(Crossing3.class, 10, 4), new PieceWeight(Crossing.class, 10, 4), new PieceWeight(Stairs.class, 10, 3), new PieceWeight(Throne.class, 5, 2), new PieceWeight(Entrance.class, 5, 1)};
    private static final PieceWeight[] SECONDARY_COMPONENTS = new PieceWeight[]{new PieceWeight(Corridor5.class, 25, 0, true), new PieceWeight(Crossing2.class, 15, 5), new PieceWeight(Corridor2.class, 5, 10), new PieceWeight(Corridor.class, 5, 10), new PieceWeight(Corridor3.class, 10, 3, true), new PieceWeight(Corridor4.class, 7, 2), new PieceWeight(NetherStalkRoom.class, 5, 2)};
    public static BlockState DACITEBRICKS = BYGBlockList.DACITE_BRICKS.func_176223_P();
    public static BlockState DACITEBRICKSTAIRS = BYGBlockList.DACITE_BRICK_STAIRS.func_176223_P();
    public static BlockState IRONBARS = Blocks.field_150411_aY.func_176223_P();

    private static Piece findAndCreateBridgePieceFactory(PieceWeight pieceWeight, List<StructurePiece> structurePieceList, Random rand, int p_175887_3_, int p_175887_4_, int p_175887_5_, Direction direction, int p_175887_7_) {
        Class<? extends Piece> oclass = pieceWeight.weightClass;
        Piece fortresspieces$piece = null;
        if (oclass == Straight.class) {
            fortresspieces$piece = Straight.createPiece(structurePieceList, rand, p_175887_3_, p_175887_4_, p_175887_5_, direction, p_175887_7_);
        } else if (oclass == Crossing3.class) {
            fortresspieces$piece = Crossing3.createPiece(structurePieceList, p_175887_3_, p_175887_4_, p_175887_5_, direction, p_175887_7_);
        } else if (oclass == Crossing.class) {
            fortresspieces$piece = Crossing.createPiece(structurePieceList, p_175887_3_, p_175887_4_, p_175887_5_, direction, p_175887_7_);
        } else if (oclass == Stairs.class) {
            fortresspieces$piece = Stairs.createPiece(structurePieceList, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_7_, direction);
        } else if (oclass == Throne.class) {
            fortresspieces$piece = Throne.createPiece(structurePieceList, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_7_, direction);
        } else if (oclass == Entrance.class) {
            fortresspieces$piece = Entrance.createPiece(structurePieceList, rand, p_175887_3_, p_175887_4_, p_175887_5_, direction, p_175887_7_);
        } else if (oclass == Corridor5.class) {
            fortresspieces$piece = Corridor5.createPiece(structurePieceList, p_175887_3_, p_175887_4_, p_175887_5_, direction, p_175887_7_);
        } else if (oclass == Corridor2.class) {
            fortresspieces$piece = Corridor2.createPiece(structurePieceList, rand, p_175887_3_, p_175887_4_, p_175887_5_, direction, p_175887_7_);
        } else if (oclass == Corridor.class) {
            fortresspieces$piece = Corridor.createPiece(structurePieceList, rand, p_175887_3_, p_175887_4_, p_175887_5_, direction, p_175887_7_);
        } else if (oclass == Corridor3.class) {
            fortresspieces$piece = Corridor3.createPiece(structurePieceList, p_175887_3_, p_175887_4_, p_175887_5_, direction, p_175887_7_);
        } else if (oclass == Corridor4.class) {
            fortresspieces$piece = Corridor4.func_214814_a(structurePieceList, p_175887_3_, p_175887_4_, p_175887_5_, direction, p_175887_7_);
        } else if (oclass == Crossing2.class) {
            fortresspieces$piece = Crossing2.createPiece(structurePieceList, p_175887_3_, p_175887_4_, p_175887_5_, direction, p_175887_7_);
        } else if (oclass == NetherStalkRoom.class) {
            fortresspieces$piece = NetherStalkRoom.createPiece(structurePieceList, p_175887_3_, p_175887_4_, p_175887_5_, direction, p_175887_7_);
        }
        return fortresspieces$piece;
    }

    public static class Throne
    extends Piece {
        private boolean hasSpawner;

        public Throne(int p_i50262_1_, MutableBoundingBox p_i50262_2_, Direction p_i50262_3_) {
            super(IStructurePieceType.field_214797_r, p_i50262_1_);
            this.func_186164_a(p_i50262_3_);
            this.field_74887_e = p_i50262_2_;
        }

        public Throne(TemplateManager p_i50263_1_, CompoundNBT p_i50263_2_) {
            super(IStructurePieceType.field_214797_r, p_i50263_2_);
            this.hasSpawner = p_i50263_2_.func_74767_n("Mob");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("Mob", this.hasSpawner);
        }

        public static Throne createPiece(List<StructurePiece> p_175874_0_, int p_175874_1_, int p_175874_2_, int p_175874_3_, int p_175874_4_, Direction p_175874_5_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175874_1_, (int)p_175874_2_, (int)p_175874_3_, (int)-2, (int)0, (int)0, (int)7, (int)8, (int)9, (Direction)p_175874_5_);
            return Throne.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(p_175874_0_, (MutableBoundingBox)mutableboundingbox) == null ? new Throne(p_175874_4_, mutableboundingbox, p_175874_5_) : null;
        }

        public boolean func_225577_a_(IWorld p_225577_1_, ChunkGenerator<?> p_225577_2_, Random p_225577_3_, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            BlockPos blockpos;
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 0, 6, 7, 7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 1, 0, 0, 5, 1, 7, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 1, 2, 1, 5, 2, 7, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 1, 3, 2, 5, 3, 7, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 1, 4, 3, 5, 4, 7, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 1, 2, 0, 1, 4, 2, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 5, 2, 0, 5, 4, 2, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 1, 5, 2, 1, 5, 3, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 5, 5, 2, 5, 5, 3, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 5, 3, 0, 5, 8, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 6, 5, 3, 6, 5, 8, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 1, 5, 8, 5, 5, 8, DACITEBRICKS, DACITEBRICKS, false);
            BlockState blockstate = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            BlockState blockstate1 = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            this.func_175811_a(p_225577_1_, (BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 1, 6, 3, p_225577_4_);
            this.func_175811_a(p_225577_1_, (BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), 5, 6, 3, p_225577_4_);
            this.func_175811_a(p_225577_1_, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 0, 6, 3, p_225577_4_);
            this.func_175811_a(p_225577_1_, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), 6, 6, 3, p_225577_4_);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 6, 4, 0, 6, 7, blockstate1, blockstate1, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 6, 6, 4, 6, 6, 7, blockstate1, blockstate1, false);
            this.func_175811_a(p_225577_1_, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), 0, 6, 8, p_225577_4_);
            this.func_175811_a(p_225577_1_, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), 6, 6, 8, p_225577_4_);
            this.func_175804_a(p_225577_1_, p_225577_4_, 1, 6, 8, 5, 6, 8, blockstate, blockstate, false);
            this.func_175811_a(p_225577_1_, (BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), 1, 7, 8, p_225577_4_);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 7, 8, 4, 7, 8, blockstate, blockstate, false);
            this.func_175811_a(p_225577_1_, (BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 5, 7, 8, p_225577_4_);
            this.func_175811_a(p_225577_1_, (BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), 2, 8, 8, p_225577_4_);
            this.func_175811_a(p_225577_1_, blockstate, 3, 8, 8, p_225577_4_);
            this.func_175811_a(p_225577_1_, (BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 4, 8, 8, p_225577_4_);
            if (!this.hasSpawner && p_225577_4_.func_175898_b((Vec3i)(blockpos = new BlockPos(this.func_74865_a(3, 5), this.func_74862_a(5), this.func_74873_b(3, 5))))) {
                this.hasSpawner = true;
                p_225577_1_.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tileentity = p_225577_1_.func_175625_s(blockpos);
                if (tileentity instanceof MobSpawnerTileEntity) {
                    ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(EntityType.field_200755_au);
                }
            }
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, i, -1, j, p_225577_4_);
                }
            }
            return true;
        }
    }

    public static class Straight
    extends Piece {
        public Straight(int p_i45620_1_, Random p_i45620_2_, MutableBoundingBox p_i45620_3_, Direction p_i45620_4_) {
            super(IStructurePieceType.field_214788_i, p_i45620_1_);
            this.func_186164_a(p_i45620_4_);
            this.field_74887_e = p_i45620_3_;
        }

        public Straight(TemplateManager p_i50283_1_, CompoundNBT p_i50283_2_) {
            super(IStructurePieceType.field_214788_i, p_i50283_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 1, 3, false);
        }

        public static Straight createPiece(List<StructurePiece> p_175882_0_, Random p_175882_1_, int p_175882_2_, int p_175882_3_, int p_175882_4_, Direction p_175882_5_, int p_175882_6_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175882_2_, (int)p_175882_3_, (int)p_175882_4_, (int)-1, (int)-3, (int)0, (int)5, (int)10, (int)19, (Direction)p_175882_5_);
            return Straight.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(p_175882_0_, (MutableBoundingBox)mutableboundingbox) == null ? new Straight(p_175882_6_, p_175882_1_, mutableboundingbox, p_175882_5_) : null;
        }

        public boolean func_225577_a_(IWorld p_225577_1_, ChunkGenerator<?> p_225577_2_, Random p_225577_3_, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 3, 0, 4, 4, 18, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 1, 5, 0, 3, 7, 18, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 5, 0, 0, 5, 18, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 5, 0, 4, 5, 18, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 0, 4, 2, 5, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 13, 4, 2, 18, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 0, 0, 4, 1, 3, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 0, 15, 4, 1, 18, DACITEBRICKS, DACITEBRICKS, false);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 2; ++j) {
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, i, -1, j, p_225577_4_);
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, i, -1, 18 - j, p_225577_4_);
                }
            }
            BlockState blockstate1 = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            BlockState blockstate = (BlockState)blockstate1.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true));
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 1, 1, 0, 4, 1, blockstate2, blockstate2, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 3, 4, 0, 4, 4, blockstate2, blockstate2, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 3, 14, 0, 4, 14, blockstate2, blockstate2, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 1, 17, 0, 4, 17, blockstate2, blockstate2, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 1, 1, 4, 4, 1, blockstate, blockstate, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 3, 4, 4, 4, 4, blockstate, blockstate, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 3, 14, 4, 4, 14, blockstate, blockstate, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 1, 17, 4, 4, 17, blockstate, blockstate, false);
            return true;
        }
    }

    public static class Start
    extends Crossing3 {
        public PieceWeight lastPlaced;
        public List<PieceWeight> primaryWeights;
        public List<PieceWeight> secondaryWeights;
        public final List<StructurePiece> pendingChildren = Lists.newArrayList();

        public Start(Random p_i2059_1_, int p_i2059_2_, int p_i2059_3_) {
            super(p_i2059_1_, p_i2059_2_, p_i2059_3_);
            this.primaryWeights = Lists.newArrayList();
            for (PieceWeight fortresspieces$pieceweight : PRIMARY_COMPONENTS) {
                fortresspieces$pieceweight.placeCount = 0;
                this.primaryWeights.add(fortresspieces$pieceweight);
            }
            this.secondaryWeights = Lists.newArrayList();
            for (PieceWeight fortresspieces$pieceweight1 : SECONDARY_COMPONENTS) {
                fortresspieces$pieceweight1.placeCount = 0;
                this.secondaryWeights.add(fortresspieces$pieceweight1);
            }
        }

        public Start(TemplateManager p_i50253_1_, CompoundNBT p_i50253_2_) {
            super(IStructurePieceType.field_214800_u, p_i50253_2_);
        }
    }

    public static class Stairs
    extends Piece {
        public Stairs(int p_i50255_1_, MutableBoundingBox p_i50255_2_, Direction p_i50255_3_) {
            super(IStructurePieceType.field_214799_t, p_i50255_1_);
            this.func_186164_a(p_i50255_3_);
            this.field_74887_e = p_i50255_2_;
        }

        public Stairs(TemplateManager p_i50256_1_, CompoundNBT p_i50256_2_) {
            super(IStructurePieceType.field_214799_t, p_i50256_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentZ((Start)componentIn, listIn, rand, 6, 2, false);
        }

        public static Stairs createPiece(List<StructurePiece> p_175872_0_, int p_175872_1_, int p_175872_2_, int p_175872_3_, int p_175872_4_, Direction p_175872_5_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175872_1_, (int)p_175872_2_, (int)p_175872_3_, (int)-2, (int)0, (int)0, (int)7, (int)11, (int)7, (Direction)p_175872_5_);
            return Stairs.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(p_175872_0_, (MutableBoundingBox)mutableboundingbox) == null ? new Stairs(p_175872_4_, mutableboundingbox, p_175872_5_) : null;
        }

        public boolean func_225577_a_(IWorld p_225577_1_, ChunkGenerator<?> p_225577_2_, Random p_225577_3_, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 0, 0, 6, 1, 6, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 0, 6, 10, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 0, 1, 8, 0, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 5, 2, 0, 6, 8, 0, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 1, 0, 8, 6, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 6, 2, 1, 6, 8, 6, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 1, 2, 6, 5, 8, 6, DACITEBRICKS, DACITEBRICKS, false);
            BlockState blockstate = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            BlockState blockstate1 = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 3, 2, 0, 5, 4, blockstate1, blockstate1, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 6, 3, 2, 6, 5, 2, blockstate1, blockstate1, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 6, 3, 4, 6, 5, 4, blockstate1, blockstate1, false);
            this.func_175811_a(p_225577_1_, DACITEBRICKS, 5, 2, 5, p_225577_4_);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 2, 5, 4, 3, 5, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 3, 2, 5, 3, 4, 5, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 2, 5, 2, 5, 5, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 1, 2, 5, 1, 6, 5, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 1, 7, 1, 5, 7, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 6, 8, 2, 6, 8, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 6, 0, 4, 8, 0, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 5, 0, 4, 5, 0, blockstate, blockstate, false);
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, i, -1, j, p_225577_4_);
                }
            }
            return true;
        }
    }

    static class PieceWeight {
        public final Class<? extends Piece> weightClass;
        public final int weight;
        public int placeCount;
        public final int maxPlaceCount;
        public final boolean allowInRow;

        public PieceWeight(Class<? extends Piece> p_i2055_1_, int p_i2055_2_, int p_i2055_3_, boolean p_i2055_4_) {
            this.weightClass = p_i2055_1_;
            this.weight = p_i2055_2_;
            this.maxPlaceCount = p_i2055_3_;
            this.allowInRow = p_i2055_4_;
        }

        public PieceWeight(Class<? extends Piece> p_i2056_1_, int p_i2056_2_, int p_i2056_3_) {
            this(p_i2056_1_, p_i2056_2_, p_i2056_3_, false);
        }

        public boolean doPlace(int p_78822_1_) {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }

        public boolean isValid() {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }
    }

    static abstract class Piece
    extends StructurePiece {
        protected Piece(IStructurePieceType p_i50260_1_, int p_i50260_2_) {
            super(p_i50260_1_, p_i50260_2_);
        }

        public Piece(IStructurePieceType p_i50261_1_, CompoundNBT p_i50261_2_) {
            super(p_i50261_1_, p_i50261_2_);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
        }

        private int getTotalWeight(List<PieceWeight> p_74960_1_) {
            boolean flag = false;
            int i = 0;
            for (PieceWeight fortresspieces$pieceweight : p_74960_1_) {
                if (fortresspieces$pieceweight.maxPlaceCount > 0 && fortresspieces$pieceweight.placeCount < fortresspieces$pieceweight.maxPlaceCount) {
                    flag = true;
                }
                i += fortresspieces$pieceweight.weight;
            }
            return flag ? i : -1;
        }

        private Piece generatePiece(Start p_175871_1_, List<PieceWeight> p_175871_2_, List<StructurePiece> p_175871_3_, Random p_175871_4_, int p_175871_5_, int p_175871_6_, int p_175871_7_, Direction p_175871_8_, int p_175871_9_) {
            int i = this.getTotalWeight(p_175871_2_);
            boolean flag = i > 0 && p_175871_9_ <= 30;
            int j = 0;
            block0: while (j < 5 && flag) {
                ++j;
                int k = p_175871_4_.nextInt(i);
                for (PieceWeight fortresspieces$pieceweight : p_175871_2_) {
                    if ((k -= fortresspieces$pieceweight.weight) >= 0) continue;
                    if (!fortresspieces$pieceweight.doPlace(p_175871_9_) || fortresspieces$pieceweight == p_175871_1_.lastPlaced && !fortresspieces$pieceweight.allowInRow) continue block0;
                    Piece fortresspieces$piece = SkyrisFortressPieces.findAndCreateBridgePieceFactory(fortresspieces$pieceweight, p_175871_3_, p_175871_4_, p_175871_5_, p_175871_6_, p_175871_7_, p_175871_8_, p_175871_9_);
                    if (fortresspieces$piece == null) continue;
                    ++fortresspieces$pieceweight.placeCount;
                    p_175871_1_.lastPlaced = fortresspieces$pieceweight;
                    if (!fortresspieces$pieceweight.isValid()) {
                        p_175871_2_.remove(fortresspieces$pieceweight);
                    }
                    return fortresspieces$piece;
                }
            }
            return End.createPiece(p_175871_3_, p_175871_4_, p_175871_5_, p_175871_6_, p_175871_7_, p_175871_8_, p_175871_9_);
        }

        private StructurePiece generateAndAddPiece(Start p_175870_1_, List<StructurePiece> p_175870_2_, Random p_175870_3_, int p_175870_4_, int p_175870_5_, int p_175870_6_, @Nullable Direction p_175870_7_, int p_175870_8_, boolean p_175870_9_) {
            if (Math.abs(p_175870_4_ - p_175870_1_.func_74874_b().field_78897_a) <= 112 && Math.abs(p_175870_6_ - p_175870_1_.func_74874_b().field_78896_c) <= 112) {
                Piece structurepiece;
                List<PieceWeight> list = p_175870_1_.primaryWeights;
                if (p_175870_9_) {
                    list = p_175870_1_.secondaryWeights;
                }
                if ((structurepiece = this.generatePiece(p_175870_1_, list, p_175870_2_, p_175870_3_, p_175870_4_, p_175870_5_, p_175870_6_, p_175870_7_, p_175870_8_ + 1)) != null) {
                    p_175870_2_.add(structurepiece);
                    p_175870_1_.pendingChildren.add(structurepiece);
                }
                return structurepiece;
            }
            return End.createPiece(p_175870_2_, p_175870_3_, p_175870_4_, p_175870_5_, p_175870_6_, p_175870_7_, p_175870_8_);
        }

        @Nullable
        protected StructurePiece getNextComponentNormal(Start p_74963_1_, List<StructurePiece> p_74963_2_, Random p_74963_3_, int p_74963_4_, int p_74963_5_, boolean p_74963_6_) {
            Direction direction = this.func_186165_e();
            if (direction != null) {
                switch (direction) {
                    case NORTH: {
                        return this.generateAndAddPiece(p_74963_1_, p_74963_2_, p_74963_3_, this.field_74887_e.field_78897_a + p_74963_4_, this.field_74887_e.field_78895_b + p_74963_5_, this.field_74887_e.field_78896_c - 1, direction, this.func_74877_c(), p_74963_6_);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(p_74963_1_, p_74963_2_, p_74963_3_, this.field_74887_e.field_78897_a + p_74963_4_, this.field_74887_e.field_78895_b + p_74963_5_, this.field_74887_e.field_78892_f + 1, direction, this.func_74877_c(), p_74963_6_);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(p_74963_1_, p_74963_2_, p_74963_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74963_5_, this.field_74887_e.field_78896_c + p_74963_4_, direction, this.func_74877_c(), p_74963_6_);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(p_74963_1_, p_74963_2_, p_74963_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74963_5_, this.field_74887_e.field_78896_c + p_74963_4_, direction, this.func_74877_c(), p_74963_6_);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece getNextComponentX(Start p_74961_1_, List<StructurePiece> p_74961_2_, Random p_74961_3_, int p_74961_4_, int p_74961_5_, boolean p_74961_6_) {
            Direction direction = this.func_186165_e();
            if (direction != null) {
                switch (direction) {
                    case NORTH: {
                        return this.generateAndAddPiece(p_74961_1_, p_74961_2_, p_74961_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74961_4_, this.field_74887_e.field_78896_c + p_74961_5_, Direction.WEST, this.func_74877_c(), p_74961_6_);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(p_74961_1_, p_74961_2_, p_74961_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74961_4_, this.field_74887_e.field_78896_c + p_74961_5_, Direction.WEST, this.func_74877_c(), p_74961_6_);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(p_74961_1_, p_74961_2_, p_74961_3_, this.field_74887_e.field_78897_a + p_74961_5_, this.field_74887_e.field_78895_b + p_74961_4_, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c(), p_74961_6_);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(p_74961_1_, p_74961_2_, p_74961_3_, this.field_74887_e.field_78897_a + p_74961_5_, this.field_74887_e.field_78895_b + p_74961_4_, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c(), p_74961_6_);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece getNextComponentZ(Start p_74965_1_, List<StructurePiece> p_74965_2_, Random p_74965_3_, int p_74965_4_, int p_74965_5_, boolean p_74965_6_) {
            Direction direction = this.func_186165_e();
            if (direction != null) {
                switch (direction) {
                    case NORTH: {
                        return this.generateAndAddPiece(p_74965_1_, p_74965_2_, p_74965_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74965_4_, this.field_74887_e.field_78896_c + p_74965_5_, Direction.EAST, this.func_74877_c(), p_74965_6_);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(p_74965_1_, p_74965_2_, p_74965_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74965_4_, this.field_74887_e.field_78896_c + p_74965_5_, Direction.EAST, this.func_74877_c(), p_74965_6_);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(p_74965_1_, p_74965_2_, p_74965_3_, this.field_74887_e.field_78897_a + p_74965_5_, this.field_74887_e.field_78895_b + p_74965_4_, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c(), p_74965_6_);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(p_74965_1_, p_74965_2_, p_74965_3_, this.field_74887_e.field_78897_a + p_74965_5_, this.field_74887_e.field_78895_b + p_74965_4_, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c(), p_74965_6_);
                    }
                }
            }
            return null;
        }

        protected static boolean isAboveGround(MutableBoundingBox p_74964_0_) {
            return p_74964_0_ != null && p_74964_0_.field_78895_b > 10;
        }
    }

    public static class NetherStalkRoom
    extends Piece {
        public NetherStalkRoom(int p_i50264_1_, MutableBoundingBox p_i50264_2_, Direction p_i50264_3_) {
            super(IStructurePieceType.field_214796_q, p_i50264_1_);
            this.func_186164_a(p_i50264_3_);
            this.field_74887_e = p_i50264_2_;
        }

        public NetherStalkRoom(TemplateManager p_i50265_1_, CompoundNBT p_i50265_2_) {
            super(IStructurePieceType.field_214796_q, p_i50265_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 5, 3, true);
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 5, 11, true);
        }

        public static NetherStalkRoom createPiece(List<StructurePiece> p_175875_0_, int p_175875_1_, int p_175875_2_, int p_175875_3_, Direction p_175875_4_, int p_175875_5_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175875_1_, (int)p_175875_2_, (int)p_175875_3_, (int)-5, (int)-3, (int)0, (int)13, (int)14, (int)13, (Direction)p_175875_4_);
            return NetherStalkRoom.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(p_175875_0_, (MutableBoundingBox)mutableboundingbox) == null ? new NetherStalkRoom(p_175875_5_, mutableboundingbox, p_175875_4_) : null;
        }

        public boolean func_225577_a_(IWorld p_225577_1_, ChunkGenerator<?> p_225577_2_, Random p_225577_3_, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 3, 0, 12, 4, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 5, 0, 12, 13, 12, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 5, 0, 1, 12, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 11, 5, 0, 12, 12, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 5, 11, 4, 12, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 8, 5, 11, 10, 12, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 5, 9, 11, 7, 12, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 5, 0, 4, 12, 1, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 8, 5, 0, 10, 12, 1, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 5, 9, 0, 7, 12, 1, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 11, 2, 10, 12, 10, DACITEBRICKS, DACITEBRICKS, false);
            BlockState blockstate = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            BlockState blockstate1 = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true));
            BlockState blockstate3 = (BlockState)blockstate1.func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            for (int i = 1; i <= 11; i += 2) {
                this.func_175804_a(p_225577_1_, p_225577_4_, i, 10, 0, i, 11, 0, blockstate, blockstate, false);
                this.func_175804_a(p_225577_1_, p_225577_4_, i, 10, 12, i, 11, 12, blockstate, blockstate, false);
                this.func_175804_a(p_225577_1_, p_225577_4_, 0, 10, i, 0, 11, i, blockstate1, blockstate1, false);
                this.func_175804_a(p_225577_1_, p_225577_4_, 12, 10, i, 12, 11, i, blockstate1, blockstate1, false);
                this.func_175811_a(p_225577_1_, DACITEBRICKS, i, 13, 0, p_225577_4_);
                this.func_175811_a(p_225577_1_, DACITEBRICKS, i, 13, 12, p_225577_4_);
                this.func_175811_a(p_225577_1_, DACITEBRICKS, 0, 13, i, p_225577_4_);
                this.func_175811_a(p_225577_1_, DACITEBRICKS, 12, 13, i, p_225577_4_);
                if (i == 11) continue;
                this.func_175811_a(p_225577_1_, blockstate, i + 1, 13, 0, p_225577_4_);
                this.func_175811_a(p_225577_1_, blockstate, i + 1, 13, 12, p_225577_4_);
                this.func_175811_a(p_225577_1_, blockstate1, 0, 13, i + 1, p_225577_4_);
                this.func_175811_a(p_225577_1_, blockstate1, 12, 13, i + 1, p_225577_4_);
            }
            this.func_175811_a(p_225577_1_, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), 0, 13, 0, p_225577_4_);
            this.func_175811_a(p_225577_1_, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), 0, 13, 12, p_225577_4_);
            this.func_175811_a(p_225577_1_, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 12, 13, 12, p_225577_4_);
            this.func_175811_a(p_225577_1_, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 12, 13, 0, p_225577_4_);
            for (int j1 = 3; j1 <= 9; j1 += 2) {
                this.func_175804_a(p_225577_1_, p_225577_4_, 1, 7, j1, 1, 8, j1, blockstate2, blockstate2, false);
                this.func_175804_a(p_225577_1_, p_225577_4_, 11, 7, j1, 11, 8, j1, blockstate3, blockstate3, false);
            }
            BlockState blockstate4 = (BlockState)DACITEBRICKSTAIRS.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH);
            for (int j = 0; j <= 6; ++j) {
                int k = j + 4;
                for (int l = 5; l <= 7; ++l) {
                    this.func_175811_a(p_225577_1_, blockstate4, l, 5 + j, k, p_225577_4_);
                }
                if (k >= 5 && k <= 8) {
                    this.func_175804_a(p_225577_1_, p_225577_4_, 5, 5, k, 7, j + 4, k, DACITEBRICKS, DACITEBRICKS, false);
                } else if (k >= 9 && k <= 10) {
                    this.func_175804_a(p_225577_1_, p_225577_4_, 5, 8, k, 7, j + 4, k, DACITEBRICKS, DACITEBRICKS, false);
                }
                if (j < 1) continue;
                this.func_175804_a(p_225577_1_, p_225577_4_, 5, 6 + j, k, 7, 9 + j, k, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            for (int k1 = 5; k1 <= 7; ++k1) {
                this.func_175811_a(p_225577_1_, blockstate4, k1, 12, 11, p_225577_4_);
            }
            this.func_175804_a(p_225577_1_, p_225577_4_, 5, 6, 7, 5, 7, 7, blockstate3, blockstate3, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 7, 6, 7, 7, 7, 7, blockstate2, blockstate2, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 5, 13, 12, 7, 13, 12, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 5, 2, 3, 5, 3, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 5, 9, 3, 5, 10, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 5, 4, 2, 5, 8, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 9, 5, 2, 10, 5, 3, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 9, 5, 9, 10, 5, 10, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 10, 5, 4, 10, 5, 8, DACITEBRICKS, DACITEBRICKS, false);
            BlockState blockstate5 = (BlockState)blockstate4.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            BlockState blockstate6 = (BlockState)blockstate4.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST);
            this.func_175811_a(p_225577_1_, blockstate6, 4, 5, 2, p_225577_4_);
            this.func_175811_a(p_225577_1_, blockstate6, 4, 5, 3, p_225577_4_);
            this.func_175811_a(p_225577_1_, blockstate6, 4, 5, 9, p_225577_4_);
            this.func_175811_a(p_225577_1_, blockstate6, 4, 5, 10, p_225577_4_);
            this.func_175811_a(p_225577_1_, blockstate5, 8, 5, 2, p_225577_4_);
            this.func_175811_a(p_225577_1_, blockstate5, 8, 5, 3, p_225577_4_);
            this.func_175811_a(p_225577_1_, blockstate5, 8, 5, 9, p_225577_4_);
            this.func_175811_a(p_225577_1_, blockstate5, 8, 5, 10, p_225577_4_);
            this.func_175804_a(p_225577_1_, p_225577_4_, 3, 4, 4, 4, 4, 8, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 8, 4, 4, 9, 4, 8, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 3, 5, 4, 4, 5, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 8, 5, 4, 9, 5, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 2, 0, 8, 2, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 4, 12, 2, 8, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 0, 0, 8, 1, 3, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 0, 9, 8, 1, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 0, 4, 3, 1, 8, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 9, 0, 4, 12, 1, 8, DACITEBRICKS, DACITEBRICKS, false);
            for (int l1 = 4; l1 <= 8; ++l1) {
                for (int i1 = 0; i1 <= 2; ++i1) {
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, l1, -1, i1, p_225577_4_);
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, l1, -1, 12 - i1, p_225577_4_);
                }
            }
            for (int i2 = 0; i2 <= 2; ++i2) {
                for (int j2 = 4; j2 <= 8; ++j2) {
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, i2, -1, j2, p_225577_4_);
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, 12 - i2, -1, j2, p_225577_4_);
                }
            }
            return true;
        }
    }

    public static class Entrance
    extends Piece {
        public Entrance(int p_i45617_1_, Random p_i45617_2_, MutableBoundingBox p_i45617_3_, Direction p_i45617_4_) {
            super(IStructurePieceType.field_214791_l, p_i45617_1_);
            this.func_186164_a(p_i45617_4_);
            this.field_74887_e = p_i45617_3_;
        }

        public Entrance(TemplateManager p_i50276_1_, CompoundNBT p_i50276_2_) {
            super(IStructurePieceType.field_214791_l, p_i50276_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 5, 3, true);
        }

        public static Entrance createPiece(List<StructurePiece> p_175881_0_, Random p_175881_1_, int p_175881_2_, int p_175881_3_, int p_175881_4_, Direction p_175881_5_, int p_175881_6_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175881_2_, (int)p_175881_3_, (int)p_175881_4_, (int)-5, (int)-3, (int)0, (int)13, (int)14, (int)13, (Direction)p_175881_5_);
            return Entrance.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(p_175881_0_, (MutableBoundingBox)mutableboundingbox) == null ? new Entrance(p_175881_6_, p_175881_1_, mutableboundingbox, p_175881_5_) : null;
        }

        public boolean func_225577_a_(IWorld p_225577_1_, ChunkGenerator<?> p_225577_2_, Random p_225577_3_, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 3, 0, 12, 4, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 5, 0, 12, 13, 12, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 5, 0, 1, 12, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 11, 5, 0, 12, 12, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 5, 11, 4, 12, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 8, 5, 11, 10, 12, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 5, 9, 11, 7, 12, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 5, 0, 4, 12, 1, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 8, 5, 0, 10, 12, 1, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 5, 9, 0, 7, 12, 1, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 11, 2, 10, 12, 10, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 5, 8, 0, 7, 8, 0, IRONBARS, IRONBARS, false);
            BlockState blockstate = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            BlockState blockstate1 = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            for (int i = 1; i <= 11; i += 2) {
                this.func_175804_a(p_225577_1_, p_225577_4_, i, 10, 0, i, 11, 0, blockstate, blockstate, false);
                this.func_175804_a(p_225577_1_, p_225577_4_, i, 10, 12, i, 11, 12, blockstate, blockstate, false);
                this.func_175804_a(p_225577_1_, p_225577_4_, 0, 10, i, 0, 11, i, blockstate1, blockstate1, false);
                this.func_175804_a(p_225577_1_, p_225577_4_, 12, 10, i, 12, 11, i, blockstate1, blockstate1, false);
                this.func_175811_a(p_225577_1_, DACITEBRICKS, i, 13, 0, p_225577_4_);
                this.func_175811_a(p_225577_1_, DACITEBRICKS, i, 13, 12, p_225577_4_);
                this.func_175811_a(p_225577_1_, DACITEBRICKS, 0, 13, i, p_225577_4_);
                this.func_175811_a(p_225577_1_, DACITEBRICKS, 12, 13, i, p_225577_4_);
                if (i == 11) continue;
                this.func_175811_a(p_225577_1_, blockstate, i + 1, 13, 0, p_225577_4_);
                this.func_175811_a(p_225577_1_, blockstate, i + 1, 13, 12, p_225577_4_);
                this.func_175811_a(p_225577_1_, blockstate1, 0, 13, i + 1, p_225577_4_);
                this.func_175811_a(p_225577_1_, blockstate1, 12, 13, i + 1, p_225577_4_);
            }
            this.func_175811_a(p_225577_1_, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), 0, 13, 0, p_225577_4_);
            this.func_175811_a(p_225577_1_, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), 0, 13, 12, p_225577_4_);
            this.func_175811_a(p_225577_1_, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 12, 13, 12, p_225577_4_);
            this.func_175811_a(p_225577_1_, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 12, 13, 0, p_225577_4_);
            for (int k = 3; k <= 9; k += 2) {
                this.func_175804_a(p_225577_1_, p_225577_4_, 1, 7, k, 1, 8, k, (BlockState)blockstate1.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), (BlockState)blockstate1.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), false);
                this.func_175804_a(p_225577_1_, p_225577_4_, 11, 7, k, 11, 8, k, (BlockState)blockstate1.func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), (BlockState)blockstate1.func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), false);
            }
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 2, 0, 8, 2, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 4, 12, 2, 8, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 0, 0, 8, 1, 3, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 0, 9, 8, 1, 12, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 0, 4, 3, 1, 8, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 9, 0, 4, 12, 1, 8, DACITEBRICKS, DACITEBRICKS, false);
            for (int l = 4; l <= 8; ++l) {
                for (int j = 0; j <= 2; ++j) {
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, l, -1, j, p_225577_4_);
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, l, -1, 12 - j, p_225577_4_);
                }
            }
            for (int i1 = 0; i1 <= 2; ++i1) {
                for (int j1 = 4; j1 <= 8; ++j1) {
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, i1, -1, j1, p_225577_4_);
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, 12 - i1, -1, j1, p_225577_4_);
                }
            }
            this.func_175804_a(p_225577_1_, p_225577_4_, 5, 5, 5, 7, 5, 7, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 6, 1, 6, 6, 4, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(p_225577_1_, DACITEBRICKS, 6, 0, 6, p_225577_4_);
            this.func_175811_a(p_225577_1_, Blocks.field_150353_l.func_176223_P(), 6, 5, 6, p_225577_4_);
            BlockPos blockpos = new BlockPos(this.func_74865_a(6, 6), this.func_74862_a(5), this.func_74873_b(6, 6));
            if (p_225577_4_.func_175898_b((Vec3i)blockpos)) {
                p_225577_1_.func_205219_F_().func_205360_a(blockpos, (Object)Fluids.field_204547_b, 0);
            }
            return true;
        }
    }

    public static class End
    extends Piece {
        private final int fillSeed;

        public End(int p_i45621_1_, Random p_i45621_2_, MutableBoundingBox p_i45621_3_, Direction p_i45621_4_) {
            super(IStructurePieceType.field_214787_h, p_i45621_1_);
            this.func_186164_a(p_i45621_4_);
            this.field_74887_e = p_i45621_3_;
            this.fillSeed = p_i45621_2_.nextInt();
        }

        public End(TemplateManager p_i50285_1_, CompoundNBT p_i50285_2_) {
            super(IStructurePieceType.field_214787_h, p_i50285_2_);
            this.fillSeed = p_i50285_2_.func_74762_e("Seed");
        }

        public static End createPiece(List<StructurePiece> p_175884_0_, Random p_175884_1_, int p_175884_2_, int p_175884_3_, int p_175884_4_, Direction p_175884_5_, int p_175884_6_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175884_2_, (int)p_175884_3_, (int)p_175884_4_, (int)-1, (int)-3, (int)0, (int)5, (int)10, (int)8, (Direction)p_175884_5_);
            return End.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(p_175884_0_, (MutableBoundingBox)mutableboundingbox) == null ? new End(p_175884_6_, p_175884_1_, mutableboundingbox, p_175884_5_) : null;
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("Seed", this.fillSeed);
        }

        public boolean func_225577_a_(IWorld p_225577_1_, ChunkGenerator<?> p_225577_2_, Random p_225577_3_, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            Random random = new Random(this.fillSeed);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 3; j <= 4; ++j) {
                    int k = random.nextInt(8);
                    this.func_175804_a(p_225577_1_, p_225577_4_, i, j, 0, i, j, k, DACITEBRICKS, DACITEBRICKS, false);
                }
            }
            int l = random.nextInt(8);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 5, 0, 0, 5, l, DACITEBRICKS, DACITEBRICKS, false);
            l = random.nextInt(8);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 5, 0, 4, 5, l, DACITEBRICKS, DACITEBRICKS, false);
            for (int i1 = 0; i1 <= 4; ++i1) {
                int k1 = random.nextInt(5);
                this.func_175804_a(p_225577_1_, p_225577_4_, i1, 2, 0, i1, 2, k1, DACITEBRICKS, DACITEBRICKS, false);
            }
            for (int j1 = 0; j1 <= 4; ++j1) {
                for (int l1 = 0; l1 <= 1; ++l1) {
                    int i2 = random.nextInt(3);
                    this.func_175804_a(p_225577_1_, p_225577_4_, j1, l1, 0, j1, l1, i2, DACITEBRICKS, DACITEBRICKS, false);
                }
            }
            return true;
        }
    }

    public static class Crossing3
    extends Piece {
        public Crossing3(int p_i50286_1_, MutableBoundingBox p_i50286_2_, Direction p_i50286_3_) {
            super(IStructurePieceType.field_214786_g, p_i50286_1_);
            this.func_186164_a(p_i50286_3_);
            this.field_74887_e = p_i50286_2_;
        }

        protected Crossing3(Random p_i2042_1_, int p_i2042_2_, int p_i2042_3_) {
            super(IStructurePieceType.field_214786_g, 0);
            this.func_186164_a(Direction.Plane.HORIZONTAL.func_179518_a(p_i2042_1_));
            this.field_74887_e = this.func_186165_e().func_176740_k() == Direction.Axis.Z ? new MutableBoundingBox(p_i2042_2_, 64, p_i2042_3_, p_i2042_2_ + 19 - 1, 73, p_i2042_3_ + 19 - 1) : new MutableBoundingBox(p_i2042_2_, 64, p_i2042_3_, p_i2042_2_ + 19 - 1, 73, p_i2042_3_ + 19 - 1);
        }

        protected Crossing3(IStructurePieceType p_i50287_1_, CompoundNBT p_i50287_2_) {
            super(p_i50287_1_, p_i50287_2_);
        }

        public Crossing3(TemplateManager p_i50288_1_, CompoundNBT p_i50288_2_) {
            this(IStructurePieceType.field_214786_g, p_i50288_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 8, 3, false);
            this.getNextComponentX((Start)componentIn, listIn, rand, 3, 8, false);
            this.getNextComponentZ((Start)componentIn, listIn, rand, 3, 8, false);
        }

        public static Crossing3 createPiece(List<StructurePiece> p_175885_0_, int p_175885_1_, int p_175885_2_, int p_175885_3_, Direction p_175885_4_, int p_175885_5_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175885_1_, (int)p_175885_2_, (int)p_175885_3_, (int)-8, (int)-3, (int)0, (int)19, (int)10, (int)19, (Direction)p_175885_4_);
            return Crossing3.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(p_175885_0_, (MutableBoundingBox)mutableboundingbox) == null ? new Crossing3(p_175885_5_, mutableboundingbox, p_175885_4_) : null;
        }

        public boolean func_225577_a_(IWorld p_225577_1_, ChunkGenerator<?> p_225577_2_, Random p_225577_3_, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            this.func_175804_a(p_225577_1_, p_225577_4_, 7, 3, 0, 11, 4, 18, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 3, 7, 18, 4, 11, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 8, 5, 0, 10, 7, 18, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 5, 8, 18, 7, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 7, 5, 0, 7, 5, 7, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 7, 5, 11, 7, 5, 18, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 11, 5, 0, 11, 5, 7, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 11, 5, 11, 11, 5, 18, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 5, 7, 7, 5, 7, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 11, 5, 7, 18, 5, 7, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 5, 11, 7, 5, 11, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 11, 5, 11, 18, 5, 11, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 7, 2, 0, 11, 2, 5, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 7, 2, 13, 11, 2, 18, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 7, 0, 0, 11, 1, 3, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 7, 0, 15, 11, 1, 18, DACITEBRICKS, DACITEBRICKS, false);
            for (int i = 7; i <= 11; ++i) {
                for (int j = 0; j <= 2; ++j) {
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, i, -1, j, p_225577_4_);
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, i, -1, 18 - j, p_225577_4_);
                }
            }
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 7, 5, 2, 11, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 13, 2, 7, 18, 2, 11, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 0, 7, 3, 1, 11, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 15, 0, 7, 18, 1, 11, DACITEBRICKS, DACITEBRICKS, false);
            for (int k = 0; k <= 2; ++k) {
                for (int l = 7; l <= 11; ++l) {
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, k, -1, l, p_225577_4_);
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, 18 - k, -1, l, p_225577_4_);
                }
            }
            return true;
        }
    }

    public static class Crossing2
    extends Piece {
        public Crossing2(int p_i50273_1_, MutableBoundingBox p_i50273_2_, Direction p_i50273_3_) {
            super(IStructurePieceType.field_214792_m, p_i50273_1_);
            this.func_186164_a(p_i50273_3_);
            this.field_74887_e = p_i50273_2_;
        }

        public Crossing2(TemplateManager p_i50274_1_, CompoundNBT p_i50274_2_) {
            super(IStructurePieceType.field_214792_m, p_i50274_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 1, 0, true);
            this.getNextComponentX((Start)componentIn, listIn, rand, 0, 1, true);
            this.getNextComponentZ((Start)componentIn, listIn, rand, 0, 1, true);
        }

        public static Crossing2 createPiece(List<StructurePiece> p_175878_0_, int p_175878_1_, int p_175878_2_, int p_175878_3_, Direction p_175878_4_, int p_175878_5_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175878_1_, (int)p_175878_2_, (int)p_175878_3_, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (Direction)p_175878_4_);
            return Crossing2.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(p_175878_0_, (MutableBoundingBox)mutableboundingbox) == null ? new Crossing2(p_175878_5_, mutableboundingbox, p_175878_4_) : null;
        }

        public boolean func_225577_a_(IWorld p_225577_1_, ChunkGenerator<?> p_225577_2_, Random p_225577_3_, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 0, 0, 4, 1, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 0, 4, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 0, 0, 5, 0, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 2, 0, 4, 5, 0, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 4, 0, 5, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 2, 4, 4, 5, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 6, 0, 4, 6, 4, DACITEBRICKS, DACITEBRICKS, false);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, i, -1, j, p_225577_4_);
                }
            }
            return true;
        }
    }

    public static class Crossing
    extends Piece {
        public Crossing(int p_i50258_1_, MutableBoundingBox p_i50258_2_, Direction p_i50258_3_) {
            super(IStructurePieceType.field_214798_s, p_i50258_1_);
            this.func_186164_a(p_i50258_3_);
            this.field_74887_e = p_i50258_2_;
        }

        public Crossing(TemplateManager p_i50259_1_, CompoundNBT p_i50259_2_) {
            super(IStructurePieceType.field_214798_s, p_i50259_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 2, 0, false);
            this.getNextComponentX((Start)componentIn, listIn, rand, 0, 2, false);
            this.getNextComponentZ((Start)componentIn, listIn, rand, 0, 2, false);
        }

        public static Crossing createPiece(List<StructurePiece> p_175873_0_, int p_175873_1_, int p_175873_2_, int p_175873_3_, Direction p_175873_4_, int p_175873_5_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175873_1_, (int)p_175873_2_, (int)p_175873_3_, (int)-2, (int)0, (int)0, (int)7, (int)9, (int)7, (Direction)p_175873_4_);
            return Crossing.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(p_175873_0_, (MutableBoundingBox)mutableboundingbox) == null ? new Crossing(p_175873_5_, mutableboundingbox, p_175873_4_) : null;
        }

        public boolean func_225577_a_(IWorld p_225577_1_, ChunkGenerator<?> p_225577_2_, Random p_225577_3_, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 0, 0, 6, 1, 6, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 0, 6, 7, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 0, 1, 6, 0, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 6, 1, 6, 6, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 5, 2, 0, 6, 6, 0, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 5, 2, 6, 6, 6, 6, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 0, 0, 6, 1, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 5, 0, 6, 6, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 6, 2, 0, 6, 6, 1, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 6, 2, 5, 6, 6, 6, DACITEBRICKS, DACITEBRICKS, false);
            BlockState blockstate = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            BlockState blockstate1 = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 6, 0, 4, 6, 0, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 5, 0, 4, 5, 0, blockstate, blockstate, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 6, 6, 4, 6, 6, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 2, 5, 6, 4, 5, 6, blockstate, blockstate, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 6, 2, 0, 6, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 5, 2, 0, 5, 4, blockstate1, blockstate1, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 6, 6, 2, 6, 6, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 6, 5, 2, 6, 5, 4, blockstate1, blockstate1, false);
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, i, -1, j, p_225577_4_);
                }
            }
            return true;
        }
    }

    public static class Corridor5
    extends Piece {
        public Corridor5(int p_i50268_1_, MutableBoundingBox p_i50268_2_, Direction p_i50268_3_) {
            super(IStructurePieceType.field_214794_o, p_i50268_1_);
            this.func_186164_a(p_i50268_3_);
            this.field_74887_e = p_i50268_2_;
        }

        public Corridor5(TemplateManager p_i50269_1_, CompoundNBT p_i50269_2_) {
            super(IStructurePieceType.field_214794_o, p_i50269_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 1, 0, true);
        }

        public static Corridor5 createPiece(List<StructurePiece> p_175877_0_, int p_175877_1_, int p_175877_2_, int p_175877_3_, Direction p_175877_4_, int p_175877_5_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175877_1_, (int)p_175877_2_, (int)p_175877_3_, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (Direction)p_175877_4_);
            return Corridor5.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(p_175877_0_, (MutableBoundingBox)mutableboundingbox) == null ? new Corridor5(p_175877_5_, mutableboundingbox, p_175877_4_) : null;
        }

        public boolean func_225577_a_(IWorld p_225577_1_, ChunkGenerator<?> p_225577_2_, Random p_225577_3_, MutableBoundingBox p_225577_4_, ChunkPos p_225577_5_) {
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 0, 0, 4, 1, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 0, 4, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            BlockState blockstate = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 2, 0, 0, 5, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 2, 0, 4, 5, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 3, 1, 0, 4, 1, blockstate, blockstate, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 3, 3, 0, 4, 3, blockstate, blockstate, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 3, 1, 4, 4, 1, blockstate, blockstate, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 4, 3, 3, 4, 4, 3, blockstate, blockstate, false);
            this.func_175804_a(p_225577_1_, p_225577_4_, 0, 6, 0, 4, 6, 4, DACITEBRICKS, DACITEBRICKS, false);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.func_175808_b(p_225577_1_, DACITEBRICKS, i, -1, j, p_225577_4_);
                }
            }
            return true;
        }
    }

    public static class Corridor4
    extends Piece {
        public Corridor4(int p_i50277_1_, MutableBoundingBox p_i50277_2_, Direction p_i50277_3_) {
            super(IStructurePieceType.field_214790_k, p_i50277_1_);
            this.func_186164_a(p_i50277_3_);
            this.field_74887_e = p_i50277_2_;
        }

        public Corridor4(TemplateManager p_i50278_1_, CompoundNBT p_i50278_2_) {
            super(IStructurePieceType.field_214790_k, p_i50278_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int i = 1;
            Direction direction = this.func_186165_e();
            if (direction == Direction.WEST || direction == Direction.NORTH) {
                i = 5;
            }
            this.getNextComponentX((Start)componentIn, listIn, rand, 0, i, rand.nextInt(8) > 0);
            this.getNextComponentZ((Start)componentIn, listIn, rand, 0, i, rand.nextInt(8) > 0);
        }

        public static Corridor4 func_214814_a(List<StructurePiece> structurePieceList, int p_214814_1_, int p_214814_2_, int p_214814_3_, Direction direction, int p_214814_5_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_214814_1_, (int)p_214814_2_, (int)p_214814_3_, (int)-3, (int)0, (int)0, (int)9, (int)7, (int)9, (Direction)direction);
            return Corridor4.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableboundingbox) == null ? new Corridor4(p_214814_5_, mutableboundingbox, direction) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGen, Random rand, MutableBoundingBox mutable, ChunkPos p_225577_5_) {
            BlockState blockstate = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            BlockState blockstate1 = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            this.func_175804_a(world, mutable, 0, 0, 0, 8, 1, 8, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 0, 2, 0, 8, 5, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, mutable, 0, 6, 0, 8, 6, 5, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 0, 2, 0, 2, 5, 0, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 6, 2, 0, 8, 5, 0, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 1, 3, 0, 1, 4, 0, blockstate1, blockstate1, false);
            this.func_175804_a(world, mutable, 7, 3, 0, 7, 4, 0, blockstate1, blockstate1, false);
            this.func_175804_a(world, mutable, 0, 2, 4, 8, 2, 8, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 1, 1, 4, 2, 2, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, mutable, 6, 1, 4, 7, 2, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, mutable, 1, 3, 8, 7, 3, 8, blockstate1, blockstate1, false);
            this.func_175811_a(world, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), 0, 3, 8, mutable);
            this.func_175811_a(world, (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), 8, 3, 8, mutable);
            this.func_175804_a(world, mutable, 0, 3, 6, 0, 3, 7, blockstate, blockstate, false);
            this.func_175804_a(world, mutable, 8, 3, 6, 8, 3, 7, blockstate, blockstate, false);
            this.func_175804_a(world, mutable, 0, 3, 4, 0, 5, 5, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 8, 3, 4, 8, 5, 5, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 1, 3, 5, 2, 5, 5, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 6, 3, 5, 7, 5, 5, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 1, 4, 5, 1, 5, 5, blockstate1, blockstate1, false);
            this.func_175804_a(world, mutable, 7, 4, 5, 7, 5, 5, blockstate1, blockstate1, false);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175808_b(world, DACITEBRICKS, j, -1, i, mutable);
                }
            }
            return true;
        }
    }

    public static class Corridor3
    extends Piece {
        public Corridor3(int p_i50280_1_, MutableBoundingBox p_i50280_2_, Direction p_i50280_3_) {
            super(IStructurePieceType.field_214789_j, p_i50280_1_);
            this.func_186164_a(p_i50280_3_);
            this.field_74887_e = p_i50280_2_;
        }

        public Corridor3(TemplateManager p_i50281_1_, CompoundNBT p_i50281_2_) {
            super(IStructurePieceType.field_214789_j, p_i50281_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 1, 0, true);
        }

        public static Corridor3 createPiece(List<StructurePiece> p_175883_0_, int p_175883_1_, int p_175883_2_, int p_175883_3_, Direction p_175883_4_, int p_175883_5_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175883_1_, (int)p_175883_2_, (int)p_175883_3_, (int)-1, (int)-7, (int)0, (int)5, (int)14, (int)10, (Direction)p_175883_4_);
            return Corridor3.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(p_175883_0_, (MutableBoundingBox)mutableboundingbox) == null ? new Corridor3(p_175883_5_, mutableboundingbox, p_175883_4_) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGen, Random rand, MutableBoundingBox mutable, ChunkPos chunkPos) {
            BlockState blockstate = (BlockState)DACITEBRICKSTAIRS.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH);
            BlockState blockstate1 = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            for (int i = 0; i <= 9; ++i) {
                int j = Math.max(1, 7 - i);
                int k = Math.min(Math.max(j + 5, 14 - i), 13);
                int l = i;
                this.func_175804_a(world, mutable, 0, 0, i, 4, j, i, DACITEBRICKS, DACITEBRICKS, false);
                this.func_175804_a(world, mutable, 1, j + 1, i, 3, k - 1, i, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                if (i <= 6) {
                    this.func_175811_a(world, blockstate, 1, j + 1, i, mutable);
                    this.func_175811_a(world, blockstate, 2, j + 1, i, mutable);
                    this.func_175811_a(world, blockstate, 3, j + 1, i, mutable);
                }
                this.func_175804_a(world, mutable, 0, k, i, 4, k, i, DACITEBRICKS, DACITEBRICKS, false);
                this.func_175804_a(world, mutable, 0, j + 1, i, 0, k - 1, i, DACITEBRICKS, DACITEBRICKS, false);
                this.func_175804_a(world, mutable, 4, j + 1, i, 4, k - 1, i, DACITEBRICKS, DACITEBRICKS, false);
                if ((i & 1) == 0) {
                    this.func_175804_a(world, mutable, 0, j + 2, i, 0, j + 3, i, blockstate1, blockstate1, false);
                    this.func_175804_a(world, mutable, 4, j + 2, i, 4, j + 3, i, blockstate1, blockstate1, false);
                }
                for (int i1 = 0; i1 <= 4; ++i1) {
                    this.func_175808_b(world, DACITEBRICKS, i1, -1, l, mutable);
                }
            }
            return true;
        }
    }

    public static class Corridor2
    extends Piece {
        private boolean chest;

        public Corridor2(int p_i45613_1_, Random p_i45613_2_, MutableBoundingBox p_i45613_3_, Direction p_i45613_4_) {
            super(IStructurePieceType.field_214795_p, p_i45613_1_);
            this.func_186164_a(p_i45613_4_);
            this.field_74887_e = p_i45613_3_;
            this.chest = p_i45613_2_.nextInt(3) == 0;
        }

        public Corridor2(TemplateManager p_i50266_1_, CompoundNBT p_i50266_2_) {
            super(IStructurePieceType.field_214795_p, p_i50266_2_);
            this.chest = p_i50266_2_.func_74767_n("Chest");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("Chest", this.chest);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentZ((Start)componentIn, listIn, rand, 0, 1, true);
        }

        public static Corridor2 createPiece(List<StructurePiece> p_175876_0_, Random p_175876_1_, int p_175876_2_, int p_175876_3_, int p_175876_4_, Direction p_175876_5_, int p_175876_6_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175876_2_, (int)p_175876_3_, (int)p_175876_4_, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (Direction)p_175876_5_);
            return Corridor2.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(p_175876_0_, (MutableBoundingBox)mutableboundingbox) == null ? new Corridor2(p_175876_6_, p_175876_1_, mutableboundingbox, p_175876_5_) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random rand, MutableBoundingBox mutable, ChunkPos chunkPos) {
            this.func_175804_a(world, mutable, 0, 0, 0, 4, 1, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 0, 2, 0, 4, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            BlockState blockstate = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            BlockState blockstate1 = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            this.func_175804_a(world, mutable, 0, 2, 0, 0, 5, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 0, 3, 1, 0, 4, 1, blockstate1, blockstate1, false);
            this.func_175804_a(world, mutable, 0, 3, 3, 0, 4, 3, blockstate1, blockstate1, false);
            this.func_175804_a(world, mutable, 4, 2, 0, 4, 5, 0, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 1, 2, 4, 4, 5, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 1, 3, 4, 1, 4, 4, blockstate, blockstate, false);
            this.func_175804_a(world, mutable, 3, 3, 4, 3, 4, 4, blockstate, blockstate, false);
            if (this.chest && mutable.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(1, 3), this.func_74862_a(2), this.func_74873_b(1, 3)))) {
                this.chest = false;
                this.func_186167_a(world, mutable, rand, 1, 2, 3, LootTables.field_215813_K);
            }
            this.func_175804_a(world, mutable, 0, 6, 0, 4, 6, 4, DACITEBRICKS, DACITEBRICKS, false);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.func_175808_b(world, DACITEBRICKS, i, -1, j, mutable);
                }
            }
            return true;
        }
    }

    public static class Corridor
    extends Piece {
        private boolean chest;

        public Corridor(int p_i45615_1_, Random p_i45615_2_, MutableBoundingBox p_i45615_3_, Direction p_i45615_4_) {
            super(IStructurePieceType.field_214793_n, p_i45615_1_);
            this.func_186164_a(p_i45615_4_);
            this.field_74887_e = p_i45615_3_;
            this.chest = p_i45615_2_.nextInt(3) == 0;
        }

        public Corridor(TemplateManager templateManager, CompoundNBT nbt) {
            super(IStructurePieceType.field_214793_n, nbt);
            this.chest = nbt.func_74767_n("Chest");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("Chest", this.chest);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentX((Start)componentIn, listIn, rand, 0, 1, true);
        }

        public static Corridor createPiece(List<StructurePiece> structurePieceList, Random rand, int p_175879_2_, int p_175879_3_, int p_175879_4_, Direction direction, int p_175879_6_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175879_2_, (int)p_175879_3_, (int)p_175879_4_, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (Direction)direction);
            return Corridor.isAboveGround(mutableboundingbox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableboundingbox) == null ? new Corridor(p_175879_6_, rand, mutableboundingbox, direction) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random rand, MutableBoundingBox mutable, ChunkPos chunkPos) {
            this.func_175804_a(world, mutable, 0, 0, 0, 4, 1, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 0, 2, 0, 4, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            BlockState blockstate = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            BlockState blockstate1 = (BlockState)((BlockState)IRONBARS.func_206870_a((IProperty)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            this.func_175804_a(world, mutable, 4, 2, 0, 4, 5, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 4, 3, 1, 4, 4, 1, blockstate1, blockstate1, false);
            this.func_175804_a(world, mutable, 4, 3, 3, 4, 4, 3, blockstate1, blockstate1, false);
            this.func_175804_a(world, mutable, 0, 2, 0, 0, 5, 0, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 0, 2, 4, 3, 5, 4, DACITEBRICKS, DACITEBRICKS, false);
            this.func_175804_a(world, mutable, 1, 3, 4, 1, 4, 4, blockstate, blockstate, false);
            this.func_175804_a(world, mutable, 3, 3, 4, 3, 4, 4, blockstate, blockstate, false);
            if (this.chest && mutable.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(3, 3), this.func_74862_a(2), this.func_74873_b(3, 3)))) {
                this.chest = false;
                this.func_186167_a(world, mutable, rand, 3, 2, 3, LootTables.field_215813_K);
            }
            this.func_175804_a(world, mutable, 0, 6, 0, 4, 6, 4, DACITEBRICKS, DACITEBRICKS, false);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.func_175808_b(world, DACITEBRICKS, i, -1, j, mutable);
                }
            }
            return true;
        }
    }
}

