/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.surfacebuilders;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import voronoiaoc.byg.common.world.worldtype.noise.simplex.chunkgen.ChunkFastSimplexStyleNoise;
import voronoiaoc.byg.core.byglists.BYGBlockList;
import voronoiaoc.byg.core.byglists.BYGSBList;

public class CanyonSB
extends SurfaceBuilder<SurfaceBuilderConfig> {
    protected long seed;
    protected ChunkFastSimplexStyleNoise simplex;

    public CanyonSB(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> config) {
        super(config);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        int yPos;
        BlockPos.Mutable block = new BlockPos.Mutable();
        int xPos = x & 0xF;
        int zPos = z & 0xF;
        double rawSimplexNoiseSample = this.octavedSimplex(x, z, 1.0f, 0.001f, 2, 0.5f);
        double simplexNoiseSample = rawSimplexNoiseSample * 65.0;
        double ridgedNoiseSample = 1.0 - 2.0 * Math.abs(simplexNoiseSample);
        if (ridgedNoiseSample > -24.0) {
            int yPos2;
            if (ridgedNoiseSample > -10.0) {
                for (yPos = startHeight; yPos >= startHeight - 80; --yPos) {
                    block.func_181079_c(xPos, yPos, zPos);
                    if (yPos <= seaLevel) continue;
                    chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                }
                if (noise < 1.0) {
                    SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)SurfaceBuilder.field_215425_v);
                } else {
                    SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)BYGSBList.BYGSBConfigList.COARSE);
                }
            }
            int noiseAdded = 135;
            if (ridgedNoiseSample > -24.0 && ridgedNoiseSample < -20.0) {
                for (yPos2 = startHeight; yPos2 >= noiseAdded; --yPos2) {
                    block.func_181079_c(xPos, yPos2, zPos);
                    if (yPos2 <= seaLevel) continue;
                    chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                }
                if (noise < 1.0) {
                    SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)BYGSBList.BYGSBConfigList.REDSAND_CF);
                } else {
                    SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)CanyonSB.randomSurfaceConfig(random));
                }
            }
            if (ridgedNoiseSample > -20.0 && ridgedNoiseSample < -16.0) {
                for (yPos2 = startHeight; yPos2 >= noiseAdded - 9; --yPos2) {
                    block.func_181079_c(xPos, yPos2, zPos);
                    if (yPos2 <= seaLevel) continue;
                    chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                }
                if (noise < 1.0) {
                    SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)BYGSBList.BYGSBConfigList.REDSAND_CF);
                } else {
                    SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)CanyonSB.randomSurfaceConfig(random));
                }
            }
            if (ridgedNoiseSample > -16.0 && ridgedNoiseSample < -10.0) {
                for (yPos2 = startHeight; yPos2 >= noiseAdded - 18; --yPos2) {
                    block.func_181079_c(xPos, yPos2, zPos);
                    if (yPos2 <= seaLevel) continue;
                    chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                }
                if (noise < 1.0) {
                    SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)BYGSBList.BYGSBConfigList.REDSAND_CF);
                } else {
                    SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)CanyonSB.randomSurfaceConfig(random));
                }
            }
        }
        for (yPos = startHeight - 3; yPos >= seaLevel; --yPos) {
            block.func_181079_c(xPos, yPos, zPos);
            BlockState currentBlockToReplace = chunkIn.func_180495_p((BlockPos)block);
            if (currentBlockToReplace != field_215414_k) continue;
            chunkIn.func_177436_a((BlockPos)block, BYGBlockList.RED_ROCK.func_176223_P(), false);
        }
        if (noise < 1.0) {
            SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)BYGSBList.BYGSBConfigList.REDSAND_CF);
        } else {
            SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)CanyonSB.randomSurfaceConfig(random));
        }
    }

    public void func_205548_a(long seed) {
        if (this.seed != seed || this.simplex == null) {
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
            this.simplex = new ChunkFastSimplexStyleNoise((Random)sharedseedrandom);
        }
        this.seed = seed;
    }

    public double octavedSimplex(int x, int y, float amp, float scale, int octaves, float change) {
        double height = 0.0;
        for (int i = 0; i < octaves; ++i) {
            height += (double)amp * this.simplex.sample2D((float)x * scale, (float)y * scale);
            scale /= change;
            amp *= change;
        }
        return height;
    }

    public static SurfaceBuilderConfig randomSurfaceConfig(Random random) {
        int randomizer = random.nextInt(3);
        if (randomizer == 1) {
            return SurfaceBuilder.field_215425_v;
        }
        return BYGSBList.BYGSBConfigList.COARSE;
    }
}

