/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.surfacebuilders;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import voronoiaoc.byg.common.world.worldtype.noise.fastnoise.FastNoise;
import voronoiaoc.byg.common.world.worldtype.noise.simplex.chunkgen.ChunkFastSimplexStyleNoise;
import voronoiaoc.byg.core.byglists.BYGSBList;

public class ImprovedCanyonSB
extends SurfaceBuilder<SurfaceBuilderConfig> {
    protected long seed;
    protected ChunkFastSimplexStyleNoise simplex;

    public ImprovedCanyonSB(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> config) {
        super(config);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        BlockPos.Mutable block = new BlockPos.Mutable();
        int xPos = x & 0xF;
        int zPos = z & 0xF;
        FastNoise noiseGen = new FastNoise();
        noiseGen.SetSeed(1000);
        noiseGen.SetNoiseType(FastNoise.NoiseType.Cellular);
        noiseGen.SetFractalOctaves(4);
        noiseGen.SetFractalGain(0.3f);
        noiseGen.SetFrequency(0.02f);
        double simplex3D = this.octavedSimplex3D(x, z, seaLevel, 1.0f, 0.01f, 1, 0.7f);
        double simplexSample3D = simplex3D * 3.0;
        BlockPos.Mutable carverMutable = new BlockPos.Mutable(x, startHeight, z);
        int y = startHeight;
        while ((double)y <= (double)startHeight + simplexSample3D) {
            double canyonShapingNoise = noiseGen.GetNoise(x, z) * 10.0f;
            carverMutable.func_181079_c(xPos, y, zPos);
            if (canyonShapingNoise > 8.0) {
                chunkIn.func_177436_a((BlockPos)carverMutable, Blocks.field_150348_b.func_176223_P(), false);
            }
            ++y;
        }
        if (noise < 1.0) {
            SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)SurfaceBuilder.field_215425_v);
        } else {
            SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)BYGSBList.BYGSBConfigList.COARSE);
        }
    }

    public void func_205548_a(long seed) {
        if (this.seed != seed || this.simplex == null) {
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
            this.simplex = new ChunkFastSimplexStyleNoise((Random)sharedseedrandom);
        }
        this.seed = seed;
    }

    public double octavedSimplex3D(int x, int y, int z, float amp, float scale, int octaves, float change) {
        double height = 0.0;
        for (int i = 0; i < octaves; ++i) {
            height += (double)amp * this.simplex.noise3_PlaneFirst((float)x * scale, (float)y * scale, (float)z * scale);
            scale /= change;
            amp *= change;
        }
        return height;
    }

    public static SurfaceBuilderConfig randomSurfaceConfig(Random random) {
        int randomizer = random.nextInt(3);
        if (randomizer == 1) {
            return SurfaceBuilder.field_215425_v;
        }
        return BYGSBList.BYGSBConfigList.COARSE;
    }
}

