/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.worldtype;

import java.util.function.LongFunction;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import voronoiaoc.byg.common.world.worldtype.layers.AddContinentLayer;
import voronoiaoc.byg.common.world.worldtype.layers.BYGAddDeepOceanLayer;
import voronoiaoc.byg.common.world.worldtype.layers.BYGAddIslandLayer;
import voronoiaoc.byg.common.world.worldtype.layers.biomemix.LandDoubleLayerMergerBYG;
import voronoiaoc.byg.common.world.worldtype.layers.biomemix.MixContinentLayer;
import voronoiaoc.byg.common.world.worldtype.layers.biomemix.MixOceansLayer;
import voronoiaoc.byg.common.world.worldtype.layers.biomemix.OceanInitLayer;
import voronoiaoc.byg.common.world.worldtype.layers.biomemix.OceanicDoubleLayerMergerBYG;
import voronoiaoc.byg.common.world.worldtype.math.BiomeGroupManager;
import voronoiaoc.byg.config.BYGWorldConfig;

public class BYGBiomeLayers {
    public static int continentSize = 8;
    public static int continentChance = 20;
    public static int continentBiomeSize = 0;
    public static int oceanSize = 5;
    public static int oceanBiomeSize = continentBiomeSize;
    public static int climateRegionSize = 0;
    static int configBiomeSize = (Integer)BYGWorldConfig.biomeSize.get();

    public static Layer stackLayerTransformers(long seed) {
        LongFunction<IExtendedNoiseRandom> contextProvider = salt -> new LazyAreaLayerContext(1, seed, salt);
        BiomeGroupManager manager = new BiomeGroupManager(seed);
        IAreaFactory createOcean = new OceanInitLayer(manager).func_202823_a(contextProvider.apply(1L));
        createOcean = BYGBiomeLayers.repeatOceanSize(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, createOcean, oceanSize, contextProvider);
        IAreaFactory createContinent = new AddContinentLayer(manager).apply(contextProvider.apply(1L), createOcean);
        createContinent = BYGBiomeLayers.repeatContinentSize(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, createContinent, continentSize, contextProvider);
        IAreaFactory mixContinents = new MixContinentLayer(manager).func_202823_a(contextProvider.apply(1L));
        mixContinents = BYGBiomeLayers.repeatContinentBiomeSize(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, mixContinents, continentBiomeSize, contextProvider);
        IAreaFactory mixOceans = new MixOceansLayer(manager).func_202823_a(contextProvider.apply(1L));
        mixOceans = BYGBiomeLayers.repeatOceanBiomeSize(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, mixOceans, oceanBiomeSize, contextProvider);
        IAreaFactory mergeContinentMix = new LandDoubleLayerMergerBYG(manager).apply(contextProvider.apply(1L), createContinent, mixContinents);
        IAreaFactory mergeOceanMixToContinentMix = new OceanicDoubleLayerMergerBYG(manager).apply(contextProvider.apply(5L), mergeContinentMix, mixOceans);
        IAreaFactory river = BYGBiomeLayers.repeatOceanSize(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, mergeOceanMixToContinentMix, 0, contextProvider);
        mergeOceanMixToContinentMix = BYGAddDeepOceanLayer.INSTANCE.func_202713_a(contextProvider.apply(1005L), mergeOceanMixToContinentMix);
        mergeOceanMixToContinentMix = ZoomLayer.NORMAL.func_202713_a(contextProvider.apply(1067L), mergeOceanMixToContinentMix);
        mergeOceanMixToContinentMix = ZoomLayer.NORMAL.func_202713_a(contextProvider.apply(1001L), mergeOceanMixToContinentMix);
        mergeOceanMixToContinentMix = BYGAddIslandLayer.INSTANCE.apply(contextProvider.apply(1005L), mergeOceanMixToContinentMix);
        mergeOceanMixToContinentMix = ZoomLayer.FUZZY.func_202713_a(contextProvider.apply(1013562L), mergeOceanMixToContinentMix);
        mergeOceanMixToContinentMix = ZoomLayer.NORMAL.func_202713_a(contextProvider.apply(10029232L), mergeOceanMixToContinentMix);
        mergeOceanMixToContinentMix = ZoomLayer.NORMAL.func_202713_a(contextProvider.apply(1023302L), mergeOceanMixToContinentMix);
        mergeOceanMixToContinentMix = ZoomLayer.NORMAL.func_202713_a(contextProvider.apply(1022202L), mergeOceanMixToContinentMix);
        return new Layer(mergeOceanMixToContinentMix);
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeatContinentSize(long seed, IAreaTransformer1 parent, IAreaFactory<T> layer, int count, LongFunction<C> contextFactory) {
        IAreaFactory layer1 = layer;
        for (int i = 0; i < count; ++i) {
            layer1 = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), layer1);
        }
        return layer1;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeatOceanSize(long seed, IAreaTransformer1 parent, IAreaFactory<T> layer, int count, LongFunction<C> contextFactory) {
        IAreaFactory layer1 = layer;
        for (int i = 0; i < count; ++i) {
            layer1 = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), layer1);
        }
        return layer1;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeatContinentBiomeSize(long seed, IAreaTransformer1 parent, IAreaFactory<T> layer, int count, LongFunction<C> contextFactory) {
        IAreaFactory layer1 = layer;
        for (int i = 0; i < count; ++i) {
            layer1 = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), layer1);
        }
        return layer1;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeatOceanBiomeSize(long seed, IAreaTransformer1 parent, IAreaFactory<T> layer, int count, LongFunction<C> contextFactory) {
        IAreaFactory layer1 = layer;
        for (int i = 0; i < count; ++i) {
            layer1 = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), layer1);
        }
        return layer1;
    }
}

