/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.worldtype.chunk.simplex;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;
import voronoiaoc.byg.common.world.worldtype.chunk.simplex.Simplex2DNoiseChunkGenerator;

public class Simplex2DOverworldChunkGenerator
extends Simplex2DNoiseChunkGenerator<OverworldGenSettings> {
    private static final float[] field_222576_h = (float[])Util.func_200696_a((Object)new float[25], p_222575_0_ -> {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                p_222575_0_[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    });
    private final double[] constHeightThresholdModifiers = this.generateConstHeightThresholdModifiers();
    private final boolean isAmplified;
    private final PhantomSpawner phantomSpawner = new PhantomSpawner();
    private final PatrolSpawner patrolSpawner = new PatrolSpawner();
    private final CatSpawner catSpawner = new CatSpawner();
    private final VillageSiege field_225495_n = new VillageSiege();

    public Simplex2DOverworldChunkGenerator(IWorld world, BiomeProvider provider, OverworldGenSettings settings) {
        super(world, provider, 4, 256, settings, 5, 2, 684.412f, 967.9077518620605, 8.555149841308594, 6.049423449137879);
        this.randomSeed.func_202423_a(2620);
        this.isAmplified = world.func_72912_H().func_76067_t() == WorldType.field_151360_e;
    }

    public void func_202093_c(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        Biome biome = region.func_226691_t_(new ChunkPos(i, j).func_206849_h());
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202424_a(region.func_72905_C(), i << 4, j << 4);
        WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)i, (int)j, (Random)sharedseedrandom);
    }

    @Override
    protected double getHeightThreshold(double biomeParam1, double biomeParam2, int y) {
        double d0 = 8.5;
        double d1 = ((double)y / 8.0 - (8.5 + biomeParam1 * 8.5 / 8.0 * 4.0)) * 12.0 * 128.0 / 256.0 / biomeParam2;
        if (d1 < 0.0) {
            d1 *= 4.0;
        }
        return d1 + this.constHeightThresholdModifiers[y];
    }

    private double[] generateConstHeightThresholdModifiers() {
        double[] thresholds = new double[256];
        double g = 29.0;
        double gd = 3.0;
        double gg = -10.0;
        for (int y = 0; y < 256; ++y) {
            double yc = (double)y / 8.0;
            if (yc > g) {
                double t = (yc - g) / gd;
                t = t > 1.0 ? 1.0 : (t *= t);
                thresholds[y] = -(t * gg) / (1.0 - t);
                continue;
            }
            thresholds[y] = 0.0;
        }
        return thresholds;
    }

    @Override
    protected double[] getColumnBiomeParams(int xc, int zc) {
        double[] adouble = new double[2];
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        boolean i = true;
        int j = this.func_222530_f();
        float f3 = this.field_222542_c.func_225526_b_(xc, j, zc).func_185355_j();
        for (int k = -2; k <= 2; ++k) {
            for (int l = -2; l <= 2; ++l) {
                Biome biome = this.field_222542_c.func_225526_b_(xc + k, j, zc + l);
                float biomeDepth = biome.func_185355_j();
                float biomeScale = biome.func_185360_m();
                float f6 = field_222576_h[k + 2 + (l + 2) * 5] / (biomeDepth + 2.0f);
                if (biome.func_185355_j() > f3) {
                    f6 /= 2.0f;
                }
                f += biomeScale * f6;
                f1 += biomeDepth * f6;
                f2 += f6;
            }
        }
        f /= f2;
        f1 /= f2;
        f = f * 0.9f + 0.1f;
        f1 = (f1 * 4.0f - 1.0f) / 8.0f;
        adouble[0] = f1;
        adouble[1] = f;
        return adouble;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification creatureType, BlockPos pos) {
        if (Feature.field_202334_l.func_202383_b(this.field_222540_a, pos)) {
            if (creatureType == EntityClassification.MONSTER) {
                return Feature.field_202334_l.func_202279_e();
            }
            if (creatureType == EntityClassification.CREATURE) {
                return Feature.field_202334_l.func_214469_f();
            }
        } else if (creatureType == EntityClassification.MONSTER) {
            if (Feature.field_214536_b.func_175796_a(this.field_222540_a, pos)) {
                return Feature.field_214536_b.func_202279_e();
            }
            if (Feature.field_202336_n.func_175796_a(this.field_222540_a, pos)) {
                return Feature.field_202336_n.func_202279_e();
            }
        }
        return super.func_177458_a(creatureType, pos);
    }

    public void func_203222_a(ServerWorld worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        this.phantomSpawner.func_203232_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.patrolSpawner.func_222696_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.catSpawner.func_221124_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.field_225495_n.func_225477_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
    }

    public int func_205470_d() {
        return this.field_222540_a.func_181545_F() + 1;
    }

    public int func_222530_f() {
        return 63;
    }
}

