/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.worldtype.chunk.worley;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.SphereReplaceFeature;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraftforge.registries.ForgeRegistries;
import voronoiaoc.byg.common.world.worldtype.noise.WorleyNoise;
import voronoiaoc.byg.common.world.worldtype.noise.simplex.chunkgen.DisklessDepositor;
import voronoiaoc.byg.common.world.worldtype.noise.simplex.chunkgen.SplerpBaseSimplex;

public abstract class Worley3DNoiseChunkGenerator<T extends GenerationSettings>
extends ChunkGenerator<T> {
    private static final double BLEND_NOISE_MAIN_AMPLITUDE = 5.5810546875;
    private static final double OUTPUT_NOISE_MAIN_AMPLITUDE = 56.25;
    private static final float[] field_222561_h = (float[])Util.func_200696_a((Object)new float[13824], p_222557_0_ -> {
        for (int i = 0; i < 24; ++i) {
            for (int j = 0; j < 24; ++j) {
                for (int k = 0; k < 24; ++k) {
                    p_222557_0_[i * 24 * 24 + j * 24 + k] = (float)Worley3DNoiseChunkGenerator.func_222554_b(j - 12, k - 12, i - 12);
                }
            }
        }
    });
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected final SharedSeedRandom randomSeed;
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;
    private final int worldHeight;
    private final INoiseGenerator surfaceDepthNoise;
    private final double hScale;
    private final double vScale;
    private final double hScaleBlend;
    private final double vScaleBlend;
    DisklessDepositor disklessDepositor;
    private final int nOctavesOutput;
    private final int nOctavesBlend;
    private final WorleyNoise[] fssnOctaves1;
    private final WorleyNoise[] fssnOctaves2;
    private final WorleyNoise[] fssnOctavesBlend;
    private final double[] outputUncertaintyBounds;
    private double[] blendUncertaintyBounds;
    private final int horizontalBiomeGranularity;
    private final int horizontalBiomeSourceSections;
    private final int horizontalBiomeSourceArraySize;
    private final SplerpBaseSimplex biomeSplerpBaseSimplex;

    public Worley3DNoiseChunkGenerator(IWorld worldIn, BiomeProvider biomeProvider, int horizontalBiomeGranularityPowerOfTwo, int worldHeight, T settings, int nOctavesOutput, int nOctavesBlend, double hScale, double vScale, double hScaleBlend, double vScaleBlend) {
        super(worldIn, biomeProvider, settings);
        int i;
        this.defaultBlock = settings.func_205532_l();
        this.defaultFluid = settings.func_205533_m();
        this.worldHeight = worldHeight;
        this.randomSeed = new SharedSeedRandom(this.field_222541_b);
        this.nOctavesOutput = nOctavesOutput;
        this.nOctavesBlend = nOctavesBlend;
        this.hScale = hScale;
        this.vScale = vScale / 2.0;
        this.hScaleBlend = hScaleBlend;
        this.vScaleBlend = vScaleBlend / 2.0;
        this.fssnOctaves1 = new WorleyNoise[nOctavesOutput];
        this.fssnOctaves2 = new WorleyNoise[nOctavesOutput];
        this.fssnOctavesBlend = new WorleyNoise[nOctavesBlend];
        for (int i2 = 0; i2 < Math.max(nOctavesOutput, nOctavesBlend); ++i2) {
            if (i2 < nOctavesOutput) {
                this.fssnOctaves1[i2] = new WorleyNoise((Random)this.randomSeed);
                this.fssnOctaves2[i2] = new WorleyNoise((Random)this.randomSeed);
            }
            if (i2 >= nOctavesBlend) continue;
            this.fssnOctavesBlend[i2] = new WorleyNoise((Random)this.randomSeed);
        }
        this.horizontalBiomeGranularity = horizontalBiomeGranularityPowerOfTwo;
        this.horizontalBiomeSourceSections = 16 / this.horizontalBiomeGranularity;
        this.horizontalBiomeSourceArraySize = this.horizontalBiomeSourceSections + 3;
        this.biomeSplerpBaseSimplex = SplerpBaseSimplex.forStride(horizontalBiomeGranularityPowerOfTwo);
        this.outputUncertaintyBounds = new double[nOctavesOutput];
        double boundBase = 0.0;
        for (i = nOctavesOutput - 1; i >= 0; --i) {
            this.outputUncertaintyBounds[i] = 56.25 * (boundBase += 1.0 / (double)(1 << i));
        }
        if (nOctavesBlend != 0) {
            this.blendUncertaintyBounds = new double[nOctavesBlend - 1];
            boundBase = 0.0;
            for (i = nOctavesBlend - 1; i >= 1; --i) {
                this.blendUncertaintyBounds[i - 1] = 5.5810546875 * (boundBase += 1.0 / (double)(1 << i));
            }
        }
        this.surfaceDepthNoise = new PerlinNoiseGenerator(this.randomSeed, 3, 0);
        this.disklessDepositor = new DisklessDepositor(ForgeRegistries.BIOMES.getValues(), (Random)this.randomSeed);
    }

    private static double func_222556_a(int p_222556_0_, int p_222556_1_, int p_222556_2_) {
        int i = p_222556_0_ + 12;
        int j = p_222556_1_ + 12;
        int k = p_222556_2_ + 12;
        return i >= 0 && i < 24 ? (j >= 0 && j < 24 ? (k >= 0 && k < 24 ? (double)field_222561_h[k * 24 * 24 + i * 24 + j] : 0.0) : 0.0) : 0.0;
    }

    private static double func_222554_b(int p_222554_0_, int p_222554_1_, int p_222554_2_) {
        double d0 = p_222554_0_ * p_222554_0_ + p_222554_2_ * p_222554_2_;
        double d1 = (double)p_222554_1_ + 0.5;
        double d2 = d1 * d1;
        double d3 = Math.pow(Math.E, -(d2 / 16.0 + d0 / 16.0));
        double d4 = -d1 * MathHelper.func_181161_i((double)(d2 / 2.0 + d0 / 2.0)) / 2.0;
        return d4 * d3;
    }

    public void func_222537_b(IWorld worldIn, IChunk chunkIn) {
        int sealevel = this.func_222530_f();
        ObjectArrayList villagePieceList = new ObjectArrayList(10);
        ObjectArrayList jigsawJunctionList = new ObjectArrayList(32);
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int chunkX = chunkpos.field_77276_a;
        int chunkZ = chunkpos.field_77275_b;
        int worldChunkX = chunkX << 4;
        int worldChunkZ = chunkZ << 4;
        for (Structure structure : Feature.field_214488_aQ) {
            String s = structure.func_143025_a();
            LongIterator longiterator = chunkIn.func_201578_b(s).iterator();
            while (longiterator.hasNext()) {
                long j1 = longiterator.nextLong();
                ChunkPos chunkpos1 = new ChunkPos(j1);
                IChunk ichunk = worldIn.func_212866_a_(chunkpos1.field_77276_a, chunkpos1.field_77275_b);
                StructureStart structurestart = ichunk.func_201585_a(s);
                if (structurestart == null || !structurestart.func_75069_d()) continue;
                for (StructurePiece structurepiece : structurestart.func_186161_c()) {
                    if (!structurepiece.func_214810_a(chunkpos, 12) || !(structurepiece instanceof AbstractVillagePiece)) continue;
                    AbstractVillagePiece abstractvillagepiece = (AbstractVillagePiece)structurepiece;
                    JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = abstractvillagepiece.func_214826_b().func_214854_c();
                    if (jigsawpattern$placementbehaviour == JigsawPattern.PlacementBehaviour.RIGID) {
                        villagePieceList.add((Object)abstractvillagepiece);
                    }
                    for (JigsawJunction jigsawjunction : abstractvillagepiece.func_214829_e()) {
                        int k1 = jigsawjunction.func_214895_a();
                        int l1 = jigsawjunction.func_214893_c();
                        if (k1 <= worldChunkX - 12 || l1 <= worldChunkZ - 12 || k1 >= worldChunkX + 15 + 12 || l1 >= worldChunkZ + 15 + 12) continue;
                        jigsawJunctionList.add((Object)jigsawjunction);
                    }
                }
            }
        }
        int xcb = worldChunkX / this.horizontalBiomeGranularity;
        int zcb = worldChunkZ / this.horizontalBiomeGranularity;
        double[][] biomeBlendMap1 = new double[this.horizontalBiomeSourceArraySize][this.horizontalBiomeSourceArraySize];
        double[][] biomeBlendMap2 = new double[this.horizontalBiomeSourceArraySize][this.horizontalBiomeSourceArraySize];
        for (int z = 0; z < this.horizontalBiomeSourceArraySize; ++z) {
            for (int x = 0; x < this.horizontalBiomeSourceArraySize; ++x) {
                double[] biomeBlendValues = this.getColumnBiomeParams(xcb + x - 1, zcb + z - 1);
                biomeBlendMap1[z][x] = biomeBlendValues[0];
                biomeBlendMap2[z][x] = biomeBlendValues[1];
            }
        }
        double[][] biomeBlendValues1 = new double[16][16];
        double[][] biomeBlendValues2 = new double[16][16];
        for (int zc = 0; zc < this.horizontalBiomeSourceSections; ++zc) {
            for (int xc = 0; xc < this.horizontalBiomeSourceSections; ++xc) {
                double[] biSplerpValues1 = new double[16];
                double[] biSplerpValues2 = new double[16];
                for (int zo = 0; zo < 4; ++zo) {
                    for (int xo = 0; xo < 4; ++xo) {
                        biSplerpValues1[xo * 4 + zo] = biomeBlendMap1[zc + zo][xc + xo];
                        biSplerpValues2[xo * 4 + zo] = biomeBlendMap2[zc + zo][xc + xo];
                    }
                }
                SplerpBaseSimplex.BiSplerp biSplerp1 = new SplerpBaseSimplex.BiSplerp(this.biomeSplerpBaseSimplex, this.biomeSplerpBaseSimplex, biSplerpValues1);
                SplerpBaseSimplex.BiSplerp biSplerp2 = new SplerpBaseSimplex.BiSplerp(this.biomeSplerpBaseSimplex, this.biomeSplerpBaseSimplex, biSplerpValues2);
                for (int z = 0; z < this.horizontalBiomeGranularity; ++z) {
                    SplerpBaseSimplex.Splerp splerp1 = biSplerp1.at(z);
                    SplerpBaseSimplex.Splerp splerp2 = biSplerp2.at(z);
                    for (int x = 0; x < this.horizontalBiomeGranularity; ++x) {
                        biomeBlendValues1[zc * this.horizontalBiomeGranularity + z][xc * this.horizontalBiomeGranularity + x] = splerp1.at(x);
                        biomeBlendValues2[zc * this.horizontalBiomeGranularity + z][xc * this.horizontalBiomeGranularity + x] = splerp2.at(x);
                    }
                }
            }
        }
        ChunkPrimer chunkprimer = (ChunkPrimer)chunkIn;
        Heightmap oceanFloorHeightmap = chunkprimer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap worldSurfaceHeightmap = chunkprimer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable blockPosMutable = new BlockPos.Mutable();
        ObjectListIterator villagePieceIterator = villagePieceList.iterator();
        ObjectListIterator jigsawJunctionIterator = jigsawJunctionList.iterator();
        ChunkSection chunksection = chunkprimer.func_217332_a(this.worldHeight - 1 >> 4);
        chunksection.func_222635_a();
        for (int y = this.worldHeight - 1; y >= 0; --y) {
            int chunkSectionIndex = y >> 4;
            int chunkSectionY = y & 0xF;
            if (chunksection.func_222632_g() >> 4 != chunkSectionIndex) {
                chunksection.func_222637_b();
                chunksection = chunkprimer.func_217332_a(chunkSectionIndex);
                chunksection.func_222635_a();
            }
            for (int z = 0; z < 16; ++z) {
                int worldZ = worldChunkZ + z;
                for (int x = 0; x < 16; ++x) {
                    BlockState blockstate;
                    int worldX = worldChunkX + x;
                    double startingValue = -this.getHeightThreshold(biomeBlendValues1[z][x], biomeBlendValues2[z][x], y);
                    double noiseValue = this.computeGoodEnoughNoise(worldX, y, worldZ, startingValue);
                    if (noiseValue != startingValue) {
                        int vZBound;
                        int vYBound;
                        int vXBound;
                        noiseValue = MathHelper.func_151237_a((double)(noiseValue / 200.0), (double)-1.0, (double)1.0);
                        noiseValue = noiseValue / 2.0 - noiseValue * noiseValue * noiseValue / 24.0;
                        while (villagePieceIterator.hasNext()) {
                            AbstractVillagePiece abstractvillagepiece1 = (AbstractVillagePiece)villagePieceIterator.next();
                            MutableBoundingBox mutableboundingbox = abstractvillagepiece1.func_74874_b();
                            vXBound = Math.max(0, Math.max(mutableboundingbox.field_78897_a - worldX, worldX - mutableboundingbox.field_78893_d));
                            vYBound = y - (mutableboundingbox.field_78895_b + abstractvillagepiece1.func_214830_d());
                            vZBound = Math.max(0, Math.max(mutableboundingbox.field_78896_c - worldZ, worldZ - mutableboundingbox.field_78892_f));
                            noiseValue += Worley3DNoiseChunkGenerator.func_222556_a(vXBound, vYBound, vZBound) * 0.8;
                        }
                        villagePieceIterator.back(villagePieceList.size());
                        while (jigsawJunctionIterator.hasNext()) {
                            JigsawJunction jigsawjunction1 = (JigsawJunction)jigsawJunctionIterator.next();
                            vXBound = worldX - jigsawjunction1.func_214895_a();
                            vYBound = y - jigsawjunction1.func_214896_b();
                            vZBound = worldZ - jigsawjunction1.func_214893_c();
                            noiseValue += Worley3DNoiseChunkGenerator.func_222556_a(vXBound, vYBound, vZBound) * 0.4;
                        }
                        jigsawJunctionIterator.back(jigsawJunctionList.size());
                    }
                    if ((blockstate = noiseValue > 0.0 ? this.defaultBlock : (y < sealevel ? this.defaultFluid : AIR)) == AIR) continue;
                    if (blockstate.func_185906_d() != 0) {
                        blockPosMutable.func_181079_c(worldX, y, worldZ);
                        chunkprimer.func_201637_h((BlockPos)blockPosMutable);
                    }
                    chunksection.func_177484_a(x, chunkSectionY, z, blockstate, false);
                    oceanFloorHeightmap.func_202270_a(x, y, z, blockstate);
                    worldSurfaceHeightmap.func_202270_a(x, y, z, blockstate);
                }
            }
        }
        chunksection.func_222637_b();
    }

    public int func_222529_a(int worldX, int worldZ, Heightmap.Type p_222529_3_) {
        int sealevel = this.func_222530_f();
        int chunkBlockX = worldX & 0xF;
        int chunkBlockZ = worldZ & 0xF;
        int xc = worldX / this.horizontalBiomeGranularity;
        int zc = worldZ / this.horizontalBiomeGranularity;
        double[] biSplerpValues1 = new double[16];
        double[] biSplerpValues2 = new double[16];
        for (int zo = 0; zo < 4; ++zo) {
            for (int xo = 0; xo < 4; ++xo) {
                double[] biomeBlendValues = this.getColumnBiomeParams(xc + xo - 1, zc + zo - 1);
                biSplerpValues1[xo * 4 + zo] = biomeBlendValues[0];
                biSplerpValues2[xo * 4 + zo] = biomeBlendValues[1];
            }
        }
        SplerpBaseSimplex.BiSplerp biSplerp1 = new SplerpBaseSimplex.BiSplerp(this.biomeSplerpBaseSimplex, this.biomeSplerpBaseSimplex, biSplerpValues1);
        SplerpBaseSimplex.BiSplerp biSplerp2 = new SplerpBaseSimplex.BiSplerp(this.biomeSplerpBaseSimplex, this.biomeSplerpBaseSimplex, biSplerpValues2);
        int granularityMask = this.horizontalBiomeGranularity - 1;
        double biomeBlendValue1 = biSplerp1.at(chunkBlockZ & granularityMask).at(chunkBlockX & granularityMask);
        double biomeBlendValue2 = biSplerp2.at(chunkBlockZ & granularityMask).at(chunkBlockX & granularityMask);
        for (int y = this.worldHeight - 1; y >= 0; --y) {
            double threshold = this.getHeightThreshold(biomeBlendValue1, biomeBlendValue2, y);
            double noiseValue = this.computeGoodEnoughNoise(worldX, y, worldZ, -threshold);
            if (!(noiseValue > 0.0) && y >= sealevel) continue;
            BlockState blockstate = noiseValue > 0.0 ? this.defaultBlock : this.defaultFluid;
            if (!p_222529_3_.func_222684_d().test(blockstate)) continue;
            return y + 1;
        }
        return 0;
    }

    private double computeGoodEnoughNoise(int worldX, int worldY, int worldZ, double startingValue) {
        double amp;
        double freq;
        int octave;
        double actualValue = startingValue;
        if (actualValue > this.outputUncertaintyBounds[0] || actualValue < -this.outputUncertaintyBounds[0]) {
            return actualValue;
        }
        double blendingValue = 0.0;
        if (this.nOctavesBlend != 0) {
            octave = 0;
            freq = 0.001550196339812695;
            amp = 5.5810546875;
            while (++octave < this.nOctavesBlend && (blendingValue += this.fssnOctavesBlend[octave].sample3D((double)worldX * this.hScaleBlend * (freq *= 2.0), (double)worldY * this.vScaleBlend * freq, (double)worldZ * this.hScaleBlend * freq) * (amp /= 2.0)) > -this.blendUncertaintyBounds[octave - 1] && blendingValue < this.blendUncertaintyBounds[octave - 1]) {
            }
            blendingValue = blendingValue <= -0.5 ? 0.0 : (blendingValue >= 0.5 ? 1.0 : blendingValue + 0.5);
            blendingValue = blendingValue * blendingValue * (3.0 - blendingValue * 2.0);
        }
        octave = 0;
        freq = 6.0554544523933395E-6;
        amp = 56.25;
        do {
            if (blendingValue < 1.0) {
                actualValue += (1.0 - blendingValue) * this.fssnOctaves1[octave].sample3D((double)worldX * this.hScale * freq, (double)worldY * this.vScale * freq, (double)worldZ * this.vScale * freq) * amp;
            }
            if (blendingValue > 0.0) {
                actualValue += blendingValue * this.fssnOctaves2[octave].sample3D((double)worldX * this.hScale * freq, (double)worldY * this.vScale * freq, (double)worldZ * this.hScale * freq) * amp;
            }
            freq *= 2.0;
            amp /= 2.0;
        } while (++octave < this.nOctavesOutput && actualValue > -this.outputUncertaintyBounds[octave] && actualValue < this.outputUncertaintyBounds[octave]);
        return actualValue;
    }

    public void func_202092_b(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        int k = i * 16;
        int l = j * 16;
        BlockPos blockpos = new BlockPos(k, 0, l);
        Biome biome = this.func_225552_a_(region.func_225523_d_(), blockpos.func_177982_a(8, 8, 8));
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        long i1 = sharedseedrandom.func_202424_a(region.func_72905_C(), k, l);
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            try {
                int iFeatures = 0;
                for (ConfiguredFeature configuredfeature : biome.func_203607_a(stage)) {
                    sharedseedrandom.func_202426_b(i1, iFeatures, stage.ordinal());
                    if (stage != GenerationStage.Decoration.UNDERGROUND_ORES || !(((DecoratedFeatureConfig)configuredfeature.field_222738_b).field_214689_a.field_222737_a instanceof SphereReplaceFeature)) {
                        try {
                            configuredfeature.func_222734_a((IWorld)region, (ChunkGenerator)this, (Random)sharedseedrandom, blockpos);
                        }
                        catch (Exception e) {
                            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Feature placement");
                            crashreport.func_85058_a("Feature").func_71507_a("Id", (Object)Registry.field_218379_q.func_177774_c((Object)configuredfeature.field_222737_a)).func_189529_a("Description", () -> configuredfeature.field_222737_a.toString());
                            throw new ReportedException(crashreport);
                        }
                    }
                    ++iFeatures;
                }
            }
            catch (Exception e) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Biome decoration");
                crashreport.func_85058_a("Generation").func_71507_a("CenterX", (Object)i).func_71507_a("CenterZ", (Object)j).func_71507_a("Step", (Object)stage).func_71507_a("Seed", (Object)i1).func_71507_a("Biome", (Object)Registry.field_212624_m.func_177774_c((Object)biome));
                throw new ReportedException(crashreport);
            }
        }
    }

    public void func_225551_a_(WorldGenRegion region, IChunk chunk) {
        int sealevel = this.func_222530_f();
        ChunkPos chunkpos = chunk.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(i, j);
        ChunkPos chunkpos1 = chunk.func_76632_l();
        int k = chunkpos1.func_180334_c();
        int l = chunkpos1.func_180333_d();
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable();
        for (int i1 = 0; i1 < 16; ++i1) {
            for (int j1 = 0; j1 < 16; ++j1) {
                int k1 = k + i1;
                int l1 = l + j1;
                int i2 = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, i1, j1) + 1;
                double d1 = this.surfaceDepthNoise.func_215460_a((double)k1 * 0.0625, (double)l1 * 0.0625, 0.0625, (double)i1 * 0.0625) * 15.0;
                blockposMutable = blockposMutable.func_181079_c(k + i1, i2, l + j1);
                Biome biome = region.func_226691_t_((BlockPos)blockposMutable);
                biome.func_206854_a((Random)sharedseedrandom, chunk, k1, l1, i2, d1, this.func_201496_a_().func_205532_l(), this.func_201496_a_().func_205533_m(), this.func_222530_f(), this.field_222540_a.func_72905_C());
                i2 = chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, i1, j1);
                blockposMutable = blockposMutable.func_181079_c(k + i1, i2, l + j1);
                if (i2 >= sealevel - 1) continue;
                this.disklessDepositor.apply(chunk, biome, blockposMutable);
            }
        }
        this.makeBedrock(chunk, (Random)sharedseedrandom);
    }

    protected abstract double[] getColumnBiomeParams(int var1, int var2);

    protected abstract double getHeightThreshold(double var1, double var3, int var5);

    /*
     * Unable to fully structure code
     */
    protected void makeBedrock(IChunk chunkIn, Random rand) {
        blockpos$mutable = new BlockPos.Mutable();
        i = chunkIn.func_76632_l().func_180334_c();
        j = chunkIn.func_76632_l().func_180333_d();
        t = this.func_201496_a_();
        k = t.func_214968_u();
        l = t.func_214967_t();
        var9 = BlockPos.func_191531_b((int)i, (int)0, (int)j, (int)(i + 15), (int)0, (int)(j + 15)).iterator();
        block0: while (true) {
            if (!var9.hasNext()) {
                return;
            }
            blockpos = (BlockPos)var9.next();
            if (l > 0) {
                for (j1 = l; j1 >= l - 4; --j1) {
                    if (j1 < l - rand.nextInt(5)) continue;
                    chunkIn.func_177436_a((BlockPos)blockpos$mutable.func_181079_c(blockpos.func_177958_n(), j1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
            }
            if (k >= 256) continue;
            j1 = k + 4;
            while (true) {
                if (j1 >= k) ** break;
                continue block0;
                if (j1 <= k + rand.nextInt(5)) {
                    chunkIn.func_177436_a((BlockPos)blockpos$mutable.func_181079_c(blockpos.func_177958_n(), j1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
                --j1;
            }
            break;
        }
    }
}

