/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.worldtype.math;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import voronoiaoc.byg.common.world.worldtype.BYGWorldType;
import voronoiaoc.byg.common.world.worldtype.math.DummyBYGBiomeGroup;
import voronoiaoc.byg.config.biomeweight.ConfigWeightManager;
import voronoiaoc.byg.core.byglists.BYGBiomeList;

public class BYGBiomeGroup {
    public static final BYGBiomeGroup INLAND_TROPICAL_DESERT = new BYGBiomeGroup();
    public static final BYGBiomeGroup INLAND_TROPICAL_STEPPE = new BYGBiomeGroup();
    public static final BYGBiomeGroup INLAND_TROPICAL_RAINFOREST = new BYGBiomeGroup();
    public static final BYGBiomeGroup INLAND_TEMPERATE_DRY = new BYGBiomeGroup();
    public static final BYGBiomeGroup INLAND_TEMPERATE_HUMID = new BYGBiomeGroup();
    public static final DummyBYGBiomeGroup INLAND_TEMPERATE_ALL = new DummyBYGBiomeGroup(INLAND_TEMPERATE_DRY, INLAND_TEMPERATE_HUMID);
    public static final BYGBiomeGroup INLAND_COOL_DRY = new BYGBiomeGroup();
    public static final BYGBiomeGroup INLAND_COOL_HUMID = new BYGBiomeGroup();
    public static final DummyBYGBiomeGroup INLAND_COOL_ALL = new DummyBYGBiomeGroup(INLAND_COOL_DRY, INLAND_COOL_HUMID);
    public static final BYGBiomeGroup INLAND_COLD = new BYGBiomeGroup();
    public static final BYGBiomeGroup COASTAL_TROPICAL_DRY = new BYGBiomeGroup();
    public static final BYGBiomeGroup COASTAL_TROPICAL_HUMID = new BYGBiomeGroup();
    public static final BYGBiomeGroup COASTAL_TEMPERATE_DRY = new BYGBiomeGroup();
    public static final BYGBiomeGroup COASTAL_TEMPERATE_LUSH = new BYGBiomeGroup();
    public static final DummyBYGBiomeGroup COASTAL_TEMPERATE_ALL = new DummyBYGBiomeGroup(COASTAL_TEMPERATE_DRY, COASTAL_TEMPERATE_LUSH);
    public static final BYGBiomeGroup COASTAL_COOL = new BYGBiomeGroup();
    public static final BYGBiomeGroup COASTAL_COLD = new BYGBiomeGroup();
    public static final BYGBiomeGroup OCEAN_ISLANDS_TROPICAL = new BYGBiomeGroup();
    public static final BYGBiomeGroup OCEAN_ISLANDS_TEMPERATE = new BYGBiomeGroup();
    public static final BYGBiomeGroup OCEAN_ISLANDS_SNOWY = new BYGBiomeGroup();
    public static final BYGBiomeGroup HOT_OCEAN = new BYGBiomeGroup();
    public static final BYGBiomeGroup TEMPERATE_OCEAN = new BYGBiomeGroup();
    public static final BYGBiomeGroup COOL_OCEAN = new BYGBiomeGroup();
    public static final BYGBiomeGroup FROZEN_OCEAN = new BYGBiomeGroup();
    public static final BYGBiomeGroup DEEP_HOT_OCEAN = new BYGBiomeGroup();
    public static final BYGBiomeGroup DEEP_TEMPERATE_OCEAN = new BYGBiomeGroup();
    public static final BYGBiomeGroup DEEP_COOL_OCEAN = new BYGBiomeGroup();
    public static final BYGBiomeGroup DEEP_FROZEN_OCEAN = new BYGBiomeGroup();
    public static final BYGBiomeGroup TROPICAL_DESERT = new BYGBiomeGroup();
    public static final BYGBiomeGroup TROPICAL_STEPPE = new BYGBiomeGroup();
    public static final BYGBiomeGroup TROPICAL_RAINFOREST = new BYGBiomeGroup();
    public static final BYGBiomeGroup TEMPERATE_DRY = new BYGBiomeGroup();
    public static final BYGBiomeGroup TEMPERATE_HUMID = new BYGBiomeGroup();
    public static final BYGBiomeGroup COOL_DRY = new BYGBiomeGroup();
    public static final BYGBiomeGroup COOL_HUMID = new BYGBiomeGroup();
    public static final BYGBiomeGroup COLD = new BYGBiomeGroup();
    private final List<BiomeEntry> entries = new ArrayList<BiomeEntry>();
    private double weightTotal = 0.0;

    private static double nextDouble(INoiseRandom random) {
        return (double)random.func_202696_a(Integer.MAX_VALUE) / 2.147483647E9;
    }

    public static void initBYGBiomes() {
        TROPICAL_DESERT.addBiome(BYGBiomeList.DUNES, ConfigWeightManager.DUNES.getWeight());
        TROPICAL_DESERT.addBiome(BYGBiomeList.REDDESERT, ConfigWeightManager.REDDESERT.getWeight());
        TROPICAL_STEPPE.addBiome(BYGBiomeList.AMARANTHFIELDS, ConfigWeightManager.AMARANTHFIELDS.getWeight());
        TROPICAL_STEPPE.addBiome(BYGBiomeList.SHRUBLANDS, ConfigWeightManager.SHRUBLANDS.getWeight());
        TROPICAL_RAINFOREST.addBiome(BYGBiomeList.GUIANASHIELD, ConfigWeightManager.GUIANASHIELD.getWeight());
        TROPICAL_RAINFOREST.addBiome(BYGBiomeList.TROPICALRAINFOREST, ConfigWeightManager.TROPICALRAINFOREST.getWeight());
        TROPICAL_RAINFOREST.addBiome(BYGBiomeList.TROPICALFUNGALRAINFOREST, ConfigWeightManager.TROPICALFUNGALFOREST.getWeight());
        TROPICAL_RAINFOREST.addBiome(BYGBiomeList.JACARANDAFOREST, ConfigWeightManager.JACARANDAFOREST.getWeight());
        TEMPERATE_DRY.addBiome(BYGBiomeList.PRAIRIE, ConfigWeightManager.PRAIRIE.getWeight());
        TEMPERATE_DRY.addBiome(BYGBiomeList.DECIDUOUSFOREST, ConfigWeightManager.DECIDUOUSFOREST.getWeight());
        TEMPERATE_DRY.addBiome(BYGBiomeList.BAOBABSAVANNA, ConfigWeightManager.BAOBABSAVANNA.getWeight());
        TEMPERATE_HUMID.addBiome(BYGBiomeList.VIBRANTSWAMPLANDS, ConfigWeightManager.VIBRANTSWAMPLANDS.getWeight());
        TEMPERATE_HUMID.addBiome(BYGBiomeList.ALLIUMFIELDS, ConfigWeightManager.ALLIUMFIELDS.getWeight());
        TEMPERATE_HUMID.addBiome(BYGBiomeList.REDOAKFOREST, ConfigWeightManager.REDOAKFOREST.getWeight());
        TEMPERATE_HUMID.addBiome(BYGBiomeList.MEADOW, ConfigWeightManager.MEADOW.getWeight());
        COOL_DRY.addBiome(BYGBiomeList.BLUETAIGA, ConfigWeightManager.BLUETAIGA.getWeight());
        COOL_DRY.addBiome(BYGBiomeList.SEASONALTAIGA, ConfigWeightManager.SEASONALTAIGA.getWeight());
        COOL_DRY.addBiome(BYGBiomeList.SEASONALFOREST, ConfigWeightManager.SEASONALFOREST.getWeight());
        COOL_DRY.addBiome(BYGBiomeList.SEASONALDECIDUOUSFOREST, ConfigWeightManager.SEASONALDECIDUOUSFOREST.getWeight());
        COOL_DRY.addBiome(BYGBiomeList.SEASONALBIRCHFOREST, ConfigWeightManager.SEASONALBIRCHFOREST.getWeight());
        COOL_DRY.addBiome(BYGBiomeList.BLUEGIANTTAIGA, ConfigWeightManager.GIANTBLUETAIGA.getWeight());
        COOL_DRY.addBiome(BYGBiomeList.SEASONALGIANTTAIGA, ConfigWeightManager.SEASONALGIANTTAIGA.getWeight());
        COOL_HUMID.addBiome(BYGBiomeList.SKYRISHIGHLANDS, ConfigWeightManager.SKYRISHIGHLANDS.getWeight());
        COOL_HUMID.addBiome(BYGBiomeList.BOREALFOREST, ConfigWeightManager.BOREALFOREST.getWeight());
        COOL_HUMID.addBiome(BYGBiomeList.CONIFEROUSFOREST, ConfigWeightManager.CONIFEROUSFOREST.getWeight());
        COOL_HUMID.addBiome(BYGBiomeList.COLDSWAMPLANDS, ConfigWeightManager.COLDSWAMPLANDS.getWeight());
        COOL_HUMID.addBiome(BYGBiomeList.CRAGGARDENS, ConfigWeightManager.CRAGGARDENS.getWeight());
        COLD.addBiome(BYGBiomeList.ALPS, ConfigWeightManager.ALPS.getWeight());
        COLD.addBiome(BYGBiomeList.SNOWYCONIFEROUSFOREST, ConfigWeightManager.SNOWYCONIFEROUSFOREST.getWeight());
        COLD.addBiome(BYGBiomeList.SNOWYDECIDUOUSFOREST, ConfigWeightManager.SNOWYDECIDUOUSFOREST.getWeight());
        COLD.addBiome(BYGBiomeList.SHATTEREDGLACIER, ConfigWeightManager.SHATTEREDGLACIER.getWeight());
        COLD.addBiome(BYGBiomeList.SNOWYBLUETAIGA, ConfigWeightManager.SNOWYBLUETAIGA.getWeight());
        COLD.addBiome(BYGBiomeList.SNOWYBLUEGIANTTAIGA, ConfigWeightManager.SNOWYGIANTBLUETAIGA.getWeight());
        OCEAN_ISLANDS_TROPICAL.addBiome(BYGBiomeList.TROPICALISLAND, 5.0);
        OCEAN_ISLANDS_TROPICAL.addBiome(BYGBiomeList.DEADSEA, 1.0);
        OCEAN_ISLANDS_TEMPERATE.addBiome(BYGBiomeList.DECIDUOUSFOREST, ConfigWeightManager.DECIDUOUSFOREST.getWeight());
        OCEAN_ISLANDS_SNOWY.addBiome(BYGBiomeList.SNOWYCONIFEROUSFOREST, ConfigWeightManager.SNOWYCONIFEROUSFOREST.getWeight());
        HOT_OCEAN.addBiome(Biomes.field_203614_T, 10.0);
        TEMPERATE_OCEAN.addBiome(Biomes.field_203615_U, 10.0);
        COOL_OCEAN.addBiome(Biomes.field_203616_V, 10.0);
        FROZEN_OCEAN.addBiome(Biomes.field_76776_l, 10.0);
        DEEP_HOT_OCEAN.addBiome(Biomes.field_203617_W, 10.0);
        DEEP_TEMPERATE_OCEAN.addBiome(Biomes.field_203618_X, 10.0);
        DEEP_COOL_OCEAN.addBiome(Biomes.field_203619_Y, 10.0);
        DEEP_FROZEN_OCEAN.addBiome(Biomes.field_203620_Z, 10.0);
    }

    public static void initDefaultBiomes() {
        INLAND_TROPICAL_DESERT.addBiome(Biomes.field_76769_d, 5.0);
        INLAND_TROPICAL_RAINFOREST.addBiome(Biomes.field_76782_w, 5.0);
        INLAND_TROPICAL_RAINFOREST.addBiome(Biomes.field_222370_aw, 5.0);
        INLAND_TEMPERATE_DRY.addBiome(Biomes.field_76772_c, 3.0);
        INLAND_TROPICAL_DESERT.addBiome(Biomes.field_185437_ai, 5.0);
        INLAND_TEMPERATE_DRY.addBiome(Biomes.field_150588_X, 5.0);
        INLAND_TEMPERATE_HUMID.addBiome(Biomes.field_150585_R, 5.0);
        INLAND_TEMPERATE_HUMID.addBiome(Biomes.field_185444_T, 5.0);
        INLAND_COOL_DRY.addBiome(Biomes.field_76768_g, 5.0);
        INLAND_COLD.addBiome(Biomes.field_76774_n, 5.0);
        INLAND_COLD.addBiome(Biomes.field_185445_W, 5.0);
        INLAND_COLD.addBiome(Biomes.field_150584_S, 5.0);
        COASTAL_TEMPERATE_DRY.addBiome(Biomes.field_76772_c, 5.0);
        COASTAL_TEMPERATE_LUSH.addBiome(Biomes.field_76780_h, 5.0);
        COASTAL_TROPICAL_DRY.addBiome(Biomes.field_76769_d, 3.0);
        OCEAN_ISLANDS_TROPICAL.addBiome(Biomes.field_76789_p, 5.0);
        OCEAN_ISLANDS_TEMPERATE.addBiome(Biomes.field_185441_Q, 5.0);
    }

    public Biome pickBiome(INoiseRandom random) {
        int i = -1;
        for (double randVal = BYGBiomeGroup.nextDouble(random) * this.weightTotal; randVal >= 0.0; randVal -= this.entries.get((int)(++i)).weight) {
        }
        return this.entries.get((int)i).biome;
    }

    public void addBiome(Biome biome, double weight) {
        this.entries.add(new BiomeEntry(biome, weight * 0.1));
        this.weightTotal += weight * 0.1;
        BYGWorldType.BIOMES.add(biome);
    }

    private static class BiomeEntry {
        Biome biome;
        double weight;

        BiomeEntry(Biome biome, double weight) {
            this.biome = biome;
            this.weight = weight;
        }
    }
}

