/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.worldtype.math;

import java.util.Random;
import voronoiaoc.byg.common.world.worldtype.math.BYGBiomeGroup;
import voronoiaoc.byg.common.world.worldtype.noise.simplex.biome.OctaveOpenSimplexNoise;

public class BiomeGroupManager {
    static final int CLIMATE_SCALE_LAYER_ADJUSTMENT = 8;
    static final int LAND_SEA_SCALE_LAYER_ADJUSTMENT = 6;
    static int band_set_size = 6;
    private final OctaveOpenSimplexNoise temperatureRandom;
    private final OctaveOpenSimplexNoise humidity;
    private final OctaveOpenSimplexNoise landSea;
    private final double zSpread;
    private final double zShift;

    public BiomeGroupManager(long seed) {
        Random rand = new Random(seed);
        this.temperatureRandom = new OctaveOpenSimplexNoise(rand, 1, this.temperatureScale());
        this.humidity = new OctaveOpenSimplexNoise(rand, 2, 1.0);
        this.landSea = new OctaveOpenSimplexNoise(rand, 2, 6.0);
        this.zSpread = 5.0;
        this.zShift = 1000 - rand.nextInt(2000) >> 8;
    }

    private double temperatureScale() {
        double output = 0.0;
        return output == 0.0 ? 0.2 : output;
    }

    public BYGBiomeGroup getInlandBiomeGroup(int layerX, int layerZ) {
        TempSection tempCategory = this.getTempCategory(layerX, layerZ);
        double humidity = this.getHumidity(layerX, layerZ);
        switch (tempCategory) {
            case HOT: {
                if (humidity > 0.28) {
                    return BYGBiomeGroup.INLAND_TROPICAL_RAINFOREST;
                }
                if (humidity > -0.28) {
                    return BYGBiomeGroup.INLAND_TROPICAL_STEPPE;
                }
                return BYGBiomeGroup.INLAND_TROPICAL_DESERT;
            }
            case TEMPERATE: {
                return humidity > 0.0 ? BYGBiomeGroup.INLAND_TEMPERATE_HUMID : BYGBiomeGroup.INLAND_TEMPERATE_DRY;
            }
            case COOL: {
                return humidity > 0.0 ? BYGBiomeGroup.INLAND_COOL_HUMID : BYGBiomeGroup.INLAND_COOL_DRY;
            }
        }
        return BYGBiomeGroup.INLAND_COLD;
    }

    public BYGBiomeGroup getBiomeGroup(int layerX, int layerZ) {
        TempSection tempCategory = this.getTempCategory(layerX, layerZ);
        double humidity = this.getHumidity(layerX, layerZ);
        switch (tempCategory) {
            case HOT: {
                if (humidity > 0.28) {
                    return BYGBiomeGroup.TROPICAL_RAINFOREST;
                }
                if (humidity > -0.28) {
                    return BYGBiomeGroup.TROPICAL_STEPPE;
                }
                return BYGBiomeGroup.TROPICAL_DESERT;
            }
            case TEMPERATE: {
                return humidity > 0.0 ? BYGBiomeGroup.TEMPERATE_HUMID : BYGBiomeGroup.TEMPERATE_DRY;
            }
            case COOL: {
                return humidity > 0.0 ? BYGBiomeGroup.COOL_HUMID : BYGBiomeGroup.COOL_DRY;
            }
        }
        return BYGBiomeGroup.COLD;
    }

    public BYGBiomeGroup getCoastalBiomeGroup(int layerX, int layerZ) {
        TempSection tempCategory = this.getTempCategory(layerX, layerZ);
        double humidity = this.getHumidity(layerX, layerZ);
        switch (tempCategory) {
            case HOT: {
                return humidity > 0.0 ? BYGBiomeGroup.COASTAL_TROPICAL_HUMID : BYGBiomeGroup.COASTAL_TROPICAL_DRY;
            }
            case TEMPERATE: {
                return humidity > 0.0 ? BYGBiomeGroup.COASTAL_TEMPERATE_LUSH : BYGBiomeGroup.COASTAL_TEMPERATE_DRY;
            }
            case COOL: {
                return BYGBiomeGroup.COASTAL_COOL;
            }
        }
        return BYGBiomeGroup.COASTAL_COLD;
    }

    public BYGBiomeGroup getIslandBiomeGroup(int layerX, int layerZ) {
        switch (this.getTempCategory(layerX, layerZ)) {
            case HOT: {
                return BYGBiomeGroup.OCEAN_ISLANDS_TROPICAL;
            }
            case TEMPERATE: {
                return BYGBiomeGroup.OCEAN_ISLANDS_TEMPERATE;
            }
        }
        return BYGBiomeGroup.OCEAN_ISLANDS_SNOWY;
    }

    public BYGBiomeGroup getCoastalOceanBiome(int layerX, int layerZ) {
        switch (this.getTempCategory(layerX, layerZ)) {
            case HOT: {
                return BYGBiomeGroup.HOT_OCEAN;
            }
            case TEMPERATE: {
                return BYGBiomeGroup.TEMPERATE_OCEAN;
            }
            case COOL: {
                return BYGBiomeGroup.COOL_OCEAN;
            }
        }
        return BYGBiomeGroup.FROZEN_OCEAN;
    }

    public BYGBiomeGroup getDeepOceanBiome(int layerX, int layerZ) {
        switch (this.getTempCategory(layerX, layerZ)) {
            case HOT: {
                return BYGBiomeGroup.DEEP_HOT_OCEAN;
            }
            case TEMPERATE: {
                return BYGBiomeGroup.DEEP_TEMPERATE_OCEAN;
            }
            case COOL: {
                return BYGBiomeGroup.DEEP_COOL_OCEAN;
            }
        }
        return BYGBiomeGroup.DEEP_FROZEN_OCEAN;
    }

    double getTemperature(int layerX, int layerZ) {
        layerZ = (int)((double)layerZ + this.zShift);
        for (layerZ = (int)((double)layerZ + this.temperatureRandom.sample((double)layerX + 2.2) * 0.4); layerZ < -band_set_size + 3; layerZ += 2 * band_set_size) {
        }
        while (layerZ > band_set_size - 1) {
            layerZ -= 2 * band_set_size;
        }
        return this.temperatureRandom.sample(layerX) * 0.4 + 1.0 - Math.abs((double)layerZ / this.zSpread) * 2.0;
    }

    double getHumidity(int layerX, int layerZ) {
        return this.humidity.sample(layerX, layerZ);
    }

    public TempSection getTempCategory(int layerX, int layerZ) {
        double temp = this.getTemperature(layerX, layerZ);
        if (temp > 0.55) {
            return TempSection.HOT;
        }
        if (temp > -0.3) {
            return TempSection.TEMPERATE;
        }
        if (temp > -1.0) {
            return TempSection.COOL;
        }
        return TempSection.COLD;
    }

    public ContinentSection getSection(int layerX, int layerZ) {
        double sample = this.landSea.sample(layerX, layerZ);
        ContinentSection result = sample > 0.3 ? ContinentSection.INLAND_CONTINENT : (sample > -0.1 ? ContinentSection.COASTAL_CONTINENT : (sample > -0.35 ? ContinentSection.COASTAL_SEAS : ContinentSection.THE_OCEAN));
        if (layerX >> 2 == 0 && layerZ >> 2 == 0 && result == ContinentSection.COASTAL_SEAS) {
            result = ContinentSection.COASTAL_CONTINENT;
        }
        return result;
    }

    public static enum TempSection {
        HOT,
        TEMPERATE,
        COOL,
        COLD;

    }

    public static enum ContinentSection {
        INLAND_CONTINENT,
        COASTAL_CONTINENT,
        COASTAL_SEAS,
        THE_OCEAN;

    }
}

