/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.worldtype.math;

import java.util.Random;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.image.PixelWriter;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import voronoiaoc.byg.common.world.worldtype.math.BiomeGroupManager;

public class Simulator
extends Application {
    private static final int MODE = 2;
    static final int WIDTH = 1080;
    static final int HEIGHT = 570;
    static final int SCALE_LAYERS_FOR_APPROXIMATION = 8;
    static final int BLOCKS_PER_PIXEL = 35;

    public static void main(String[] args) {
        Simulator.launch((String[])new String[0]);
    }

    public void start(Stage stage) throws Exception {
        Pane pane = new Pane();
        Canvas canvas = new Canvas(1080.0, 570.0);
        pane.getChildren().add((Object)canvas);
        stage.setScene(new Scene((Parent)pane));
        stage.setWidth(1080.0);
        stage.setHeight(570.0);
        this.draw(canvas.getGraphicsContext2D().getPixelWriter(), 1080, 570);
        stage.show();
    }

    private void draw(PixelWriter pwr, int width, int height) {
        long seed = new Random().nextLong();
        BiomeGroupManager manager = new BiomeGroupManager(seed);
        for (int x = 0; x < 1080; ++x) {
            int genX = (int)Simulator.map(x, 0.0, 1080.0, -540.0, 540.0);
            genX = genX * 35 >> 8;
            block20: for (int z = 0; z < 570; ++z) {
                int genZ = 570 - z - 1;
                genZ = (int)Simulator.map(genZ, 0.0, 570.0, -285.0, 285.0);
                genZ = genZ * 35 >> 8;
                switch (2) {
                    case 0: {
                        double temperature = manager.getTemperature(genX, genZ);
                        temperature = Simulator.clampMap(temperature, 1.0, -1.0, 0.0, 230.0);
                        pwr.setColor(x, z, Color.hsb((double)temperature, (double)1.0, (double)1.0));
                        continue block20;
                    }
                    case 1: {
                        double humidity = manager.getHumidity(genX, genZ);
                        humidity = Simulator.clampMap(humidity, -1.0, 1.0, 0.0, 255.0);
                        pwr.setColor(x, z, Color.rgb((int)0, (int)0, (int)((int)humidity)));
                        continue block20;
                    }
                    case 2: {
                        double temp = manager.getTemperature(genX, genZ);
                        temp = Simulator.clampMap(temp, 1.0, -1.0, 0.0, 230.0);
                        double humid = manager.getHumidity(genX, genZ);
                        humid = Simulator.clampMap(humid, -1.0, 1.0, 0.0, 1.0);
                        pwr.setColor(x, z, Color.hsb((double)temp, (double)1.0, (double)humid));
                        continue block20;
                    }
                    case 3: {
                        BiomeGroupManager.TempSection tempCategory = manager.getTempCategory(genX, genZ);
                        switch (tempCategory) {
                            case HOT: {
                                pwr.setColor(x, z, Color.WHITE);
                                break;
                            }
                            case TEMPERATE: {
                                pwr.setColor(x, z, Color.LIGHTSEAGREEN);
                                break;
                            }
                            case COOL: {
                                pwr.setColor(x, z, Color.GREEN);
                                break;
                            }
                            case COLD: {
                                pwr.setColor(x, z, Color.YELLOW);
                            }
                        }
                        continue block20;
                    }
                    case 4: {
                        BiomeGroupManager.ContinentSection section = manager.getSection(genX, genZ);
                        Color colour = null;
                        switch (section) {
                            case COASTAL_CONTINENT: {
                                colour = Color.LIMEGREEN;
                                break;
                            }
                            case COASTAL_SEAS: {
                                colour = Color.CORNFLOWERBLUE;
                                break;
                            }
                            case INLAND_CONTINENT: {
                                colour = Color.GREEN;
                                break;
                            }
                            case THE_OCEAN: {
                                colour = Color.DARKBLUE;
                            }
                        }
                        pwr.setColor(x, z, colour);
                    }
                }
            }
        }
    }

    private static double clampMap(double value, double oldmin, double oldmax, double newmin, double newmax) {
        value -= oldmin;
        value /= oldmax - oldmin;
        return (value = newmin + value * (newmax - newmin)) < newmin ? newmin : (value > newmax ? newmax : value);
    }

    private static double map(double value, double oldmin, double oldmax, double newmin, double newmax) {
        value -= oldmin;
        value /= oldmax - oldmin;
        value = newmin + value * (newmax - newmin);
        return value;
    }
}

