/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.worldtype.noise.simplex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.SphereReplaceFeature;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import voronoiaoc.byg.common.world.worldtype.noise.WorleyNoise;

public class WorleyDisklessDepositor {
    private final IdentityHashMap<Biome, DisklessDepositConfigs> depositsForBiome = new IdentityHashMap();

    public WorleyDisklessDepositor(Collection<Biome> biomes, Random seededRandom) {
        HashMap<DisklessDepositNoiseKey, WorleyNoise> noiseInstanceMap = new HashMap<DisklessDepositNoiseKey, WorleyNoise>();
        for (Biome biome : biomes) {
            for (ConfiguredFeature baseConfiguredFeature : biome.func_203607_a(GenerationStage.Decoration.UNDERGROUND_ORES)) {
                IPlacementConfig placementConfig;
                IFeatureConfig actualConfig;
                DecoratedFeatureConfig decoratedFeatureConfig = (DecoratedFeatureConfig)baseConfiguredFeature.field_222738_b;
                ConfiguredFeature configuredFeature = decoratedFeatureConfig.field_214689_a;
                Feature actualFeature = configuredFeature.field_222737_a;
                if (!(actualFeature instanceof SphereReplaceFeature) || !((actualConfig = configuredFeature.field_222738_b) instanceof SphereReplaceConfig) || !((placementConfig = decoratedFeatureConfig.field_214690_b.field_215097_b) instanceof FrequencyConfig)) continue;
                SphereReplaceConfig sphereReplaceConfig = (SphereReplaceConfig)actualConfig;
                FrequencyConfig frequencyConfig = (FrequencyConfig)placementConfig;
                int frequencyCount = frequencyConfig.field_202476_a;
                int configuredRadius = sphereReplaceConfig.field_202432_b;
                int configuredDepth = sphereReplaceConfig.field_202433_c;
                BlockState blockType = sphereReplaceConfig.field_214693_a;
                DisklessDepositNoiseKey key = new DisklessDepositNoiseKey();
                key.blockType = blockType;
                key.frequencyCount = frequencyCount;
                WorleyNoise noiseInstance = (WorleyNoise)noiseInstanceMap.get(key);
                if (noiseInstance == null) {
                    noiseInstance = new WorleyNoise(seededRandom);
                    noiseInstanceMap.put(key, noiseInstance);
                }
                DisklessDepositConfig config = new DisklessDepositConfig();
                config.blockType = blockType;
                config.noiseInstance = noiseInstance;
                config.depth = configuredDepth;
                config.noiseFreq = Math.sqrt((double)frequencyCount / 768.0);
                config.noiseThreshold = 1.0 - 2.5 * (config.noiseFreq * (double)configuredRadius * (double)configuredRadius / 6.0);
                DisklessDepositConfigs configs = this.depositsForBiome.get(biome);
                if (configs == null) {
                    configs = new DisklessDepositConfigs();
                    configs.list = new ArrayList<DisklessDepositConfig>(3);
                    this.depositsForBiome.put(biome, configs);
                }
                if (config.depth > configs.maxDepth) {
                    configs.maxDepth = config.depth;
                }
                configs.list.add(config);
            }
        }
    }

    public void apply(IChunk chunk, Biome biome, BlockPos.Mutable blockPos) {
        DisklessDepositConfigs configs = this.depositsForBiome.get(biome);
        if (configs == null) {
            return;
        }
        double[] currentBestValues = new double[configs.maxDepth];
        BlockState[] newBlocks = new BlockState[configs.maxDepth];
        for (DisklessDepositConfig config : configs.list) {
            double noiseValue = config.noiseInstance.sample2D((double)blockPos.func_177958_n() * config.noiseFreq, (double)blockPos.func_177952_p() * config.noiseFreq);
            noiseValue -= config.noiseThreshold;
            noiseValue /= 1.0 - config.noiseThreshold;
            for (int i = 0; i < configs.maxDepth; ++i) {
                if (i >= config.depth || !(noiseValue > currentBestValues[i])) continue;
                currentBestValues[i] = noiseValue;
                newBlocks[i] = config.blockType;
            }
        }
        for (int i = 0; i < configs.maxDepth; ++i) {
            if (newBlocks[i] != null && Blocks.field_150346_d.func_176223_P().equals(chunk.func_180495_p((BlockPos)blockPos))) {
                chunk.func_177436_a((BlockPos)blockPos, newBlocks[i], false);
            }
            blockPos.func_196234_d(0, -1, 0);
        }
    }

    static class DisklessDepositNoiseKey {
        BlockState blockType;
        int frequencyCount;

        DisklessDepositNoiseKey() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisklessDepositNoiseKey that = (DisklessDepositNoiseKey)o;
            if (this.frequencyCount != that.frequencyCount) {
                return false;
            }
            return this.blockType.equals(that.blockType);
        }

        public int hashCode() {
            int result = this.blockType.func_177230_c().hashCode();
            result = 31 * result + this.frequencyCount;
            return result;
        }
    }

    static class DisklessDepositConfig {
        BlockState blockType;
        double noiseFreq;
        double noiseThreshold;
        int depth;
        WorleyNoise noiseInstance;

        DisklessDepositConfig() {
        }
    }

    static class DisklessDepositConfigs {
        List<DisklessDepositConfig> list;
        int maxDepth;

        DisklessDepositConfigs() {
        }
    }
}

