/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.worldtype.noise.simplex.chunkgen;

import java.util.HashMap;

public class SplerpBaseSimplex {
    public static final int SPLERP_COEFF_LOOKUP_STEP_SIZE = 4;
    static HashMap<Integer, SplerpBaseSimplex> instances = new HashMap();
    double[] allWeights;

    private SplerpBaseSimplex(int stride) {
        this.allWeights = new double[4 * stride];
        for (int i = 0; i < stride; ++i) {
            double t = (double)i * 1.0 / (double)stride;
            int baseIndex = i * 4;
            this.allWeights[baseIndex + 0] = -(t * (0.5 + t * t * (-3.0 + t * (4.0 + t * -1.5))));
            this.allWeights[baseIndex + 1] = 1.0 + t * t * t * (-8.0 + t * (11.5 - 4.5 * t));
            this.allWeights[baseIndex + 2] = t * (0.5 + t * t * (7.0 + t * (4.5 * t - 11.0)));
            this.allWeights[baseIndex + 3] = t * t * t * (-2.0 + t * (3.5 + t * -1.5));
        }
    }

    public static SplerpBaseSimplex forStride(int stride) {
        return instances.computeIfAbsent(stride, k -> new SplerpBaseSimplex(stride));
    }

    public double eval(double[] values, int valuesStartIndex, int index) {
        double value = 0.0;
        int baseIndex = index * 4;
        for (int i = 0; i < 4; ++i) {
            value += this.allWeights[baseIndex + i] * values[valuesStartIndex + i];
        }
        return value;
    }

    public static class TriSplerp {
        SplerpBaseSimplex pregenA;
        SplerpBaseSimplex pregenB;
        SplerpBaseSimplex pregenC;
        double[] values;

        public TriSplerp(SplerpBaseSimplex pregenA, SplerpBaseSimplex pregenB, SplerpBaseSimplex pregenC, double[] values) {
            this.pregenA = pregenA;
            this.pregenB = pregenB;
            this.pregenC = pregenC;
            this.values = values;
        }

        public BiSplerp at(int index) {
            double[] newValues = new double[16];
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = this.pregenA.eval(this.values, i * 4, index);
            }
            return new BiSplerp(this.pregenB, this.pregenC, newValues);
        }
    }

    public static class BiSplerp {
        public double[] values;
        SplerpBaseSimplex pregenA;
        SplerpBaseSimplex pregenB;

        public BiSplerp(SplerpBaseSimplex pregenA, SplerpBaseSimplex pregenB, double[] values) {
            this.pregenA = pregenA;
            this.pregenB = pregenB;
            this.values = values;
        }

        public Splerp at(int index) {
            double[] newValues = new double[4];
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = this.pregenA.eval(this.values, i * 4, index);
            }
            return new Splerp(this.pregenB, newValues);
        }
    }

    public static class Splerp {
        SplerpBaseSimplex pregen;
        double[] values;

        public Splerp(SplerpBaseSimplex pregen, double[] values) {
            this.pregen = pregen;
            this.values = values;
        }

        public double at(int index) {
            return this.pregen.eval(this.values, 0, index);
        }
    }
}

