/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.core.registries;

import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import voronoiaoc.byg.BYG;
import voronoiaoc.byg.common.world.dimension.end.biome.BYGEndBiomeProvider;
import voronoiaoc.byg.common.world.worldtype.math.BYGBiomeGroup;
import voronoiaoc.byg.config.BYGWorldConfig;
import voronoiaoc.byg.core.byglists.BYGBiomeList;

@Mod.EventBusSubscriber(modid="byg", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BYGBiomeRegistry {
    @SubscribeEvent
    public static void registerBYGBiomes(RegistryEvent.Register<Biome> event) {
        BYG.LOGGER.debug("BYG: Registering Biomes...");
        IForgeRegistry registry = event.getRegistry();
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ALLIUMFIELDS, "alliumfields", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.RARE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ALPS, "alps", true, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.AMARANTHFIELDS, "amaranthfields", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.RARE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ASPENFOREST, "aspenforest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.AUTUMNAL_VALLEY, "autumnal_valley", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BAOBABSAVANNA, "baobabsavanna", true, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BAYOU, "bayou", true, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BLUETAIGA, "bluetaiga", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BLUFFSTEEPS, "bluffsteeps", true, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BOREALFOREST, "borealforest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.COLDSWAMPLANDS, "coldswamplands", true, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.CRAGGARDENS, "crag_gardens", true, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WET, BiomeDictionary.Type.PLATEAU, BiomeDictionary.Type.RARE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.CHERRYBLOSSOMFOREST, "cherry_blossom_forest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.CONIFEROUSFOREST, "coniferousforest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.CYPRESSSWAMPLANDS, "cypress_swamplands", true, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.DOVERMOUNTAINS, "dovermountains", true, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.DEADSEA, "deadsea", true, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.DECIDUOUSFOREST, "deciduousforest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.DUNES, "dunes", true, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.EBONYWOODS, "ebony_woods", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ENCHANTEDFOREST, "enchanted_forest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.EVERGREENTAIGA, "evergreen_taiga", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.GLOWSHROOMBAYOU, "glowshroombayou", true, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.GRASSLANDPLATEAU, "grasslandplateau", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.GREATLAKES, "greatlakes", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WATER, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.GROVE, "grove", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ENCHANTED_GROVE, "enchanted_grove", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.GUIANASHIELD, "guianashield", true, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.JACARANDAFOREST, "jacarandaforest", true, BiomeDictionary.Type.FOREST);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.MANGROVEMARSHES, "mangrove_marshes", true, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.MAPLETAIGA, "maple_taiga", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.MEADOW, "meadow", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.MOJAVE_DESERT, "mojave_desert", true, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.LUSH_TUNDRA, "lush_tundra", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ORCHARD, "orchard", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.PRAIRIE, "prairie", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.REDDESERT, "reddesert", true, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.REDDESERTDUNES, "reddesertdunes", true, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.REDOAKFOREST, "redoakforest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.RED_ROCK_MOUNTAINS, "red_rock_mountains", true, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SEASONALBIRCHFOREST, "seasonalbirchforest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SEASONALDECIDUOUSFOREST, "seasonaldeciduousforest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SEASONALFOREST, "seasonalforest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SEASONALTAIGA, "seasonaltaiga", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SHATTEREDGLACIER, "shatteredglacier", true, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SHRUBLANDS, "shrublands", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SKYRISHIGHLANDS, "skyrishighlands", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWYBLUETAIGA, "snowybluetaiga", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWYCONIFEROUSFOREST, "snowyconiferousforest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWYDECIDUOUSFOREST, "snowydeciduousforest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWYEVERGREENTAIGA, "snowy_evergreen_taiga", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.THE_BLACK_FOREST, "the_black_forest", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.TROPICALFUNGALRAINFOREST, "tropicalfungalforest", true, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.TROPICALRAINFOREST, "tropicalrainforest", true, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.VIBRANTSWAMPLANDS, "vibrantswamplands", true, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SIERRAVALLEY, "sierravalley", true, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.WEEPINGWITCHFOREST, "weeping_witch_forest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.WOODLANDS, "woodlands", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MAGICAL);
        BYGBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ZELKOVAFOREST, "zelkovaforest", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWY_EVERGREEN_CLEARING, "snowy_evergreen_clearing", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWY_EVERGREEN_HILLS, "snowy_evergreen_hills", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ENCHANTED_FOREST_HILLS, "enchanted_forest_hills", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.EBONY_HILLS, "ebony_hills", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.EVERGREEN_CLEARING, "evergreen_clearing", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.EVERGREEN_HILLS, "evergreen_hills", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.FUNGAL_PATCH, "fungal_patch", true, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.WEEPING_WTICH_CLEARING, "weeping_witch_clearing", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.PUMPKIN_FOREST, "pumpkin_forest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BAMBOO_FOREST, "bamboo_forest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.CHERRY_BLOSSOM_CLEARING, "cherry_blossom_clearing", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.CONIFEROUS_CLEARING, "coniferous_clearing", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ZELKOVA_CLEARING, "zelkova_clearing", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ASPEN_CLEARING, "aspen_clearing", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BOREALIS_CLEARING, "boreal_clearing", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.DECIDUOUS_CLEARING, "deciduous_clearing", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SEASONAL_DECIDUOUS_CLEARING, "seasonal_deciduous_clearing", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.GUIANA_CLEARING, "guiana_clearing", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.JACARANDA_CLEARING, "jacaranda_clearing", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWY_CONIFEROUS_CLEARING, "snowy_coniferous_clearing", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWY_DECIDUOUS_CLEARING, "snowy_deciduous_clearing", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.MAPLE_HILLS, "maple_hills", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BLACK_FOREST_CLEARING, "black_forest_clearing", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BLACK_FOREST_HILLS, "black_forest_hills", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.FOREST_FAULT, "forest_fault", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.FLOWERING_GROVE, "flowering_grove", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.FLOWERING_ENCHANTED_GROVE, "flowering_enchanted_grove", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.NORTHERN_FOREST, "northern_forest", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.LUSHREDDESERT, "lushreddesert", true, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SIERRARANGE, "sierrarange", true, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ALPINEFOOTHILLS, "alpinefoothills", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ASPENFORESTHILLS, "aspenforesthills", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BLUETAIGAHILLS, "bluetaigahills", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BLUEGIANTTAIGA, "giantbluesprucetaiga", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BLUFFPEAKS, "bluffpeaks", true, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BOREALFORESTHILLS, "borealforesthills", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.BOG, "bog", true, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.DECIDUOUSFORESTHILLS, "deciduousforesthills", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.CONIFEROUSFORESTHILLS, "coniferousforesthills", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.FRESHWATERLAKE, "freshwaterlake", true, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.FROZENLAKE, "frozenlake", true, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.GREATLAKEISLES, "greatlakeisles", true, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.JACARANDAFORESTHILLS, "jacarandaforesthills", true, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.MARSHLANDS, "marshlands", true, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.OASIS, "oasis", true, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.POLLUTEDLAKE, "pollutedlake", true, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.PRAIRIECLEARING, "prairieclearing", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.REDOAKFORESTHILLS, "redoakforesthills", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.RED_ROCK_LOWLANDS, "red_rock_lowlands", true, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.RED_ROCK_HIGHLANDS, "red_rock_highlands", true, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.WOODEDREDROCKMOUNTAINS, "wooded_red_rock_mountains", true, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SEASONALBIRCHFORESTHILLS, "seasonalbirchforesthills", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SEASONALDECIDUOUSFORESTHILLS, "seasonaldeciduousforesthills", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SEASONALFORESTHILLS, "seasonalforesthills", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SEASONALGIANTTAIGA, "giantseasonalsprucetaiga", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SEASONALTAIGAHILLS, "seasonaltaigahills", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWYBLUEGIANTTAIGA, "snowygiantbluetaiga", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWYBLUETAIGAHILLS, "snowybluetaigahills", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWYCONIFERFORESTHILLS, "snowyconiferousforesthills", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWYDECIDUOUSFORESTHILLS, "snowydeciduousforesthills", true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.TROPICALFUNGALRAINFORESTHILLS, "tropicalfungalrainforesthills", true, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.TROPICALRAINFORESTHILLS, "tropicalrainforesthills", true, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.WOODEDGRASSLANDPLATEAU, "woodedgrasslandplateau", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ZELKOVAFORESTHILLS, "zelkovaforesthills", true, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.FLOWERINGMEADOW, "floweringmeadow", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGSubBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.WOODEDMEADOW, "woodedmeadow", true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.ROCKYBEACH, "rockybeach", true, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWYROCKYBLACKBEACH, "snowyrockyblackbeach", true, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SNOWYBLACKBEACH, "snowyblackbeach", true, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.WHITEBEACH, "whitebeach", true, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.RAINBOWBEACH, "rainbowbeach", true, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WET, BiomeDictionary.Type.OVERWORLD);
        BYGBiomeRegistry.registerBYGBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.TROPICALISLAND, "tropicalisland", true, BiomeDictionary.Type.WET, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.JUNGLE);
        BYGBiomeRegistry.registerBYGBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.WARPEDDESERT, "warpeddesert", false, BiomeDictionary.Type.NETHER);
        BYGBiomeRegistry.registerBYGBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.SYTHIANTORRIDS, "sythiantorrids", false, BiomeDictionary.Type.NETHER);
        BYGBiomeRegistry.registerBYGBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.GLOWSTONEGARDENS, "glowstonegardens", false, BiomeDictionary.Type.NETHER);
        BYGBiomeRegistry.registerBYGEndBiome((IForgeRegistry<Biome>)registry, BYGBiomeList.IVISFIELDS, "ivis_fields", BiomeDictionary.Type.END);
        BYGBiomeGroup.initBYGBiomes();
        BYG.LOGGER.info("BYG: Biomes Registered!");
        if (((Boolean)BYGWorldConfig.vanillaBiomes.get()).booleanValue()) {
            BYGBiomeGroup.initDefaultBiomes();
        }
    }

    private static void registerBiome(IForgeRegistry<Biome> registry, Biome biome, String name, boolean spawn, BiomeDictionary.Type ... types) {
        registry.register(biome.setRegistryName("byg", name));
        if (spawn) {
            BiomeManager.addSpawnBiome((Biome)biome);
        }
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
    }

    private static void registerBYGBiome(IForgeRegistry<Biome> registry, Biome biome, String name, boolean spawn, BiomeDictionary.Type ... types) {
        registry.register(biome.setRegistryName("byg", name));
        if (spawn) {
            BiomeManager.addSpawnBiome((Biome)biome);
        }
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
    }

    private static void registerBYGEndBiome(IForgeRegistry<Biome> registry, Biome biome, String name, BiomeDictionary.Type ... types) {
        registry.register(biome.setRegistryName("byg", name));
        BYGEndBiomeProvider.biomeList.add(biome);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
    }

    private static void registerBYGSubBiome(IForgeRegistry<Biome> registry, Biome biome, String name, boolean spawn, BiomeDictionary.Type ... types) {
        registry.register(biome.setRegistryName("byg", name));
        if (spawn) {
            BiomeManager.addSpawnBiome((Biome)biome);
        }
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
    }
}

