/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.mixin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import voronoiaoc.byg.common.biomes.BiomeFog;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    private Minecraft field_78531_r;

    @Inject(at={@At(value="RETURN")}, method={"getFarPlaneDistance"}, cancellable=true)
    private void strengthenFog(CallbackInfoReturnable<Float> cir) {
        float originalFogStrength;
        ClientWorld world = this.field_78531_r.field_71441_e;
        BlockPos playerPos = this.field_78531_r.field_71439_g.func_180425_c();
        int transitionStart = 8;
        float defaultFogStrength = originalFogStrength = cir.getReturnValueF();
        defaultFogStrength *= defaultFogStrength;
        int x = playerPos.func_177958_n();
        int z = playerPos.func_177952_p();
        boolean modified = false;
        float accumulatedFogStrength = 0.0f;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int sampleX = x - transitionStart; sampleX <= x + transitionStart; ++sampleX) {
            pos.func_223471_o(sampleX);
            for (int sampleZ = z - transitionStart; sampleZ <= z + transitionStart; ++sampleZ) {
                pos.func_223472_q(sampleZ);
                Biome biome = world.func_226691_t_((BlockPos)pos);
                if (biome instanceof BiomeFog) {
                    modified = true;
                    float fogStrength = ((BiomeFog)biome).fogDistance(sampleX, sampleZ, originalFogStrength);
                    accumulatedFogStrength += fogStrength * fogStrength;
                    continue;
                }
                accumulatedFogStrength += defaultFogStrength;
            }
            if (modified) {
                float transitionSmoothness = 1089.0f;
                cir.setReturnValue((Object)Float.valueOf((float)Math.sqrt(accumulatedFogStrength / transitionSmoothness)));
                continue;
            }
            cir.setReturnValue((Object)Float.valueOf(cir.getReturnValueF()));
        }
    }
}

