/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.campanion.block;

import com.terraformersmc.campanion.block.CampanionBlocks;
import com.terraformersmc.campanion.block.RopeBridgePlanksBlock;
import com.terraformersmc.campanion.blockentity.RopeBridgePlanksBlockEntity;
import com.terraformersmc.campanion.blockentity.RopeBridgePostBlockEntity;
import com.terraformersmc.campanion.item.CampanionItems;
import com.terraformersmc.campanion.ropebridge.RopeBridge;
import com.terraformersmc.campanion.ropebridge.RopeBridgePlank;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import org.apache.commons.lang3.tuple.Pair;

public class RopeBridgePostBlock
extends RopeBridgePlanksBlock {
    private static final String CLICKED_POSITION_KEY = "ClickedPosition";

    public RopeBridgePostBlock(class_2248.class_2251 settings) {
        super(settings);
    }

    @Override
    public class_2586 method_10123(class_1922 view) {
        return new RopeBridgePostBlockEntity();
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 entity = world.method_8321(pos);
        if (entity instanceof RopeBridgePostBlockEntity) {
            RopeBridgePostBlockEntity be = (RopeBridgePostBlockEntity)entity;
            class_1799 stack = player.method_5998(hand);
            if (!world.field_9236) {
                if (stack.method_7909() == CampanionItems.ROPE) {
                    class_2487 tag = stack.method_7948();
                    if (tag.method_10573(CLICKED_POSITION_KEY, 4)) {
                        class_2338 clickedPos = class_2338.method_10092((long)tag.method_10537(CLICKED_POSITION_KEY));
                        tag.method_10551(CLICKED_POSITION_KEY);
                        RopeBridge bridge = new RopeBridge(clickedPos, pos);
                        Optional<class_2561> reason = bridge.getFailureReason();
                        if (!reason.isPresent() && !player.method_7337()) {
                            float xzDist = (float)Math.sqrt(pos.method_10262((class_2382)clickedPos));
                            int itemsToUse = Math.round(xzDist / 5.0f);
                            if (stack.method_7947() < itemsToUse) {
                                reason = Optional.of(new class_2588("message.campanion.rope_bridge.ropes", new Object[]{itemsToUse - stack.method_7947()}));
                            } else {
                                stack.method_7934(itemsToUse);
                            }
                        }
                        if (reason.isPresent()) {
                            player.method_7353(reason.get(), false);
                            return class_1269.field_5812;
                        }
                        List<Pair<class_2338, List<RopeBridgePlank>>> planks = bridge.generateBlocks(world);
                        long failed = planks.stream().map(Pair::getLeft).filter(p -> !world.method_8505(player, p)).count();
                        if (failed > 1L) {
                            player.method_7353((class_2561)new class_2588("message.campanion.rope_bridge.no_permission", new Object[]{failed}), true);
                            return class_1269.field_5812;
                        }
                        if (player.method_7337()) {
                            for (Pair<class_2338, List<RopeBridgePlank>> pair2 : planks) {
                                class_2338 planksPos = (class_2338)pair2.getLeft();
                                if (world.method_8320(planksPos).method_11620().method_15800() || world.method_8320(planksPos).method_11614() == CampanionBlocks.ROPE_BRIDGE_POST) continue;
                                player.method_7353((class_2561)new class_2588("message.campanion.rope_bridge.obstructed", new Object[]{planksPos.method_10263(), planksPos.method_10264(), planksPos.method_10260(), new class_2588(world.method_8320(planksPos).method_11614().method_9539(), new Object[0])}), false);
                                return class_1269.field_5811;
                            }
                            planks.forEach(pair -> {
                                class_2338 left = (class_2338)pair.getLeft();
                                class_2586 blockEntityTwo = world.method_8321(left);
                                if (!(blockEntityTwo instanceof RopeBridgePlanksBlockEntity)) {
                                    world.method_8501(left, CampanionBlocks.ROPE_BRIDGE_PLANKS.method_9564());
                                    blockEntityTwo = world.method_8321(left);
                                }
                                if (blockEntityTwo instanceof RopeBridgePlanksBlockEntity) {
                                    for (RopeBridgePlank plank : (List)pair.getRight()) {
                                        ((RopeBridgePlanksBlockEntity)blockEntityTwo).addPlank(plank);
                                    }
                                    blockEntityTwo.method_5431();
                                    ((RopeBridgePlanksBlockEntity)blockEntityTwo).sync();
                                }
                            });
                        } else {
                            be.getGhostPlanks().put(clickedPos, planks);
                            class_2586 blockEntityTwo = world.method_8321(clickedPos);
                            if (blockEntityTwo instanceof RopeBridgePostBlockEntity) {
                                ((RopeBridgePostBlockEntity)blockEntityTwo).getLinkedPositions().add(pos);
                            }
                        }
                        entity.method_5431();
                        be.sync();
                    } else {
                        tag.method_10544(CLICKED_POSITION_KEY, pos.method_10063());
                    }
                }
                if (stack.method_7909().method_7855(class_3489.field_15537) && this.incrementBridge(world, player, be, pos, true) && !player.method_7337()) {
                    stack.method_7934(1);
                }
            }
        }
        return class_1269.field_21466;
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 entity = world.method_8321(pos);
        if (entity instanceof RopeBridgePostBlockEntity) {
            for (class_2338 position : ((RopeBridgePostBlockEntity)entity).getLinkedPositions()) {
                class_2586 other = world.method_8321(position);
                if (!(other instanceof RopeBridgePostBlockEntity)) continue;
                ((RopeBridgePostBlockEntity)other).getLinkedPositions().remove(pos);
                ((RopeBridgePostBlockEntity)other).getGhostPlanks().remove(pos);
                if (world.field_9236) continue;
                other.method_5431();
                ((RopeBridgePostBlockEntity)other).sync();
            }
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (facing == class_2350.field_11033 && !world.method_8320(pos.method_10074()).method_20827((class_1922)world, pos, class_2350.field_11036)) {
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
        return super.method_9559(state, facing, neighborState, world, pos, neighborPos);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_20827((class_1922)world, pos, class_2350.field_11036);
    }

    private boolean incrementBridge(class_1937 world, class_1657 player, RopeBridgePostBlockEntity blockEntity, class_2338 pos, boolean generateLinked) {
        class_2338 otherPos = null;
        List<Pair<class_2338, List<RopeBridgePlank>>> list = null;
        Iterator<Map.Entry<class_2338, List<Pair<class_2338, List<RopeBridgePlank>>>>> iterator = blockEntity.getGhostPlanks().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<class_2338, List<Pair<class_2338, List<RopeBridgePlank>>>> entry = iterator.next();
            otherPos = entry.getKey();
            list = entry.getValue();
        }
        if (list == null || otherPos == null || list.isEmpty()) {
            if (generateLinked) {
                for (class_2338 position : blockEntity.getLinkedPositions()) {
                    class_2586 linkedEntity = world.method_8321(position);
                    if (!(linkedEntity instanceof RopeBridgePostBlockEntity)) continue;
                    return this.incrementBridge(world, player, (RopeBridgePostBlockEntity)linkedEntity, position, false);
                }
            }
            return false;
        }
        for (int i = 0; i < 5 && !list.isEmpty(); ++i) {
            for (Pair<class_2338, List<RopeBridgePlank>> plankPair : list) {
                class_2338 planksPos = (class_2338)plankPair.getLeft();
                List planks = (List)plankPair.getRight();
                class_2586 be = world.method_8321(planksPos);
                for (int j = 0; j < Math.min(5 - i, planks.size()); ++j) {
                    if (!(be instanceof RopeBridgePlanksBlockEntity)) {
                        class_2680 state = world.method_8320(planksPos);
                        if (!state.method_11620().method_15800()) {
                            player.method_7353((class_2561)new class_2588("message.campanion.rope_bridge.obstructed", new Object[]{planksPos.method_10263(), planksPos.method_10264(), planksPos.method_10260(), new class_2588(world.method_8320(planksPos).method_11614().method_9539(), new Object[0])}), false);
                            return false;
                        }
                        world.method_8501(planksPos, CampanionBlocks.ROPE_BRIDGE_PLANKS.method_9564());
                        be = world.method_8321(planksPos);
                    }
                    if (!(be instanceof RopeBridgePlanksBlockEntity)) continue;
                    RopeBridgePlanksBlockEntity planksBlockEntity = (RopeBridgePlanksBlockEntity)be;
                    RopeBridgePlank plank = (RopeBridgePlank)planks.get(0);
                    planksBlockEntity.addPlank(plank);
                    planks.remove(plank);
                    planksBlockEntity.method_5431();
                    planksBlockEntity.sync();
                    if (plank.isMaster()) {
                        ++i;
                        continue;
                    }
                    --j;
                }
            }
            list.removeIf(p -> ((List)p.getRight()).isEmpty());
        }
        if (list.isEmpty()) {
            if (!world.field_9236) {
                blockEntity.getLinkedPositions().remove(otherPos);
                blockEntity.getGhostPlanks().remove(otherPos);
                blockEntity.method_5431();
                blockEntity.sync();
                class_2586 other = world.method_8321(otherPos);
                if (other instanceof RopeBridgePostBlockEntity) {
                    ((RopeBridgePostBlockEntity)other).getLinkedPositions().remove(pos);
                    ((RopeBridgePostBlockEntity)other).getGhostPlanks().remove(pos);
                    other.method_5431();
                    ((RopeBridgePostBlockEntity)other).sync();
                }
            }
            player.method_7353((class_2561)new class_2588("message.campanion.rope_bridge.finished", new Object[0]), false);
        } else {
            double counted = list.stream().flatMap(p -> ((List)p.getRight()).stream()).filter(RopeBridgePlank::isMaster).count();
            player.method_7353((class_2561)new class_2588("message.campanion.rope_bridge.constructed", new Object[]{Math.round(counted / 5.0) + 1L}), true);
        }
        return true;
    }

    @Override
    protected boolean canBeCompletelyRemoved() {
        return false;
    }
}

