/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.campanion.blockentity;

import com.terraformersmc.campanion.blockentity.CampanionBlockEntities;
import com.terraformersmc.campanion.ropebridge.RopeBridgePlank;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.fabric.api.block.entity.BlockEntityClientSerializable;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;

public class RopeBridgePlanksBlockEntity
extends class_2586
implements BlockEntityClientSerializable {
    private final List<RopeBridgePlank> planks = new ArrayList<RopeBridgePlank>();
    private class_265 fullPlankShape;
    private class_265 cutPlankShape;
    private class_265 slimPlankShape;

    public RopeBridgePlanksBlockEntity(class_2591<?> type) {
        super(type);
    }

    public RopeBridgePlanksBlockEntity() {
        super(CampanionBlockEntities.ROPE_BRIDGE_PLANK);
    }

    public List<RopeBridgePlank> getPlanks() {
        return Collections.unmodifiableList(this.planks);
    }

    public void addPlank(RopeBridgePlank plank) {
        this.planks.add(plank);
        this.fullPlankShape = null;
        this.cutPlankShape = null;
        this.slimPlankShape = null;
    }

    public boolean removeBroken() {
        boolean ret = this.planks.removeIf(RopeBridgePlank::isBroken);
        this.fullPlankShape = null;
        this.cutPlankShape = null;
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.sync();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 11);
        }
        return ret;
    }

    public class_265 getOutlineShape() {
        if (this.fullPlankShape != null) {
            return this.fullPlankShape;
        }
        this.fullPlankShape = this.generateShape(true);
        return this.fullPlankShape;
    }

    public class_265 getCollisionShape() {
        if (this.slimPlankShape != null) {
            return this.slimPlankShape;
        }
        this.slimPlankShape = class_259.method_1082((class_265)this.generateShape(false), (class_265)class_259.method_1077(), (class_247)class_247.field_16896);
        return this.slimPlankShape;
    }

    public class_265 getRaytraceShape() {
        if (this.cutPlankShape != null) {
            return this.cutPlankShape;
        }
        this.cutPlankShape = class_259.method_1082((class_265)this.generateShape(true), (class_265)class_259.method_1077(), (class_247)class_247.field_16896);
        return this.cutPlankShape;
    }

    private class_265 generateStopperShape(boolean full, float x, float y, float z, double sin, double cos) {
        float size = 0.15625f * (full ? 1.0f : 0.25f);
        return class_259.method_1081((double)(-size), (double)0.0, (double)(-size), (double)size, (double)1.03125, (double)size).method_1096((double)x + sin, (double)y, (double)z - cos);
    }

    public class_265 generateShape(boolean full) {
        class_265 shape = class_259.method_1073();
        if (this.planks.isEmpty() || this.forceRenderStopper()) {
            shape = class_259.method_1084((class_265)shape, (class_265)this.generateStopperShape(full, 0.5f, 0.0f, 0.5f, 0.0, -0.496875));
            shape = class_259.method_1084((class_265)shape, (class_265)this.generateStopperShape(full, 0.5f, 0.0f, 0.5f, 0.0, 0.496875));
        }
        for (RopeBridgePlank plank : this.planks) {
            double sin = 0.496875 * Math.sin(plank.getyAngle());
            double cos = 0.496875 * Math.cos(plank.getyAngle());
            double xRange = 0.09375 + Math.abs(sin);
            double yRange = Math.abs(Math.sin(plank.getTiltAngle())) * 0.25 / 2.0 + 0.09375;
            double zRange = 0.09375 + Math.abs(cos);
            double minY = plank.getDeltaPosition().field_1351 - yRange;
            double maxY = plank.getDeltaPosition().field_1351 + yRange;
            double minX = plank.getDeltaPosition().field_1352 - xRange;
            double maxX = plank.getDeltaPosition().field_1352 + xRange;
            double minZ = plank.getDeltaPosition().field_1350 - zRange;
            double maxZ = plank.getDeltaPosition().field_1350 + zRange;
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
            if (!plank.isStopper()) continue;
            shape = class_259.method_1084((class_265)shape, (class_265)this.generateStopperShape(full, (float)plank.getDeltaPosition().field_1352, (float)plank.getDeltaPosition().field_1351, (float)plank.getDeltaPosition().field_1350, -sin, -cos));
            shape = class_259.method_1084((class_265)shape, (class_265)this.generateStopperShape(full, (float)plank.getDeltaPosition().field_1352, (float)plank.getDeltaPosition().field_1351, (float)plank.getDeltaPosition().field_1350, sin, cos));
        }
        return shape;
    }

    public boolean forceRenderStopper() {
        return false;
    }

    public void method_11014(class_2487 tag) {
        this.fromClientTag(tag);
        super.method_11014(tag);
    }

    public class_2487 method_11007(class_2487 tag) {
        return this.toClientTag(super.method_11007(tag));
    }

    public void fromClientTag(class_2487 tag) {
        this.planks.clear();
        this.planks.addAll(this.getFrom(tag.method_10554("Planks", 10)));
        this.fullPlankShape = null;
        this.cutPlankShape = null;
        this.slimPlankShape = null;
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 11);
        }
    }

    public class_2487 toClientTag(class_2487 tag) {
        tag.method_10566("Planks", (class_2520)this.writeTo(this.planks));
        return tag;
    }

    protected List<RopeBridgePlank> getFrom(class_2499 list) {
        ArrayList<RopeBridgePlank> out = new ArrayList<RopeBridgePlank>();
        for (class_2520 nbt : list) {
            out.add(RopeBridgePlank.deserialize((class_2487)nbt));
        }
        return out;
    }

    protected class_2499 writeTo(List<RopeBridgePlank> planks) {
        class_2499 list = new class_2499();
        for (RopeBridgePlank plank : planks) {
            list.add((Object)RopeBridgePlank.serialize(plank));
        }
        return list;
    }
}

