/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.campanion.ropebridge;

import com.terraformersmc.campanion.ropebridge.RopeBridgePlank;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class RopeBridge {
    public static final double PLANK_WIDTH = 0.25;
    public static final double PLANK_LENGTH = 0.99375;
    public static final double MIN_PLANK_PADDING = 0.125;
    public static final int PLANKS_PER_ROPE = 3;
    public static final int PLANK_VARIANT_TEXTURES = 2;
    public static final int PLANKS_PER_ITEM = 5;
    public static final int ROPE_WIDTH = 1;
    public static final float UNDER_ROPE_DIST_FROM_EDGE = 2.0f;
    public static final float ROPE_LENGTH = 14.5f;
    public static final int KNOT_SIZE = 1;
    public static final int BLOCKS_PER_ROPE = 5;
    public static final int STOPPER_WIDTH = 4;
    public static final int STOPPER_HEIGHT = 16;
    public static final double LIMITING_ANGLE = 0.7853981633974483;
    public static final double LIMITING_XZ_DIST = 250.0;
    public static final double WEIGHT_OF_PLANK = 0.03125;
    private final class_243 from;
    private final class_243 to;
    private final double angle;
    private final int totalPlanks;
    private final double a;
    private final double b;
    private final double c;

    public RopeBridge(class_2338 from, class_2338 to) {
        this.from = new class_243((class_2382)from).method_1031(0.5, 0.0, 0.5);
        this.to = new class_243((class_2382)to).method_1031(0.5, 0.0, 0.5);
        this.angle = Math.atan2(this.to.method_10215() - this.from.method_10215(), this.to.method_10216() - this.from.method_10216());
        double length = this.from.method_1022(this.to);
        double totalPlankSize = 0.375;
        this.totalPlanks = class_3532.method_15357((double)(length / totalPlankSize));
        double s = from.method_10264();
        double m = (double)(from.method_10264() + to.method_10264()) / 2.0 - 0.03125 * (double)this.totalPlanks;
        double e = to.method_10264();
        this.a = s - 2.0 * m + e;
        this.b = -2.0 * s + 2.0 * m;
        this.c = s;
    }

    public Optional<class_2561> getFailureReason() {
        double deltaX = this.to.method_10216() - this.from.method_10216();
        double deltaZ = this.to.method_10215() - this.from.method_10215();
        double xzDist = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        double theta = Math.abs(Math.atan((this.to.method_10214() - this.from.method_10214()) / xzDist));
        if (this.to.equals((Object)this.from)) {
            return Optional.of(new class_2588("message.campanion.rope_bridge.same_position", new Object[0]));
        }
        if (theta > 0.7853981633974483) {
            return Optional.of(new class_2588("message.campanion.rope_bridge.angle", new Object[]{(double)Math.round(theta * 1800.0 / Math.PI) / 10.0, Float.valueOf((float)Math.round(450.0) / 10.0f)}));
        }
        if (xzDist > 250.0) {
            return Optional.of(new class_2588("message.campanion.rope_bridge.length", new Object[]{(double)Math.round(xzDist * 10.0) / 10.0, (double)Math.round(2500.0) / 10.0}));
        }
        return Optional.empty();
    }

    public List<Pair<class_2338, List<RopeBridgePlank>>> generateBlocks(class_1937 world) {
        double hl = 0.496875;
        class_2338[] positionOrder = new class_2338[this.totalPlanks + 1];
        HashMap<class_2338, List<Pair<Float, RopeBridgePlank>>> map = new HashMap<class_2338, List<Pair<Float, RopeBridgePlank>>>();
        this.generateBlocks(world, positionOrder, 0.0, 0.0, map);
        this.generateBlocks(world, positionOrder, hl * Math.sin(this.angle), -hl * Math.cos(this.angle), map);
        this.generateBlocks(world, positionOrder, -hl * Math.sin(this.angle), hl * Math.cos(this.angle), map);
        LinkedList<Triple> fulList = new LinkedList<Triple>();
        map.forEach((pos, pairs) -> {
            for (Pair pair : pairs) {
                fulList.add(Triple.of((Object)pos, (Object)pair.getLeft(), (Object)pair.getRight()));
            }
        });
        fulList.sort(Comparator.comparing(Triple::getMiddle));
        LinkedList<Pair<class_2338, List<RopeBridgePlank>>> out = new LinkedList<Pair<class_2338, List<RopeBridgePlank>>>();
        for (Triple triple : fulList) {
            LinkedList<Object> list;
            Optional<List> first = out.stream().filter(blockPosListPair -> ((class_2338)blockPosListPair.getLeft()).equals(triple.getLeft())).map(Pair::getRight).findFirst();
            if (first.isPresent()) {
                list = first.get();
            } else {
                list = new LinkedList<Object>();
                out.add((Pair<class_2338, List<RopeBridgePlank>>)Pair.of((Object)triple.getLeft(), list));
            }
            list.add(triple.getRight());
        }
        return out;
    }

    private void generateBlocks(class_1937 world, class_2338[] positionOrder, double xOff, double zOff, Map<class_2338, List<Pair<Float, RopeBridgePlank>>> map) {
        boolean master = xOff == 0.0 && zOff == 0.0;
        double deltaX = this.to.method_10216() - this.from.method_10216();
        double deltaZ = this.to.method_10215() - this.from.method_10215();
        class_2338 fromPos = new class_2338(this.from);
        class_2338 toPos = new class_2338(this.to);
        int index = 0;
        int offset = world.field_9229.nextInt(3);
        class_243 calculatedPosition = new class_243(xOff + this.from.method_10216(), this.from.method_10214(), zOff + this.from.method_10215());
        for (int i = 0; i <= this.totalPlanks; ++i) {
            boolean flat;
            double d = (double)i / (double)this.totalPlanks;
            double nextD = Math.min((double)(i + 1) / (double)this.totalPlanks, 1.0);
            class_2338 pos = new class_2338(calculatedPosition);
            float ropesSubtract = 0.0f;
            boolean bl = flat = pos.equals((Object)fromPos) || pos.equals((Object)toPos);
            if (pos.equals((Object)fromPos.method_10074()) || pos.equals((Object)toPos.method_10074())) {
                pos = pos.method_10084();
                ropesSubtract = (float)((double)pos.method_10264() - calculatedPosition.field_1351);
                calculatedPosition = new class_243(calculatedPosition.field_1352, (double)pos.method_10264(), calculatedPosition.field_1350);
                flat = true;
            }
            class_243 newPos = new class_243(xOff + this.from.method_10216() + deltaX * nextD, this.beizerCurve(nextD), zOff + this.from.method_10215() + deltaZ * nextD);
            if (master || !positionOrder[index].equals((Object)pos)) {
                class_243 vec3d = new class_243(RopeBridge.floorMod(calculatedPosition.field_1352, 1.0) - xOff, RopeBridge.floorMod(calculatedPosition.field_1351 + 0.001, 1.0), RopeBridge.floorMod(calculatedPosition.field_1350, 1.0) - zOff);
                double tiltAngle = Math.atan(this.beizerCurveGradient(d) / Math.sqrt(deltaX * deltaX + deltaZ * deltaZ));
                if (Double.isNaN(tiltAngle)) {
                    tiltAngle = 0.0;
                }
                map.computeIfAbsent(pos, p -> new LinkedList()).add(Pair.of((Object)Float.valueOf((float)index + (master ? 0.0f : 0.5f)), (Object)new RopeBridgePlank(fromPos, toPos, vec3d, this.angle, tiltAngle, (float)newPos.method_1020(calculatedPosition).method_1033(), ropesSubtract, world.field_9229.nextInt(128), flat, master, (offset + index) % 3 == 0, i == 0 || i == this.totalPlanks)));
            }
            if (master) {
                positionOrder[index] = pos;
            }
            ++index;
            calculatedPosition = newPos;
        }
    }

    private double beizerCurve(double t) {
        return this.a * t * t + this.b * t + this.c;
    }

    private double beizerCurveGradient(double t) {
        return 2.0 * this.a * t + this.b;
    }

    public static double floorMod(double d, double e) {
        return (d % e + e) % e;
    }
}

