/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.dossier;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.terraformersmc.dossier.data.DossierBlockTagsProvider;
import com.terraformersmc.dossier.data.DossierItemTagsProvider;
import com.terraformersmc.dossier.data.DossierLootTablesProvider;
import com.terraformersmc.dossier.data.DossierRecipesProvider;
import com.terraformersmc.dossier.util.CommonValues;
import com.terraformersmc.dossier.util.TransformerFunction;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_192;
import net.minecraft.class_1935;
import net.minecraft.class_201;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_59;
import net.minecraft.class_77;
import net.minecraft.class_79;
import org.apache.commons.lang3.ArrayUtils;

public abstract class Dossier<P extends class_2405 & Consumer<F>, F> {
    protected P provider;
    private static final Map<String, EnumMap<Type, class_2405>> DATA_PROVIDERS = new HashMap<String, EnumMap<Type, class_2405>>();
    private static final Map<String, class_2403> DATA_GENERATORS = new HashMap<String, class_2403>();

    public static void generateData(String modId, boolean enabled, Builder dossiers) {
        if (FabricLoader.getInstance().isDevelopmentEnvironment() && enabled) {
            dossiers.blockTagsDossiers.forEach(dossier -> dossier.run(modId));
            dossiers.itemTagsDossiers.forEach(dossier -> dossier.run(modId));
            dossiers.recipesDossiers.forEach(dossier -> dossier.run(modId));
            dossiers.lootTablesDossiers.forEach(dossier -> dossier.run(modId));
            try {
                DATA_GENERATORS.get(modId).method_10315();
            }
            catch (IOException | NullPointerException e) {
                e.printStackTrace();
            }
        }
    }

    protected void run(String modId) {
        this.setProvider(modId);
        ((Consumer)this.getProvider()).accept(this.getCustomFunction());
    }

    protected abstract void setProvider(String var1);

    public P getProvider() {
        return this.provider;
    }

    public abstract F getCustomFunction();

    private static class_2405 getProvider(String modId, Type type) {
        if (!DATA_PROVIDERS.containsKey(modId)) {
            Path output = Paths.get("dossier_generated/" + modId, new String[0]);
            class_2403 generator = new class_2403(output, Collections.emptyList());
            EnumMap providers = Maps.newEnumMap(Type.class);
            providers.put(Type.BLOCK_TAGS, new DossierBlockTagsProvider(generator));
            providers.put(Type.ITEM_TAGS, new DossierItemTagsProvider(generator));
            providers.put(Type.RECIPES, new DossierRecipesProvider(generator));
            providers.put(Type.LOOT_TABLES, new DossierLootTablesProvider(generator));
            providers.forEach((t, provider) -> generator.method_10314(provider));
            DATA_GENERATORS.put(modId, generator);
            DATA_PROVIDERS.put(modId, providers);
        }
        return DATA_PROVIDERS.get(modId).get((Object)type);
    }

    private static enum Type {
        BLOCK_TAGS,
        ITEM_TAGS,
        RECIPES,
        LOOT_TABLES;

    }

    public static class Builder {
        public List<ItemTagsDossier> itemTagsDossiers = new LinkedList<ItemTagsDossier>();
        public List<BlockTagsDossier> blockTagsDossiers = new LinkedList<BlockTagsDossier>();
        public List<RecipesDossier> recipesDossiers = new LinkedList<RecipesDossier>();
        public List<LootTablesDossier> lootTablesDossiers = new LinkedList<LootTablesDossier>();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder add(ItemTagsDossier dossier) {
            this.itemTagsDossiers.add(dossier);
            return this;
        }

        public Builder add(BlockTagsDossier dossier) {
            this.blockTagsDossiers.add(dossier);
            return this;
        }

        public Builder add(RecipesDossier dossier) {
            this.recipesDossiers.add(dossier);
            return this;
        }

        public Builder add(LootTablesDossier dossier) {
            this.lootTablesDossiers.add(dossier);
            return this;
        }
    }

    public static abstract class LootTablesDossier
    extends Dossier<DossierLootTablesProvider, Runnable> {
        @Override
        protected void setProvider(String modId) {
            this.provider = (DossierLootTablesProvider)Dossier.getProvider(modId, Type.LOOT_TABLES);
        }

        protected abstract void addLootTables();

        protected void addDrop(class_2248 block, class_1935 loot) {
            this.addDrop(block, LootTablesDossier.createBlockLootTable(loot));
        }

        protected void addSelfDrop(class_2248 block) {
            this.addDrop(block, (class_1935)block);
        }

        protected void addDrop(class_2248 block, class_52.class_53 builder) {
            List<Pair<class_2960, class_52.class_53>> lootTables = ((DossierLootTablesProvider)this.provider).lootTables.get(class_173.field_1172);
            lootTables.add((Pair<class_2960, class_52.class_53>)new Pair((Object)block.method_9580(), (Object)builder));
            ((DossierLootTablesProvider)this.provider).lootTables.put(class_173.field_1172, lootTables);
        }

        protected static <T> T addDefaultConditions(class_192<T> conditions) {
            return (T)conditions.method_840(class_201.method_871());
        }

        protected static class_52.class_53 createBlockLootTable(class_1935 item) {
            return class_52.method_324().method_336((class_55.class_56)LootTablesDossier.addDefaultConditions(class_55.method_347().method_352((class_59)class_44.method_289((int)1)).method_351((class_79.class_80)class_77.method_411((class_1935)item))));
        }

        @Override
        public Runnable getCustomFunction() {
            return this::addLootTables;
        }
    }

    public static abstract class RecipesDossier
    extends Dossier<DossierRecipesProvider, Consumer<Consumer<class_2444>>> {
        protected class_2066.class_2068 conditionsFrom(class_1935 item) {
            return this.conditionsFrom(class_2073.class_2074.method_8973().method_8977(item).method_8976());
        }

        protected class_2066.class_2068 conditionsFrom(class_3494<class_1792> tag) {
            return this.conditionsFrom(this.itemPredicateOf(tag));
        }

        protected class_2073 itemPredicateOf(class_3494<class_1792> tag) {
            return class_2073.class_2074.method_8973().method_8975(tag).method_8976();
        }

        protected class_2066.class_2068 conditionsFrom(class_2073 ... items) {
            return new class_2066.class_2068(class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, items);
        }

        @Override
        protected void setProvider(String modId) {
            this.provider = (DossierRecipesProvider)Dossier.getProvider(modId, Type.RECIPES);
        }

        protected abstract void addRecipes(Consumer<class_2444> var1);

        @Override
        public Consumer<Consumer<class_2444>> getCustomFunction() {
            return this::addRecipes;
        }
    }

    public static abstract class ItemTagsDossier
    extends Dossier<DossierItemTagsProvider, Runnable>
    implements CommonValues {
        protected class_3494.class_3495<class_1792> get(class_3494<class_1792> tag) {
            return ((DossierItemTagsProvider)this.provider).method_10512(tag);
        }

        protected void copyFromBlock(class_3494<class_1792> tag, class_3494<class_2248> blockTag) {
            ((DossierItemTagsProvider)this.provider).method_10505(blockTag, tag);
        }

        protected class_3494.class_3495<class_1792> add(class_3494<class_1792> tag, class_1792 ... items) {
            return this.get(tag).method_15150((Object[])items);
        }

        protected class_3494.class_3495<class_1792> add(class_3494<class_1792> tag, class_3494<class_1792> ... tags) {
            class_3494.class_3495<class_1792> builder = this.get(tag);
            for (class_3494<class_1792> itemTag : tags) {
                builder.method_15148(itemTag);
            }
            return builder;
        }

        protected class_3494.class_3495<class_1792> addTransformed(class_3494<class_1792> tag, TransformerFunction<String, String> transformer, String namespace, String pathTemplate, String ... args) {
            return this.add(tag, (class_1792[])transformer.apply(pathTemplate, (String[])args).stream().map(transformeedPath -> (class_1792)class_2378.field_11142.method_10223(new class_2960(namespace, transformeedPath))).toArray(class_1792[]::new));
        }

        protected class_3494.class_3495<class_1792> addReplaceTransformed(class_3494<class_1792> tag, String namespace, String pathTemplate, String key, String ... values) {
            return this.addTransformed(tag, TransformerFunction.REPLACE_TRANSFORMER, namespace, pathTemplate, (String[])ArrayUtils.add((Object[])values, (int)0, (Object)key));
        }

        @Override
        protected void setProvider(String modId) {
            this.provider = (DossierItemTagsProvider)Dossier.getProvider(modId, Type.ITEM_TAGS);
        }

        protected abstract void addItemTags();

        @Override
        public Runnable getCustomFunction() {
            return this::addItemTags;
        }
    }

    public static abstract class BlockTagsDossier
    extends Dossier<DossierBlockTagsProvider, Runnable>
    implements CommonValues {
        protected class_3494.class_3495<class_2248> get(class_3494<class_2248> tag) {
            return ((DossierBlockTagsProvider)this.provider).method_10512(tag);
        }

        protected class_3494.class_3495<class_2248> add(class_3494<class_2248> tag, class_2248 ... blocks) {
            class_3494.class_3495<class_2248> builder = ((DossierBlockTagsProvider)this.provider).method_10512(tag);
            return builder.method_15150((Object[])blocks);
        }

        protected class_3494.class_3495<class_2248> add(class_3494<class_2248> tag, class_3494<class_2248> ... tags) {
            class_3494.class_3495<class_2248> builder = this.get(tag);
            for (class_3494<class_2248> blockTag : tags) {
                builder.method_15148(blockTag);
            }
            return builder;
        }

        protected class_3494.class_3495<class_2248> addTransformed(class_3494<class_2248> tag, TransformerFunction<String, String> transformer, String namespace, String pathTemplate, String ... args) {
            return this.add(tag, (class_2248[])transformer.apply(pathTemplate, (String[])args).stream().map(transformeedPath -> (class_2248)class_2378.field_11146.method_10223(new class_2960(namespace, transformeedPath))).toArray(class_2248[]::new));
        }

        protected class_3494.class_3495<class_2248> addReplaceTransformed(class_3494<class_2248> tag, String namespace, String pathTemplate, String key, String ... values) {
            return this.addTransformed(tag, TransformerFunction.REPLACE_TRANSFORMER, namespace, pathTemplate, (String[])ArrayUtils.add((Object[])values, (int)0, (Object)key));
        }

        @Override
        protected void setProvider(String modId) {
            this.provider = (DossierBlockTagsProvider)Dossier.getProvider(modId, Type.BLOCK_TAGS);
        }

        protected abstract void addBlockTags();

        @Override
        public Runnable getCustomFunction() {
            return this::addBlockTags;
        }
    }
}

