/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.dossier.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.terraformersmc.dossier.util.DefaultedHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_58;
import net.minecraft.class_60;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DossierLootTablesProvider
implements class_2405,
Consumer<Runnable> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final class_2403 generator;
    public final Map<class_176, List<Pair<class_2960, class_52.class_53>>> lootTables = new DefaultedHashMap<class_176, ArrayList>(Lists.newArrayList());
    protected final List<Pair<Supplier<Consumer<BiConsumer<class_2960, class_52.class_53>>>, class_176>> lootTypeGenerators;
    private Runnable onRun;

    public DossierLootTablesProvider(class_2403 generator) {
        this.generator = generator;
        this.lootTypeGenerators = Lists.newArrayList();
    }

    private static Path getOutput(Path rootOutput, class_2960 lootTableId) {
        return rootOutput.resolve("data/" + lootTableId.method_12836() + "/loot_tables/" + lootTableId.method_12832() + ".json");
    }

    public void method_10319(class_2408 cache) {
        Path path = this.generator.method_10313();
        HashMap map = Maps.newHashMap();
        this.onRun.run();
        this.lootTables.forEach((type, tables) -> tables.forEach(table -> {
            class_52.class_53 builder;
            class_2960 id = (class_2960)table.getFirst();
            if (map.put(id, (builder = (class_52.class_53)table.getSecond()).method_334(type).method_338()) != null) {
                throw new IllegalStateException("Duplicate loot table " + id);
            }
        }));
        class_176 genericType = class_173.field_1177;
        class_58 lootTableReporter = new class_58(genericType, id -> null, map::get);
        Sets.SetView missingBuiltIns = Sets.difference((Set)class_39.method_270(), map.keySet());
        for (class_2960 id2 : missingBuiltIns) {
            lootTableReporter.method_360("Missing built-in table: " + id2);
        }
        map.forEach((identifierx, lootTable) -> {
            Path path2 = DossierLootTablesProvider.getOutput(path, identifierx);
            try {
                class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)class_60.method_372((class_52)lootTable), (Path)path2);
            }
            catch (IOException var6) {
                LOGGER.error("Couldn't save loot table {}", (Object)path2, (Object)var6);
            }
        });
    }

    public String method_10321() {
        return "Dossier Loot Tables";
    }

    @Override
    public void accept(Runnable onRun) {
        this.onRun = onRun;
    }
}

